/*
 * sh7372 processor support - PFC hardware block
 *
 * Copyright (C) 2010  Kuninori Morimoto <morimoto.kuninori@renesas.com>
 *
 * Based on
 * sh7367 processor support - PFC hardware block
 * Copyright (C) 2010  Magnus Damm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <linux/kernel.h>
#include <mach/irqs.h>
#include <mach/sh7372.h>

#include "sh_pfc.h"

#define CPU_ALL_PORT(fn, pfx, sfx) \
	PORT_10(fn, pfx, sfx),		PORT_90(fn, pfx, sfx), \
	PORT_10(fn, pfx##10, sfx),	PORT_10(fn, pfx##11, sfx), \
	PORT_10(fn, pfx##12, sfx),	PORT_10(fn, pfx##13, sfx), \
	PORT_10(fn, pfx##14, sfx),	PORT_10(fn, pfx##15, sfx), \
	PORT_10(fn, pfx##16, sfx),	PORT_10(fn, pfx##17, sfx), \
	PORT_10(fn, pfx##18, sfx),	PORT_1(fn, pfx##190, sfx)

enum {
	PINMUX_RESERVED = 0,

	/* PORT0_DATA -> PORT190_DATA */
	PINMUX_DATA_BEGIN,
	PORT_ALL(DATA),
	PINMUX_DATA_END,

	/* PORT0_IN -> PORT190_IN */
	PINMUX_INPUT_BEGIN,
	PORT_ALL(IN),
	PINMUX_INPUT_END,

	/* PORT0_IN_PU -> PORT190_IN_PU */
	PINMUX_INPUT_PULLUP_BEGIN,
	PORT_ALL(IN_PU),
	PINMUX_INPUT_PULLUP_END,

	/* PORT0_IN_PD -> PORT190_IN_PD */
	PINMUX_INPUT_PULLDOWN_BEGIN,
	PORT_ALL(IN_PD),
	PINMUX_INPUT_PULLDOWN_END,

	/* PORT0_OUT -> PORT190_OUT */
	PINMUX_OUTPUT_BEGIN,
	PORT_ALL(OUT),
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PORT_ALL(FN_IN),	/* PORT0_FN_IN	-> PORT190_FN_IN */
	PORT_ALL(FN_OUT),	/* PORT0_FN_OUT	-> PORT190_FN_OUT */
	PORT_ALL(FN0),		/* PORT0_FN0	-> PORT190_FN0 */
	PORT_ALL(FN1),		/* PORT0_FN1	-> PORT190_FN1 */
	PORT_ALL(FN2),		/* PORT0_FN2	-> PORT190_FN2 */
	PORT_ALL(FN3),		/* PORT0_FN3	-> PORT190_FN3 */
	PORT_ALL(FN4),		/* PORT0_FN4	-> PORT190_FN4 */
	PORT_ALL(FN5),		/* PORT0_FN5	-> PORT190_FN5 */
	PORT_ALL(FN6),		/* PORT0_FN6	-> PORT190_FN6 */
	PORT_ALL(FN7),		/* PORT0_FN7	-> PORT190_FN7 */

	MSEL1CR_31_0,	MSEL1CR_31_1,
	MSEL1CR_30_0,	MSEL1CR_30_1,
	MSEL1CR_29_0,	MSEL1CR_29_1,
	MSEL1CR_28_0,	MSEL1CR_28_1,
	MSEL1CR_27_0,	MSEL1CR_27_1,
	MSEL1CR_26_0,	MSEL1CR_26_1,
	MSEL1CR_16_0,	MSEL1CR_16_1,
	MSEL1CR_15_0,	MSEL1CR_15_1,
	MSEL1CR_14_0,	MSEL1CR_14_1,
	MSEL1CR_13_0,	MSEL1CR_13_1,
	MSEL1CR_12_0,	MSEL1CR_12_1,
	MSEL1CR_9_0,	MSEL1CR_9_1,
	MSEL1CR_8_0,	MSEL1CR_8_1,
	MSEL1CR_7_0,	MSEL1CR_7_1,
	MSEL1CR_6_0,	MSEL1CR_6_1,
	MSEL1CR_4_0,	MSEL1CR_4_1,
	MSEL1CR_3_0,	MSEL1CR_3_1,
	MSEL1CR_2_0,	MSEL1CR_2_1,
	MSEL1CR_0_0,	MSEL1CR_0_1,

	MSEL3CR_27_0,	MSEL3CR_27_1,
	MSEL3CR_26_0,	MSEL3CR_26_1,
	MSEL3CR_21_0,	MSEL3CR_21_1,
	MSEL3CR_20_0,	MSEL3CR_20_1,
	MSEL3CR_15_0,	MSEL3CR_15_1,
	MSEL3CR_9_0,	MSEL3CR_9_1,
	MSEL3CR_6_0,	MSEL3CR_6_1,

	MSEL4CR_19_0,	MSEL4CR_19_1,
	MSEL4CR_18_0,	MSEL4CR_18_1,
	MSEL4CR_17_0,	MSEL4CR_17_1,
	MSEL4CR_16_0,	MSEL4CR_16_1,
	MSEL4CR_15_0,	MSEL4CR_15_1,
	MSEL4CR_14_0,	MSEL4CR_14_1,
	MSEL4CR_10_0,	MSEL4CR_10_1,
	MSEL4CR_6_0,	MSEL4CR_6_1,
	MSEL4CR_4_0,	MSEL4CR_4_1,
	MSEL4CR_1_0,	MSEL4CR_1_1,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,

	/* IRQ */
	IRQ0_6_MARK,	IRQ0_162_MARK,	IRQ1_MARK,	IRQ2_4_MARK,
	IRQ2_5_MARK,	IRQ3_8_MARK,	IRQ3_16_MARK,	IRQ4_17_MARK,
	IRQ4_163_MARK,	IRQ5_MARK,	IRQ6_39_MARK,	IRQ6_164_MARK,
	IRQ7_40_MARK,	IRQ7_167_MARK,	IRQ8_41_MARK,	IRQ8_168_MARK,
	IRQ9_42_MARK,	IRQ9_169_MARK,	IRQ10_MARK,	IRQ11_MARK,
	IRQ12_80_MARK,	IRQ12_137_MARK,	IRQ13_81_MARK,	IRQ13_145_MARK,
	IRQ14_82_MARK,	IRQ14_146_MARK,	IRQ15_83_MARK,	IRQ15_147_MARK,
	IRQ16_84_MARK,	IRQ16_170_MARK,	IRQ17_MARK,	IRQ18_MARK,
	IRQ19_MARK,	IRQ20_MARK,	IRQ21_MARK,	IRQ22_MARK,
	IRQ23_MARK,	IRQ24_MARK,	IRQ25_MARK,	IRQ26_121_MARK,
	IRQ26_172_MARK,	IRQ27_122_MARK,	IRQ27_180_MARK,	IRQ28_123_MARK,
	IRQ28_181_MARK,	IRQ29_129_MARK,	IRQ29_182_MARK,	IRQ30_130_MARK,
	IRQ30_183_MARK,	IRQ31_138_MARK,	IRQ31_184_MARK,

	/* MSIOF0 */
	MSIOF0_TSYNC_MARK,	MSIOF0_TSCK_MARK,	MSIOF0_RXD_MARK,
	MSIOF0_RSCK_MARK,	MSIOF0_RSYNC_MARK,	MSIOF0_MCK0_MARK,
	MSIOF0_MCK1_MARK,	MSIOF0_SS1_MARK,	MSIOF0_SS2_MARK,
	MSIOF0_TXD_MARK,

	/* MSIOF1 */
	MSIOF1_TSCK_39_MARK,	MSIOF1_TSYNC_40_MARK,
	MSIOF1_TSCK_88_MARK,	MSIOF1_TSYNC_89_MARK,
	MSIOF1_TXD_41_MARK,	MSIOF1_RXD_42_MARK,
	MSIOF1_TXD_90_MARK,	MSIOF1_RXD_91_MARK,
	MSIOF1_SS1_43_MARK,	MSIOF1_SS2_44_MARK,
	MSIOF1_SS1_92_MARK,	MSIOF1_SS2_93_MARK,
	MSIOF1_RSCK_MARK,	MSIOF1_RSYNC_MARK,
	MSIOF1_MCK0_MARK,	MSIOF1_MCK1_MARK,

	/* MSIOF2 */
	MSIOF2_RSCK_MARK,	MSIOF2_RSYNC_MARK,	MSIOF2_MCK0_MARK,
	MSIOF2_MCK1_MARK,	MSIOF2_SS1_MARK,	MSIOF2_SS2_MARK,
	MSIOF2_TSYNC_MARK,	MSIOF2_TSCK_MARK,	MSIOF2_RXD_MARK,
	MSIOF2_TXD_MARK,

	/* BBIF1 */
	BBIF1_RXD_MARK,		BBIF1_TSYNC_MARK,	BBIF1_TSCK_MARK,
	BBIF1_TXD_MARK,		BBIF1_RSCK_MARK,	BBIF1_RSYNC_MARK,
	BBIF1_FLOW_MARK,	BB_RX_FLOW_N_MARK,

	/* BBIF2 */
	BBIF2_TSCK1_MARK,	BBIF2_TSYNC1_MARK,
	BBIF2_TXD1_MARK,	BBIF2_RXD_MARK,

	/* FSI */
	FSIACK_MARK,	FSIBCK_MARK,		FSIAILR_MARK,	FSIAIBT_MARK,
	FSIAISLD_MARK,	FSIAOMC_MARK,		FSIAOLR_MARK,	FSIAOBT_MARK,
	FSIAOSLD_MARK,	FSIASPDIF_11_MARK,	FSIASPDIF_15_MARK,

	/* FMSI */
	FMSOCK_MARK,	FMSOOLR_MARK,	FMSIOLR_MARK,	FMSOOBT_MARK,
	FMSIOBT_MARK,	FMSOSLD_MARK,	FMSOILR_MARK,	FMSIILR_MARK,
	FMSOIBT_MARK,	FMSIIBT_MARK,	FMSISLD_MARK,	FMSICK_MARK,

	/* SCIFA0 */
	SCIFA0_TXD_MARK,	SCIFA0_RXD_MARK,	SCIFA0_SCK_MARK,
	SCIFA0_RTS_MARK,	SCIFA0_CTS_MARK,

	/* SCIFA1 */
	SCIFA1_TXD_MARK,	SCIFA1_RXD_MARK,	SCIFA1_SCK_MARK,
	SCIFA1_RTS_MARK,	SCIFA1_CTS_MARK,

	/* SCIFA2 */
	SCIFA2_CTS1_MARK,	SCIFA2_RTS1_MARK,	SCIFA2_TXD1_MARK,
	SCIFA2_RXD1_MARK,	SCIFA2_SCK1_MARK,

	/* SCIFA3 */
	SCIFA3_CTS_43_MARK,	SCIFA3_CTS_140_MARK,	SCIFA3_RTS_44_MARK,
	SCIFA3_RTS_141_MARK,	SCIFA3_SCK_MARK,	SCIFA3_TXD_MARK,
	SCIFA3_RXD_MARK,

	/* SCIFA4 */
	SCIFA4_RXD_MARK,	SCIFA4_TXD_MARK,

	/* SCIFA5 */
	SCIFA5_RXD_MARK,	SCIFA5_TXD_MARK,

	/* SCIFB */
	SCIFB_SCK_MARK,	SCIFB_RTS_MARK,	SCIFB_CTS_MARK,
	SCIFB_TXD_MARK,	SCIFB_RXD_MARK,

	/* CEU */
	VIO_HD_MARK,	VIO_CKO1_MARK,	VIO_CKO2_MARK,	VIO_VD_MARK,
	VIO_CLK_MARK,	VIO_FIELD_MARK,	VIO_CKO_MARK,
	VIO_D0_MARK,	VIO_D1_MARK,	VIO_D2_MARK,	VIO_D3_MARK,
	VIO_D4_MARK,	VIO_D5_MARK,	VIO_D6_MARK,	VIO_D7_MARK,
	VIO_D8_MARK,	VIO_D9_MARK,	VIO_D10_MARK,	VIO_D11_MARK,
	VIO_D12_MARK,	VIO_D13_MARK,	VIO_D14_MARK,	VIO_D15_MARK,

	/* USB0 */
	IDIN_0_MARK,	EXTLP_0_MARK,	OVCN2_0_MARK,	PWEN_0_MARK,
	OVCN_0_MARK,	VBUS0_0_MARK,

	/* USB1 */
	IDIN_1_18_MARK,		IDIN_1_113_MARK,
	PWEN_1_115_MARK,	PWEN_1_138_MARK,
	OVCN_1_114_MARK,	OVCN_1_162_MARK,
	EXTLP_1_MARK,		OVCN2_1_MARK,
	VBUS0_1_MARK,

	/* GPIO */
	GPI0_MARK,	GPI1_MARK,	GPO0_MARK,	GPO1_MARK,

	/* BSC */
	BS_MARK,	WE1_MARK,
	CKO_MARK,	WAIT_MARK,	RDWR_MARK,

	A0_MARK,	A1_MARK,	A2_MARK,	A3_MARK,
	A6_MARK,	A7_MARK,	A8_MARK,	A9_MARK,
	A10_MARK,	A11_MARK,	A12_MARK,	A13_MARK,
	A14_MARK,	A15_MARK,	A16_MARK,	A17_MARK,
	A18_MARK,	A19_MARK,	A20_MARK,	A21_MARK,
	A22_MARK,	A23_MARK,	A24_MARK,	A25_MARK,
	A26_MARK,

	CS0_MARK,	CS2_MARK,	CS4_MARK,
	CS5A_MARK,	CS5B_MARK,	CS6A_MARK,

	/* BSC/FLCTL */
	RD_FSC_MARK,	WE0_FWE_MARK,	A4_FOE_MARK,	A5_FCDE_MARK,
	D0_NAF0_MARK,	D1_NAF1_MARK,	D2_NAF2_MARK,	D3_NAF3_MARK,
	D4_NAF4_MARK,	D5_NAF5_MARK,	D6_NAF6_MARK,	D7_NAF7_MARK,
	D8_NAF8_MARK,	D9_NAF9_MARK,	D10_NAF10_MARK,	D11_NAF11_MARK,
	D12_NAF12_MARK,	D13_NAF13_MARK,	D14_NAF14_MARK,	D15_NAF15_MARK,

	/* MMCIF(1) */
	MMCD0_0_MARK,	MMCD0_1_MARK,	MMCD0_2_MARK,	MMCD0_3_MARK,
	MMCD0_4_MARK,	MMCD0_5_MARK,	MMCD0_6_MARK,	MMCD0_7_MARK,
	MMCCMD0_MARK,	MMCCLK0_MARK,

	/* MMCIF(2) */
	MMCD1_0_MARK,	MMCD1_1_MARK,	MMCD1_2_MARK,	MMCD1_3_MARK,
	MMCD1_4_MARK,	MMCD1_5_MARK,	MMCD1_6_MARK,	MMCD1_7_MARK,
	MMCCLK1_MARK,	MMCCMD1_MARK,

	/* SPU2 */
	VINT_I_MARK,

	/* FLCTL */
	FCE1_MARK,	FCE0_MARK,	FRB_MARK,

	/* HSI */
	GP_RX_FLAG_MARK,	GP_RX_DATA_MARK,	GP_TX_READY_MARK,
	GP_RX_WAKE_MARK,	MP_TX_FLAG_MARK,	MP_TX_DATA_MARK,
	MP_RX_READY_MARK,	MP_TX_WAKE_MARK,

	/* MFI */
	MFIv6_MARK,
	MFIv4_MARK,

	MEMC_CS0_MARK,			MEMC_BUSCLK_MEMC_A0_MARK,
	MEMC_CS1_MEMC_A1_MARK,		MEMC_ADV_MEMC_DREQ0_MARK,
	MEMC_WAIT_MEMC_DREQ1_MARK,	MEMC_NOE_MARK,
	MEMC_NWE_MARK,			MEMC_INT_MARK,

	MEMC_AD0_MARK,	MEMC_AD1_MARK,	MEMC_AD2_MARK,
	MEMC_AD3_MARK,	MEMC_AD4_MARK,	MEMC_AD5_MARK,
	MEMC_AD6_MARK,	MEMC_AD7_MARK,	MEMC_AD8_MARK,
	MEMC_AD9_MARK,	MEMC_AD10_MARK,	MEMC_AD11_MARK,
	MEMC_AD12_MARK,	MEMC_AD13_MARK,	MEMC_AD14_MARK,
	MEMC_AD15_MARK,

	/* SIM */
	SIM_RST_MARK,	SIM_CLK_MARK,	SIM_D_MARK,

	/* TPU */
	TPU0TO0_MARK,		TPU0TO1_MARK,
	TPU0TO2_93_MARK,	TPU0TO2_99_MARK,
	TPU0TO3_MARK,

	/* I2C2 */
	I2C_SCL2_MARK,	I2C_SDA2_MARK,

	/* I2C3(1) */
	I2C_SCL3_MARK,	I2C_SDA3_MARK,

	/* I2C3(2) */
	I2C_SCL3S_MARK,	I2C_SDA3S_MARK,

	/* I2C4(2) */
	I2C_SCL4_MARK,	I2C_SDA4_MARK,

	/* I2C4(2) */
	I2C_SCL4S_MARK,	I2C_SDA4S_MARK,

	/* KEYSC */
	KEYOUT0_MARK,	KEYIN0_121_MARK,	KEYIN0_136_MARK,
	KEYOUT1_MARK,	KEYIN1_122_MARK,	KEYIN1_135_MARK,
	KEYOUT2_MARK,	KEYIN2_123_MARK,	KEYIN2_134_MARK,
	KEYOUT3_MARK,	KEYIN3_124_MARK,	KEYIN3_133_MARK,
	KEYOUT4_MARK,	KEYIN4_MARK,
	KEYOUT5_MARK,	KEYIN5_MARK,
	KEYOUT6_MARK,	KEYIN6_MARK,
	KEYOUT7_MARK,	KEYIN7_MARK,

	/* LCDC */
	LCDC0_SELECT_MARK,
	LCDC1_SELECT_MARK,
	LCDHSYN_MARK,	LCDCS_MARK,	LCDVSYN_MARK,	LCDDCK_MARK,
	LCDWR_MARK,	LCDRD_MARK,	LCDDISP_MARK,	LCDRS_MARK,
	LCDLCLK_MARK,	LCDDON_MARK,

	LCDD0_MARK,	LCDD1_MARK,	LCDD2_MARK,	LCDD3_MARK,
	LCDD4_MARK,	LCDD5_MARK,	LCDD6_MARK,	LCDD7_MARK,
	LCDD8_MARK,	LCDD9_MARK,	LCDD10_MARK,	LCDD11_MARK,
	LCDD12_MARK,	LCDD13_MARK,	LCDD14_MARK,	LCDD15_MARK,
	LCDD16_MARK,	LCDD17_MARK,	LCDD18_MARK,	LCDD19_MARK,
	LCDD20_MARK,	LCDD21_MARK,	LCDD22_MARK,	LCDD23_MARK,

	/* IRDA */
	IRDA_OUT_MARK,	IRDA_IN_MARK,	IRDA_FIRSEL_MARK,
	IROUT_139_MARK,	IROUT_140_MARK,

	/* TSIF1 */
	TS0_1SELECT_MARK,
	TS0_2SELECT_MARK,
	TS1_1SELECT_MARK,
	TS1_2SELECT_MARK,

	TS_SPSYNC1_MARK,	TS_SDAT1_MARK,
	TS_SDEN1_MARK,		TS_SCK1_MARK,

	/* TSIF2 */
	TS_SPSYNC2_MARK,	TS_SDAT2_MARK,
	TS_SDEN2_MARK,		TS_SCK2_MARK,

	/* HDMI */
	HDMI_HPD_MARK,	HDMI_CEC_MARK,

	/* SDHI0 */
	SDHICLK0_MARK,	SDHICD0_MARK,
	SDHICMD0_MARK,	SDHIWP0_MARK,
	SDHID0_0_MARK,	SDHID0_1_MARK,
	SDHID0_2_MARK,	SDHID0_3_MARK,

	/* SDHI1 */
	SDHICLK1_MARK,	SDHICMD1_MARK,	SDHID1_0_MARK,
	SDHID1_1_MARK,	SDHID1_2_MARK,	SDHID1_3_MARK,

	/* SDHI2 */
	SDHICLK2_MARK,	SDHICMD2_MARK,	SDHID2_0_MARK,
	SDHID2_1_MARK,	SDHID2_2_MARK,	SDHID2_3_MARK,

	/* SDENC */
	SDENC_CPG_MARK,
	SDENC_DV_CLKI_MARK,

	PINMUX_MARK_END,
};

static const pinmux_enum_t pinmux_data[] = {

	/* specify valid pin states for each pin in GPIO mode */
	PORT_DATA_IO_PD(0),		PORT_DATA_IO_PD(1),
	PORT_DATA_O(2),			PORT_DATA_I_PD(3),
	PORT_DATA_I_PD(4),		PORT_DATA_I_PD(5),
	PORT_DATA_IO_PU_PD(6),		PORT_DATA_I_PD(7),
	PORT_DATA_IO_PD(8),		PORT_DATA_O(9),

	PORT_DATA_O(10),		PORT_DATA_O(11),
	PORT_DATA_IO_PU_PD(12),		PORT_DATA_IO_PD(13),
	PORT_DATA_IO_PD(14),		PORT_DATA_O(15),
	PORT_DATA_IO_PD(16),		PORT_DATA_IO_PD(17),
	PORT_DATA_I_PD(18),		PORT_DATA_IO(19),

	PORT_DATA_IO(20),		PORT_DATA_IO(21),
	PORT_DATA_IO(22),		PORT_DATA_IO(23),
	PORT_DATA_IO(24),		PORT_DATA_IO(25),
	PORT_DATA_IO(26),		PORT_DATA_IO(27),
	PORT_DATA_IO(28),		PORT_DATA_IO(29),

	PORT_DATA_IO(30),		PORT_DATA_IO(31),
	PORT_DATA_IO(32),		PORT_DATA_IO(33),
	PORT_DATA_IO(34),		PORT_DATA_IO(35),
	PORT_DATA_IO(36),		PORT_DATA_IO(37),
	PORT_DATA_IO(38),		PORT_DATA_IO(39),

	PORT_DATA_IO(40),		PORT_DATA_IO(41),
	PORT_DATA_IO(42),		PORT_DATA_IO(43),
	PORT_DATA_IO(44),		PORT_DATA_IO(45),
	PORT_DATA_IO_PU(46),		PORT_DATA_IO_PU(47),
	PORT_DATA_IO_PU(48),		PORT_DATA_IO_PU(49),

	PORT_DATA_IO_PU(50),		PORT_DATA_IO_PU(51),
	PORT_DATA_IO_PU(52),		PORT_DATA_IO_PU(53),
	PORT_DATA_IO_PU(54),		PORT_DATA_IO_PU(55),
	PORT_DATA_IO_PU(56),		PORT_DATA_IO_PU(57),
	PORT_DATA_IO_PU(58),		PORT_DATA_IO_PU(59),

	PORT_DATA_IO_PU(60),		PORT_DATA_IO_PU(61),
	PORT_DATA_IO(62),		PORT_DATA_O(63),
	PORT_DATA_O(64),		PORT_DATA_IO_PU(65),
	PORT_DATA_O(66),		PORT_DATA_IO_PU(67),  /*66?*/
	PORT_DATA_O(68),		PORT_DATA_IO(69),

	PORT_DATA_IO(70),		PORT_DATA_IO(71),
	PORT_DATA_O(72),		PORT_DATA_I_PU(73),
	PORT_DATA_I_PU_PD(74),		PORT_DATA_IO_PU_PD(75),
	PORT_DATA_IO_PU_PD(76),		PORT_DATA_IO_PU_PD(77),
	PORT_DATA_IO_PU_PD(78),		PORT_DATA_IO_PU_PD(79),

	PORT_DATA_IO_PU_PD(80),		PORT_DATA_IO_PU_PD(81),
	PORT_DATA_IO_PU_PD(82),		PORT_DATA_IO_PU_PD(83),
	PORT_DATA_IO_PU_PD(84),		PORT_DATA_IO_PU_PD(85),
	PORT_DATA_IO_PU_PD(86),		PORT_DATA_IO_PU_PD(87),
	PORT_DATA_IO_PU_PD(88),		PORT_DATA_IO_PU_PD(89),

	PORT_DATA_IO_PU_PD(90),		PORT_DATA_IO_PU_PD(91),
	PORT_DATA_IO_PU_PD(92),		PORT_DATA_IO_PU_PD(93),
	PORT_DATA_IO_PU_PD(94),		PORT_DATA_IO_PU_PD(95),
	PORT_DATA_IO_PU(96),		PORT_DATA_IO_PU_PD(97),
	PORT_DATA_IO_PU_PD(98),		PORT_DATA_O(99), /*99?*/

	PORT_DATA_IO_PD(100),		PORT_DATA_IO_PD(101),
	PORT_DATA_IO_PD(102),		PORT_DATA_IO_PD(103),
	PORT_DATA_IO_PD(104),		PORT_DATA_IO_PD(105),
	PORT_DATA_IO_PU(106),		PORT_DATA_IO_PU(107),
	PORT_DATA_IO_PU(108),		PORT_DATA_IO_PU(109),

	PORT_DATA_IO_PU(110),		PORT_DATA_IO_PU(111),
	PORT_DATA_IO_PD(112),		PORT_DATA_IO_PD(113),
	PORT_DATA_IO_PU(114),		PORT_DATA_IO_PU(115),
	PORT_DATA_IO_PU(116),		PORT_DATA_IO_PU(117),
	PORT_DATA_IO_PU(118),		PORT_DATA_IO_PU(119),

	PORT_DATA_IO_PU(120),		PORT_DATA_IO_PD(121),
	PORT_DATA_IO_PD(122),		PORT_DATA_IO_PD(123),
	PORT_DATA_IO_PD(124),		PORT_DATA_IO_PD(125),
	PORT_DATA_IO_PD(126),		PORT_DATA_IO_PD(127),
	PORT_DATA_IO_PD(128),		PORT_DATA_IO_PU_PD(129),

	PORT_DATA_IO_PU_PD(130),	PORT_DATA_IO_PU_PD(131),
	PORT_DATA_IO_PU_PD(132),	PORT_DATA_IO_PU_PD(133),
	PORT_DATA_IO_PU_PD(134),	PORT_DATA_IO_PU_PD(135),
	PORT_DATA_IO_PD(136),		PORT_DATA_IO_PD(137),
	PORT_DATA_IO_PD(138),		PORT_DATA_IO_PD(139),

	PORT_DATA_IO_PD(140),		PORT_DATA_IO_PD(141),
	PORT_DATA_IO_PD(142),		PORT_DATA_IO_PU_PD(143),
	PORT_DATA_IO_PD(144),		PORT_DATA_IO_PD(145),
	PORT_DATA_IO_PD(146),		PORT_DATA_IO_PD(147),
	PORT_DATA_IO_PD(148),		PORT_DATA_IO_PD(149),

	PORT_DATA_IO_PD(150),		PORT_DATA_IO_PD(151),
	PORT_DATA_IO_PU_PD(152),	PORT_DATA_I_PD(153),
	PORT_DATA_IO_PU_PD(154),	PORT_DATA_I_PD(155),
	PORT_DATA_IO_PD(156),		PORT_DATA_IO_PD(157),
	PORT_DATA_I_PD(158),		PORT_DATA_IO_PD(159),

	PORT_DATA_O(160),		PORT_DATA_IO_PD(161),
	PORT_DATA_IO_PD(162),		PORT_DATA_IO_PD(163),
	PORT_DATA_I_PD(164),		PORT_DATA_IO_PD(165),
	PORT_DATA_I_PD(166),		PORT_DATA_I_PD(167),
	PORT_DATA_I_PD(168),		PORT_DATA_I_PD(169),

	PORT_DATA_I_PD(170),		PORT_DATA_O(171),
	PORT_DATA_IO_PU_PD(172),	PORT_DATA_IO_PU_PD(173),
	PORT_DATA_IO_PU_PD(174),	PORT_DATA_IO_PU_PD(175),
	PORT_DATA_IO_PU_PD(176),	PORT_DATA_IO_PU_PD(177),
	PORT_DATA_IO_PU_PD(178),	PORT_DATA_O(179),

	PORT_DATA_IO_PU_PD(180),	PORT_DATA_IO_PU_PD(181),
	PORT_DATA_IO_PU_PD(182),	PORT_DATA_IO_PU_PD(183),
	PORT_DATA_IO_PU_PD(184),	PORT_DATA_O(185),
	PORT_DATA_IO_PU_PD(186),	PORT_DATA_IO_PU_PD(187),
	PORT_DATA_IO_PU_PD(188),	PORT_DATA_IO_PU_PD(189),

	PORT_DATA_IO_PU_PD(190),

	/* IRQ */
	PINMUX_DATA(IRQ0_6_MARK,	PORT6_FN0, 	MSEL1CR_0_0),
	PINMUX_DATA(IRQ0_162_MARK,	PORT162_FN0,	MSEL1CR_0_1),
	PINMUX_DATA(IRQ1_MARK,		PORT12_FN0),
	PINMUX_DATA(IRQ2_4_MARK,	PORT4_FN0,	MSEL1CR_2_0),
	PINMUX_DATA(IRQ2_5_MARK,	PORT5_FN0,	MSEL1CR_2_1),
	PINMUX_DATA(IRQ3_8_MARK,	PORT8_FN0,	MSEL1CR_3_0),
	PINMUX_DATA(IRQ3_16_MARK,	PORT16_FN0,	MSEL1CR_3_1),
	PINMUX_DATA(IRQ4_17_MARK,	PORT17_FN0,	MSEL1CR_4_0),
	PINMUX_DATA(IRQ4_163_MARK,	PORT163_FN0,	MSEL1CR_4_1),
	PINMUX_DATA(IRQ5_MARK,		PORT18_FN0),
	PINMUX_DATA(IRQ6_39_MARK,	PORT39_FN0,	MSEL1CR_6_0),
	PINMUX_DATA(IRQ6_164_MARK,	PORT164_FN0,	MSEL1CR_6_1),
	PINMUX_DATA(IRQ7_40_MARK,	PORT40_FN0,	MSEL1CR_7_1),
	PINMUX_DATA(IRQ7_167_MARK,	PORT167_FN0,	MSEL1CR_7_0),
	PINMUX_DATA(IRQ8_41_MARK,	PORT41_FN0,	MSEL1CR_8_1),
	PINMUX_DATA(IRQ8_168_MARK,	PORT168_FN0,	MSEL1CR_8_0),
	PINMUX_DATA(IRQ9_42_MARK,	PORT42_FN0,	MSEL1CR_9_0),
	PINMUX_DATA(IRQ9_169_MARK,	PORT169_FN0,	MSEL1CR_9_1),
	PINMUX_DATA(IRQ10_MARK,		PORT65_FN0,	MSEL1CR_9_1),
	PINMUX_DATA(IRQ11_MARK,		PORT67_FN0),
	PINMUX_DATA(IRQ12_80_MARK,	PORT80_FN0,	MSEL1CR_12_0),
	PINMUX_DATA(IRQ12_137_MARK,	PORT137_FN0,	MSEL1CR_12_1),
	PINMUX_DATA(IRQ13_81_MARK,	PORT81_FN0,	MSEL1CR_13_0),
	PINMUX_DATA(IRQ13_145_MARK,	PORT145_FN0,	MSEL1CR_13_1),
	PINMUX_DATA(IRQ14_82_MARK,	PORT82_FN0,	MSEL1CR_14_0),
	PINMUX_DATA(IRQ14_146_MARK,	PORT146_FN0,	MSEL1CR_14_1),
	PINMUX_DATA(IRQ15_83_MARK,	PORT83_FN0,	MSEL1CR_15_0),
	PINMUX_DATA(IRQ15_147_MARK,	PORT147_FN0,	MSEL1CR_15_1),
	PINMUX_DATA(IRQ16_84_MARK,	PORT84_FN0,	MSEL1CR_16_0),
	PINMUX_DATA(IRQ16_170_MARK,	PORT170_FN0,	MSEL1CR_16_1),
	PINMUX_DATA(IRQ17_MARK,		PORT85_FN0),
	PINMUX_DATA(IRQ18_MARK,		PORT86_FN0),
	PINMUX_DATA(IRQ19_MARK,		PORT87_FN0),
	PINMUX_DATA(IRQ20_MARK,		PORT92_FN0),
	PINMUX_DATA(IRQ21_MARK,		PORT93_FN0),
	PINMUX_DATA(IRQ22_MARK,		PORT94_FN0),
	PINMUX_DATA(IRQ23_MARK,		PORT95_FN0),
	PINMUX_DATA(IRQ24_MARK,		PORT112_FN0),
	PINMUX_DATA(IRQ25_MARK,		PORT119_FN0),
	PINMUX_DATA(IRQ26_121_MARK,	PORT121_FN0,	MSEL1CR_26_1),
	PINMUX_DATA(IRQ26_172_MARK,	PORT172_FN0,	MSEL1CR_26_0),
	PINMUX_DATA(IRQ27_122_MARK,	PORT122_FN0,	MSEL1CR_27_1),
	PINMUX_DATA(IRQ27_180_MARK,	PORT180_FN0,	MSEL1CR_27_0),
	PINMUX_DATA(IRQ28_123_MARK,	PORT123_FN0,	MSEL1CR_28_1),
	PINMUX_DATA(IRQ28_181_MARK,	PORT181_FN0,	MSEL1CR_28_0),
	PINMUX_DATA(IRQ29_129_MARK,	PORT129_FN0,	MSEL1CR_29_1),
	PINMUX_DATA(IRQ29_182_MARK,	PORT182_FN0,	MSEL1CR_29_0),
	PINMUX_DATA(IRQ30_130_MARK,	PORT130_FN0,	MSEL1CR_30_1),
	PINMUX_DATA(IRQ30_183_MARK,	PORT183_FN0,	MSEL1CR_30_0),
	PINMUX_DATA(IRQ31_138_MARK,	PORT138_FN0,	MSEL1CR_31_1),
	PINMUX_DATA(IRQ31_184_MARK,	PORT184_FN0,	MSEL1CR_31_0),

	/* Function 1 */
	PINMUX_DATA(BBIF2_TSCK1_MARK,		PORT0_FN1),
	PINMUX_DATA(BBIF2_TSYNC1_MARK,		PORT1_FN1),
	PINMUX_DATA(BBIF2_TXD1_MARK,		PORT2_FN1),
	PINMUX_DATA(BBIF2_RXD_MARK,		PORT3_FN1),
	PINMUX_DATA(FSIACK_MARK,		PORT4_FN1),
	PINMUX_DATA(FSIAILR_MARK,		PORT5_FN1),
	PINMUX_DATA(FSIAIBT_MARK,		PORT6_FN1),
	PINMUX_DATA(FSIAISLD_MARK,		PORT7_FN1),
	PINMUX_DATA(FSIAOMC_MARK,		PORT8_FN1),
	PINMUX_DATA(FSIAOLR_MARK,		PORT9_FN1),
	PINMUX_DATA(FSIAOBT_MARK,		PORT10_FN1),
	PINMUX_DATA(FSIAOSLD_MARK,		PORT11_FN1),
	PINMUX_DATA(FMSOCK_MARK,		PORT12_FN1),
	PINMUX_DATA(FMSOOLR_MARK,		PORT13_FN1),
	PINMUX_DATA(FMSOOBT_MARK,		PORT14_FN1),
	PINMUX_DATA(FMSOSLD_MARK,		PORT15_FN1),
	PINMUX_DATA(FMSOILR_MARK,		PORT16_FN1),
	PINMUX_DATA(FMSOIBT_MARK,		PORT17_FN1),
	PINMUX_DATA(FMSISLD_MARK,		PORT18_FN1),
	PINMUX_DATA(A0_MARK,			PORT19_FN1),
	PINMUX_DATA(A1_MARK,			PORT20_FN1),
	PINMUX_DATA(A2_MARK,			PORT21_FN1),
	PINMUX_DATA(A3_MARK,			PORT22_FN1),
	PINMUX_DATA(A4_FOE_MARK,		PORT23_FN1),
	PINMUX_DATA(A5_FCDE_MARK,		PORT24_FN1),
	PINMUX_DATA(A6_MARK,			PORT25_FN1),
	PINMUX_DATA(A7_MARK,			PORT26_FN1),
	PINMUX_DATA(A8_MARK,			PORT27_FN1),
	PINMUX_DATA(A9_MARK,			PORT28_FN1),
	PINMUX_DATA(A10_MARK,			PORT29_FN1),
	PINMUX_DATA(A11_MARK,			PORT30_FN1),
	PINMUX_DATA(A12_MARK,			PORT31_FN1),
	PINMUX_DATA(A13_MARK,			PORT32_FN1),
	PINMUX_DATA(A14_MARK,			PORT33_FN1),
	PINMUX_DATA(A15_MARK,			PORT34_FN1),
	PINMUX_DATA(A16_MARK,			PORT35_FN1),
	PINMUX_DATA(A17_MARK,			PORT36_FN1),
	PINMUX_DATA(A18_MARK,			PORT37_FN1),
	PINMUX_DATA(A19_MARK,			PORT38_FN1),
	PINMUX_DATA(A20_MARK,			PORT39_FN1),
	PINMUX_DATA(A21_MARK,			PORT40_FN1),
	PINMUX_DATA(A22_MARK,			PORT41_FN1),
	PINMUX_DATA(A23_MARK,			PORT42_FN1),
	PINMUX_DATA(A24_MARK,			PORT43_FN1),
	PINMUX_DATA(A25_MARK,			PORT44_FN1),
	PINMUX_DATA(A26_MARK,			PORT45_FN1),
	PINMUX_DATA(D0_NAF0_MARK,		PORT46_FN1),
	PINMUX_DATA(D1_NAF1_MARK,		PORT47_FN1),
	PINMUX_DATA(D2_NAF2_MARK,		PORT48_FN1),
	PINMUX_DATA(D3_NAF3_MARK,		PORT49_FN1),
	PINMUX_DATA(D4_NAF4_MARK,		PORT50_FN1),
	PINMUX_DATA(D5_NAF5_MARK,		PORT51_FN1),
	PINMUX_DATA(D6_NAF6_MARK,		PORT52_FN1),
	PINMUX_DATA(D7_NAF7_MARK,		PORT53_FN1),
	PINMUX_DATA(D8_NAF8_MARK,		PORT54_FN1),
	PINMUX_DATA(D9_NAF9_MARK,		PORT55_FN1),
	PINMUX_DATA(D10_NAF10_MARK,		PORT56_FN1),
	PINMUX_DATA(D11_NAF11_MARK,		PORT57_FN1),
	PINMUX_DATA(D12_NAF12_MARK,		PORT58_FN1),
	PINMUX_DATA(D13_NAF13_MARK,		PORT59_FN1),
	PINMUX_DATA(D14_NAF14_MARK,		PORT60_FN1),
	PINMUX_DATA(D15_NAF15_MARK,		PORT61_FN1),
	PINMUX_DATA(CS0_MARK,			PORT62_FN1),
	PINMUX_DATA(CS2_MARK,			PORT63_FN1),
	PINMUX_DATA(CS4_MARK,			PORT64_FN1),
	PINMUX_DATA(CS5A_MARK,			PORT65_FN1),
	PINMUX_DATA(CS5B_MARK,			PORT66_FN1),
	PINMUX_DATA(CS6A_MARK,			PORT67_FN1),
	PINMUX_DATA(FCE0_MARK,			PORT68_FN1),
	PINMUX_DATA(RD_FSC_MARK,		PORT69_FN1),
	PINMUX_DATA(WE0_FWE_MARK,		PORT70_FN1),
	PINMUX_DATA(WE1_MARK,			PORT71_FN1),
	PINMUX_DATA(CKO_MARK,			PORT72_FN1),
	PINMUX_DATA(FRB_MARK,			PORT73_FN1),
	PINMUX_DATA(WAIT_MARK,			PORT74_FN1),
	PINMUX_DATA(RDWR_MARK,			PORT75_FN1),
	PINMUX_DATA(MEMC_AD0_MARK,		PORT76_FN1),
	PINMUX_DATA(MEMC_AD1_MARK,		PORT77_FN1),
	PINMUX_DATA(MEMC_AD2_MARK,		PORT78_FN1),
	PINMUX_DATA(MEMC_AD3_MARK,		PORT79_FN1),
	PINMUX_DATA(MEMC_AD4_MARK,		PORT80_FN1),
	PINMUX_DATA(MEMC_AD5_MARK,		PORT81_FN1),
	PINMUX_DATA(MEMC_AD6_MARK,		PORT82_FN1),
	PINMUX_DATA(MEMC_AD7_MARK,		PORT83_FN1),
	PINMUX_DATA(MEMC_AD8_MARK,		PORT84_FN1),
	PINMUX_DATA(MEMC_AD9_MARK,		PORT85_FN1),
	PINMUX_DATA(MEMC_AD10_MARK,		PORT86_FN1),
	PINMUX_DATA(MEMC_AD11_MARK,		PORT87_FN1),
	PINMUX_DATA(MEMC_AD12_MARK,		PORT88_FN1),
	PINMUX_DATA(MEMC_AD13_MARK,		PORT89_FN1),
	PINMUX_DATA(MEMC_AD14_MARK,		PORT90_FN1),
	PINMUX_DATA(MEMC_AD15_MARK,		PORT91_FN1),
	PINMUX_DATA(MEMC_CS0_MARK,		PORT92_FN1),
	PINMUX_DATA(MEMC_BUSCLK_MEMC_A0_MARK,	PORT93_FN1),
	PINMUX_DATA(MEMC_CS1_MEMC_A1_MARK,	PORT94_FN1),
	PINMUX_DATA(MEMC_ADV_MEMC_DREQ0_MARK,	PORT95_FN1),
	PINMUX_DATA(MEMC_WAIT_MEMC_DREQ1_MARK,	PORT96_FN1),
	PINMUX_DATA(MEMC_NOE_MARK,		PORT97_FN1),
	PINMUX_DATA(MEMC_NWE_MARK,		PORT98_FN1),
	PINMUX_DATA(MEMC_INT_MARK,		PORT99_FN1),
	PINMUX_DATA(VIO_VD_MARK,		PORT100_FN1),
	PINMUX_DATA(VIO_HD_MARK,		PORT101_FN1),
	PINMUX_DATA(VIO_D0_MARK,		PORT102_FN1),
	PINMUX_DATA(VIO_D1_MARK,		PORT103_FN1),
	PINMUX_DATA(VIO_D2_MARK,		PORT104_FN1),
	PINMUX_DATA(VIO_D3_MARK,		PORT105_FN1),
	PINMUX_DATA(VIO_D4_MARK,		PORT106_FN1),
	PINMUX_DATA(VIO_D5_MARK,		PORT107_FN1),
	PINMUX_DATA(VIO_D6_MARK,		PORT108_FN1),
	PINMUX_DATA(VIO_D7_MARK,		PORT109_FN1),
	PINMUX_DATA(VIO_D8_MARK,		PORT110_FN1),
	PINMUX_DATA(VIO_D9_MARK,		PORT111_FN1),
	PINMUX_DATA(VIO_D10_MARK,		PORT112_FN1),
	PINMUX_DATA(VIO_D11_MARK,		PORT113_FN1),
	PINMUX_DATA(VIO_D12_MARK,		PORT114_FN1),
	PINMUX_DATA(VIO_D13_MARK,		PORT115_FN1),
	PINMUX_DATA(VIO_D14_MARK,		PORT116_FN1),
	PINMUX_DATA(VIO_D15_MARK,		PORT117_FN1),
	PINMUX_DATA(VIO_CLK_MARK,		PORT118_FN1),
	PINMUX_DATA(VIO_FIELD_MARK,		PORT119_FN1),
	PINMUX_DATA(VIO_CKO_MARK,		PORT120_FN1),
	PINMUX_DATA(LCDD0_MARK,			PORT121_FN1),
	PINMUX_DATA(LCDD1_MARK,			PORT122_FN1),
	PINMUX_DATA(LCDD2_MARK,			PORT123_FN1),
	PINMUX_DATA(LCDD3_MARK,			PORT124_FN1),
	PINMUX_DATA(LCDD4_MARK,			PORT125_FN1),
	PINMUX_DATA(LCDD5_MARK,			PORT126_FN1),
	PINMUX_DATA(LCDD6_MARK,			PORT127_FN1),
	PINMUX_DATA(LCDD7_MARK,			PORT128_FN1),
	PINMUX_DATA(LCDD8_MARK,			PORT129_FN1),
	PINMUX_DATA(LCDD9_MARK,			PORT130_FN1),
	PINMUX_DATA(LCDD10_MARK,		PORT131_FN1),
	PINMUX_DATA(LCDD11_MARK,		PORT132_FN1),
	PINMUX_DATA(LCDD12_MARK,		PORT133_FN1),
	PINMUX_DATA(LCDD13_MARK,		PORT134_FN1),
	PINMUX_DATA(LCDD14_MARK,		PORT135_FN1),
	PINMUX_DATA(LCDD15_MARK,		PORT136_FN1),
	PINMUX_DATA(LCDD16_MARK,		PORT137_FN1),
	PINMUX_DATA(LCDD17_MARK,		PORT138_FN1),
	PINMUX_DATA(LCDD18_MARK,		PORT139_FN1),
	PINMUX_DATA(LCDD19_MARK,		PORT140_FN1),
	PINMUX_DATA(LCDD20_MARK,		PORT141_FN1),
	PINMUX_DATA(LCDD21_MARK,		PORT142_FN1),
	PINMUX_DATA(LCDD22_MARK,		PORT143_FN1),
	PINMUX_DATA(LCDD23_MARK,		PORT144_FN1),
	PINMUX_DATA(LCDHSYN_MARK,		PORT145_FN1),
	PINMUX_DATA(LCDVSYN_MARK,		PORT146_FN1),
	PINMUX_DATA(LCDDCK_MARK,		PORT147_FN1),
	PINMUX_DATA(LCDRD_MARK,			PORT148_FN1),
	PINMUX_DATA(LCDDISP_MARK,		PORT149_FN1),
	PINMUX_DATA(LCDLCLK_MARK,		PORT150_FN1),
	PINMUX_DATA(LCDDON_MARK,		PORT151_FN1),
	PINMUX_DATA(SCIFA0_TXD_MARK,		PORT152_FN1),
	PINMUX_DATA(SCIFA0_RXD_MARK,		PORT153_FN1),
	PINMUX_DATA(SCIFA1_TXD_MARK,		PORT154_FN1),
	PINMUX_DATA(SCIFA1_RXD_MARK,		PORT155_FN1),
	PINMUX_DATA(TS_SPSYNC1_MARK,		PORT156_FN1),
	PINMUX_DATA(TS_SDAT1_MARK,		PORT157_FN1),
	PINMUX_DATA(TS_SDEN1_MARK,		PORT158_FN1),
	PINMUX_DATA(TS_SCK1_MARK,		PORT159_FN1),
	PINMUX_DATA(TPU0TO0_MARK,		PORT160_FN1),
	PINMUX_DATA(TPU0TO1_MARK,		PORT161_FN1),
	PINMUX_DATA(SCIFB_SCK_MARK,		PORT162_FN1),
	PINMUX_DATA(SCIFB_RTS_MARK,		PORT163_FN1),
	PINMUX_DATA(SCIFB_CTS_MARK,		PORT164_FN1),
	PINMUX_DATA(SCIFB_TXD_MARK,		PORT165_FN1),
	PINMUX_DATA(SCIFB_RXD_MARK,		PORT166_FN1),
	PINMUX_DATA(VBUS0_0_MARK,		PORT167_FN1),
	PINMUX_DATA(VBUS0_1_MARK,		PORT168_FN1),
	PINMUX_DATA(HDMI_HPD_MARK,		PORT169_FN1),
	PINMUX_DATA(HDMI_CEC_MARK,		PORT170_FN1),
	PINMUX_DATA(SDHICLK0_MARK,		PORT171_FN1),
	PINMUX_DATA(SDHICD0_MARK,		PORT172_FN1),
	PINMUX_DATA(SDHID0_0_MARK,		PORT173_FN1),
	PINMUX_DATA(SDHID0_1_MARK,		PORT174_FN1),
	PINMUX_DATA(SDHID0_2_MARK,		PORT175_FN1),
	PINMUX_DATA(SDHID0_3_MARK,		PORT176_FN1),
	PINMUX_DATA(SDHICMD0_MARK,		PORT177_FN1),
	PINMUX_DATA(SDHIWP0_MARK,		PORT178_FN1),
	PINMUX_DATA(SDHICLK1_MARK,		PORT179_FN1),
	PINMUX_DATA(SDHID1_0_MARK,		PORT180_FN1),
	PINMUX_DATA(SDHID1_1_MARK,		PORT181_FN1),
	PINMUX_DATA(SDHID1_2_MARK,		PORT182_FN1),
	PINMUX_DATA(SDHID1_3_MARK,		PORT183_FN1),
	PINMUX_DATA(SDHICMD1_MARK,		PORT184_FN1),
	PINMUX_DATA(SDHICLK2_MARK,		PORT185_FN1),
	PINMUX_DATA(SDHID2_0_MARK,		PORT186_FN1),
	PINMUX_DATA(SDHID2_1_MARK,		PORT187_FN1),
	PINMUX_DATA(SDHID2_2_MARK,		PORT188_FN1),
	PINMUX_DATA(SDHID2_3_MARK,		PORT189_FN1),
	PINMUX_DATA(SDHICMD2_MARK,		PORT190_FN1),

	/* Function 2 */
	PINMUX_DATA(FSIBCK_MARK,		PORT4_FN2),
	PINMUX_DATA(SCIFA4_RXD_MARK,		PORT5_FN2),
	PINMUX_DATA(SCIFA4_TXD_MARK,		PORT6_FN2),
	PINMUX_DATA(SCIFA5_RXD_MARK,		PORT8_FN2),
	PINMUX_DATA(FSIASPDIF_11_MARK,		PORT11_FN2),
	PINMUX_DATA(SCIFA5_TXD_MARK,		PORT12_FN2),
	PINMUX_DATA(FMSIOLR_MARK,		PORT13_FN2),
	PINMUX_DATA(FMSIOBT_MARK,		PORT14_FN2),
	PINMUX_DATA(FSIASPDIF_15_MARK,		PORT15_FN2),
	PINMUX_DATA(FMSIILR_MARK,		PORT16_FN2),
	PINMUX_DATA(FMSIIBT_MARK,		PORT17_FN2),
	PINMUX_DATA(BS_MARK,			PORT19_FN2),
	PINMUX_DATA(MSIOF0_TSYNC_MARK,		PORT36_FN2),
	PINMUX_DATA(MSIOF0_TSCK_MARK,		PORT37_FN2),
	PINMUX_DATA(MSIOF0_RXD_MARK,		PORT38_FN2),
	PINMUX_DATA(MSIOF0_RSCK_MARK,		PORT39_FN2),
	PINMUX_DATA(MSIOF0_RSYNC_MARK,		PORT40_FN2),
	PINMUX_DATA(MSIOF0_MCK0_MARK,		PORT41_FN2),
	PINMUX_DATA(MSIOF0_MCK1_MARK,		PORT42_FN2),
	PINMUX_DATA(MSIOF0_SS1_MARK,		PORT43_FN2),
	PINMUX_DATA(MSIOF0_SS2_MARK,		PORT44_FN2),
	PINMUX_DATA(MSIOF0_TXD_MARK,		PORT45_FN2),
	PINMUX_DATA(FMSICK_MARK,		PORT65_FN2),
	PINMUX_DATA(FCE1_MARK,			PORT66_FN2),
	PINMUX_DATA(BBIF1_RXD_MARK,		PORT76_FN2),
	PINMUX_DATA(BBIF1_TSYNC_MARK,		PORT77_FN2),
	PINMUX_DATA(BBIF1_TSCK_MARK,		PORT78_FN2),
	PINMUX_DATA(BBIF1_TXD_MARK,		PORT79_FN2),
	PINMUX_DATA(BBIF1_RSCK_MARK,		PORT80_FN2),
	PINMUX_DATA(BBIF1_RSYNC_MARK,		PORT81_FN2),
	PINMUX_DATA(BBIF1_FLOW_MARK,		PORT82_FN2),
	PINMUX_DATA(BB_RX_FLOW_N_MARK,		PORT83_FN2),
	PINMUX_DATA(MSIOF1_RSCK_MARK,		PORT84_FN2),
	PINMUX_DATA(MSIOF1_RSYNC_MARK,		PORT85_FN2),
	PINMUX_DATA(MSIOF1_MCK0_MARK,		PORT86_FN2),
	PINMUX_DATA(MSIOF1_MCK1_MARK,		PORT87_FN2),
	PINMUX_DATA(MSIOF1_TSCK_88_MARK,	PORT88_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_TSYNC_89_MARK,	PORT89_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_TXD_90_MARK,		PORT90_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_RXD_91_MARK,		PORT91_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_SS1_92_MARK,		PORT92_FN2, MSEL4CR_10_1),
	PINMUX_DATA(MSIOF1_SS2_93_MARK,		PORT93_FN2, MSEL4CR_10_1),
	PINMUX_DATA(SCIFA2_CTS1_MARK,		PORT94_FN2),
	PINMUX_DATA(SCIFA2_RTS1_MARK,		PORT95_FN2),
	PINMUX_DATA(SCIFA2_TXD1_MARK,		PORT96_FN2),
	PINMUX_DATA(SCIFA2_RXD1_MARK,		PORT97_FN2),
	PINMUX_DATA(SCIFA2_SCK1_MARK,		PORT98_FN2),
	PINMUX_DATA(I2C_SCL2_MARK,		PORT110_FN2),
	PINMUX_DATA(I2C_SDA2_MARK,		PORT111_FN2),
	PINMUX_DATA(I2C_SCL3_MARK,		PORT114_FN2, MSEL4CR_16_1),
	PINMUX_DATA(I2C_SDA3_MARK,		PORT115_FN2, MSEL4CR_16_1),
	PINMUX_DATA(I2C_SCL4_MARK,		PORT116_FN2, MSEL4CR_17_1),
	PINMUX_DATA(I2C_SDA4_MARK,		PORT117_FN2, MSEL4CR_17_1),
	PINMUX_DATA(MSIOF2_RSCK_MARK,		PORT134_FN2),
	PINMUX_DATA(MSIOF2_RSYNC_MARK,		PORT135_FN2),
	PINMUX_DATA(MSIOF2_MCK0_MARK,		PORT136_FN2),
	PINMUX_DATA(MSIOF2_MCK1_MARK,		PORT137_FN2),
	PINMUX_DATA(MSIOF2_SS1_MARK,		PORT138_FN2),
	PINMUX_DATA(MSIOF2_SS2_MARK,		PORT139_FN2),
	PINMUX_DATA(SCIFA3_CTS_140_MARK,	PORT140_FN2, MSEL3CR_9_1),
	PINMUX_DATA(SCIFA3_RTS_141_MARK,	PORT141_FN2),
	PINMUX_DATA(SCIFA3_SCK_MARK,		PORT142_FN2),
	PINMUX_DATA(SCIFA3_TXD_MARK,		PORT143_FN2),
	PINMUX_DATA(SCIFA3_RXD_MARK,		PORT144_FN2),
	PINMUX_DATA(MSIOF2_TSYNC_MARK,		PORT148_FN2),
	PINMUX_DATA(MSIOF2_TSCK_MARK,		PORT149_FN2),
	PINMUX_DATA(MSIOF2_RXD_MARK,		PORT150_FN2),
	PINMUX_DATA(MSIOF2_TXD_MARK,		PORT151_FN2),
	PINMUX_DATA(SCIFA0_SCK_MARK,		PORT156_FN2),
	PINMUX_DATA(SCIFA0_RTS_MARK,		PORT157_FN2),
	PINMUX_DATA(SCIFA0_CTS_MARK,		PORT158_FN2),
	PINMUX_DATA(SCIFA1_SCK_MARK,		PORT159_FN2),
	PINMUX_DATA(SCIFA1_RTS_MARK,		PORT160_FN2),
	PINMUX_DATA(SCIFA1_CTS_MARK,		PORT161_FN2),

	/* Function 3 */
	PINMUX_DATA(VIO_CKO1_MARK,		PORT16_FN3),
	PINMUX_DATA(VIO_CKO2_MARK,		PORT17_FN3),
	PINMUX_DATA(IDIN_1_18_MARK,		PORT18_FN3, MSEL4CR_14_1),
	PINMUX_DATA(MSIOF1_TSCK_39_MARK,	PORT39_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_TSYNC_40_MARK,	PORT40_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_TXD_41_MARK,		PORT41_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_RXD_42_MARK,		PORT42_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_SS1_43_MARK,		PORT43_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MSIOF1_SS2_44_MARK,		PORT44_FN3, MSEL4CR_10_0),
	PINMUX_DATA(MMCD1_0_MARK,		PORT54_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_1_MARK,		PORT55_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_2_MARK,		PORT56_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_3_MARK,		PORT57_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_4_MARK,		PORT58_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_5_MARK,		PORT59_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_6_MARK,		PORT60_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCD1_7_MARK,		PORT61_FN3, MSEL4CR_15_1),
	PINMUX_DATA(VINT_I_MARK,		PORT65_FN3),
	PINMUX_DATA(MMCCLK1_MARK,		PORT66_FN3, MSEL4CR_15_1),
	PINMUX_DATA(MMCCMD1_MARK,		PORT67_FN3, MSEL4CR_15_1),
	PINMUX_DATA(TPU0TO2_93_MARK,		PORT93_FN3),
	PINMUX_DATA(TPU0TO2_99_MARK,		PORT99_FN3),
	PINMUX_DATA(TPU0TO3_MARK,		PORT112_FN3),
	PINMUX_DATA(IDIN_0_MARK,		PORT113_FN3),
	PINMUX_DATA(EXTLP_0_MARK,		PORT114_FN3),
	PINMUX_DATA(OVCN2_0_MARK,		PORT115_FN3),
	PINMUX_DATA(PWEN_0_MARK,		PORT116_FN3),
	PINMUX_DATA(OVCN_0_MARK,		PORT117_FN3),
	PINMUX_DATA(KEYOUT7_MARK,		PORT121_FN3),
	PINMUX_DATA(KEYOUT6_MARK,		PORT122_FN3),
	PINMUX_DATA(KEYOUT5_MARK,		PORT123_FN3),
	PINMUX_DATA(KEYOUT4_MARK,		PORT124_FN3),
	PINMUX_DATA(KEYOUT3_MARK,		PORT125_FN3),
	PINMUX_DATA(KEYOUT2_MARK,		PORT126_FN3),
	PINMUX_DATA(KEYOUT1_MARK,		PORT127_FN3),
	PINMUX_DATA(KEYOUT0_MARK,		PORT128_FN3),
	PINMUX_DATA(KEYIN7_MARK,		PORT129_FN3),
	PINMUX_DATA(KEYIN6_MARK,		PORT130_FN3),
	PINMUX_DATA(KEYIN5_MARK,		PORT131_FN3),
	PINMUX_DATA(KEYIN4_MARK,		PORT132_FN3),
	PINMUX_DATA(KEYIN3_133_MARK,		PORT133_FN3, MSEL4CR_18_0),
	PINMUX_DATA(KEYIN2_134_MARK,		PORT134_FN3, MSEL4CR_18_0),
	PINMUX_DATA(KEYIN1_135_MARK,		PORT135_FN3, MSEL4CR_18_0),
	PINMUX_DATA(KEYIN0_136_MARK,		PORT136_FN3, MSEL4CR_18_0),
	PINMUX_DATA(TS_SPSYNC2_MARK,		PORT137_FN3),
	PINMUX_DATA(IROUT_139_MARK,		PORT139_FN3),
	PINMUX_DATA(IRDA_OUT_MARK,		PORT140_FN3),
	PINMUX_DATA(IRDA_IN_MARK,		PORT141_FN3),
	PINMUX_DATA(IRDA_FIRSEL_MARK,		PORT142_FN3),
	PINMUX_DATA(TS_SDAT2_MARK,		PORT145_FN3),
	PINMUX_DATA(TS_SDEN2_MARK,		PORT146_FN3),
	PINMUX_DATA(TS_SCK2_MARK,		PORT147_FN3),

	/* Function 4 */
	PINMUX_DATA(SCIFA3_CTS_43_MARK,	PORT43_FN4, MSEL3CR_9_0),
	PINMUX_DATA(SCIFA3_RTS_44_MARK,	PORT44_FN4),
	PINMUX_DATA(GP_RX_FLAG_MARK,	PORT76_FN4),
	PINMUX_DATA(GP_RX_DATA_MARK,	PORT77_FN4),
	PINMUX_DATA(GP_TX_READY_MARK,	PORT78_FN4),
	PINMUX_DATA(GP_RX_WAKE_MARK,	PORT79_FN4),
	PINMUX_DATA(MP_TX_FLAG_MARK,	PORT80_FN4),
	PINMUX_DATA(MP_TX_DATA_MARK,	PORT81_FN4),
	PINMUX_DATA(MP_RX_READY_MARK,	PORT82_FN4),
	PINMUX_DATA(MP_TX_WAKE_MARK,	PORT83_FN4),
	PINMUX_DATA(MMCD0_0_MARK,	PORT84_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_1_MARK,	PORT85_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_2_MARK,	PORT86_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_3_MARK,	PORT87_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_4_MARK,	PORT88_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_5_MARK,	PORT89_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_6_MARK,	PORT90_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCD0_7_MARK,	PORT91_FN4, MSEL4CR_15_0),
	PINMUX_DATA(MMCCMD0_MARK,	PORT92_FN4, MSEL4CR_15_0),
	PINMUX_DATA(SIM_RST_MARK,	PORT94_FN4),
	PINMUX_DATA(SIM_CLK_MARK,	PORT95_FN4),
	PINMUX_DATA(SIM_D_MARK,		PORT98_FN4),
	PINMUX_DATA(MMCCLK0_MARK,	PORT99_FN4, MSEL4CR_15_0),
	PINMUX_DATA(IDIN_1_113_MARK,	PORT113_FN4, MSEL4CR_14_0),
	PINMUX_DATA(OVCN_1_114_MARK,	PORT114_FN4, MSEL4CR_14_0),
	PINMUX_DATA(PWEN_1_115_MARK,	PORT115_FN4),
	PINMUX_DATA(EXTLP_1_MARK,	PORT116_FN4),
	PINMUX_DATA(OVCN2_1_MARK,	PORT117_FN4),
	PINMUX_DATA(KEYIN0_121_MARK,	PORT121_FN4, MSEL4CR_18_1),
	PINMUX_DATA(KEYIN1_122_MARK,	PORT122_FN4, MSEL4CR_18_1),
	PINMUX_DATA(KEYIN2_123_MARK,	PORT123_FN4, MSEL4CR_18_1),
	PINMUX_DATA(KEYIN3_124_MARK,	PORT124_FN4, MSEL4CR_18_1),
	PINMUX_DATA(PWEN_1_138_MARK,	PORT138_FN4),
	PINMUX_DATA(IROUT_140_MARK,	PORT140_FN4),
	PINMUX_DATA(LCDCS_MARK,		PORT145_FN4),
	PINMUX_DATA(LCDWR_MARK,		PORT147_FN4),
	PINMUX_DATA(LCDRS_MARK,		PORT149_FN4),
	PINMUX_DATA(OVCN_1_162_MARK,	PORT162_FN4, MSEL4CR_14_1),

	/* Function 5 */
	PINMUX_DATA(GPI0_MARK,		PORT41_FN5),
	PINMUX_DATA(GPI1_MARK,		PORT42_FN5),
	PINMUX_DATA(GPO0_MARK,		PORT43_FN5),
	PINMUX_DATA(GPO1_MARK,		PORT44_FN5),
	PINMUX_DATA(I2C_SCL3S_MARK,	PORT137_FN5, MSEL4CR_16_0),
	PINMUX_DATA(I2C_SDA3S_MARK,	PORT145_FN5, MSEL4CR_16_0),
	PINMUX_DATA(I2C_SCL4S_MARK,	PORT146_FN5, MSEL4CR_17_0),
	PINMUX_DATA(I2C_SDA4S_MARK,	PORT147_FN5, MSEL4CR_17_0),

	/* Function select */
	PINMUX_DATA(LCDC0_SELECT_MARK,	MSEL3CR_6_0),
	PINMUX_DATA(LCDC1_SELECT_MARK,	MSEL3CR_6_1),

	PINMUX_DATA(TS0_1SELECT_MARK,	MSEL3CR_21_0, MSEL3CR_20_0),
	PINMUX_DATA(TS0_2SELECT_MARK,	MSEL3CR_21_0, MSEL3CR_20_1),
	PINMUX_DATA(TS1_1SELECT_MARK,	MSEL3CR_27_0, MSEL3CR_26_0),
	PINMUX_DATA(TS1_2SELECT_MARK,	MSEL3CR_27_0, MSEL3CR_26_1),

	PINMUX_DATA(SDENC_CPG_MARK,	MSEL4CR_19_0),
	PINMUX_DATA(SDENC_DV_CLKI_MARK,	MSEL4CR_19_1),

	PINMUX_DATA(MFIv6_MARK,		MSEL4CR_6_0),
	PINMUX_DATA(MFIv4_MARK,		MSEL4CR_6_1),
};

static struct sh_pfc_pin pinmux_pins[] = {
	GPIO_PORT_ALL(),
};

/* - MMCIF ------------------------------------------------------------------ */
static const unsigned int mmc0_data1_0_pins[] = {
	/* D[0] */
	84,
};
static const unsigned int mmc0_data1_0_mux[] = {
	MMCD0_0_MARK,
};
static const unsigned int mmc0_data4_0_pins[] = {
	/* D[0:3] */
	84, 85, 86, 87,
};
static const unsigned int mmc0_data4_0_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
};
static const unsigned int mmc0_data8_0_pins[] = {
	/* D[0:7] */
	84, 85, 86, 87, 88, 89, 90, 91,
};
static const unsigned int mmc0_data8_0_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
	MMCD0_4_MARK, MMCD0_5_MARK, MMCD0_6_MARK, MMCD0_7_MARK,
};
static const unsigned int mmc0_ctrl_0_pins[] = {
	/* CMD, CLK */
	92, 99,
};
static const unsigned int mmc0_ctrl_0_mux[] = {
	MMCCMD0_MARK, MMCCLK0_MARK,
};

static const unsigned int mmc0_data1_1_pins[] = {
	/* D[0] */
	54,
};
static const unsigned int mmc0_data1_1_mux[] = {
	MMCD1_0_MARK,
};
static const unsigned int mmc0_data4_1_pins[] = {
	/* D[0:3] */
	54, 55, 56, 57,
};
static const unsigned int mmc0_data4_1_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
};
static const unsigned int mmc0_data8_1_pins[] = {
	/* D[0:7] */
	54, 55, 56, 57, 58, 59, 60, 61,
};
static const unsigned int mmc0_data8_1_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
	MMCD1_4_MARK, MMCD1_5_MARK, MMCD1_6_MARK, MMCD1_7_MARK,
};
static const unsigned int mmc0_ctrl_1_pins[] = {
	/* CMD, CLK */
	67, 66,
};
static const unsigned int mmc0_ctrl_1_mux[] = {
	MMCCMD1_MARK, MMCCLK1_MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* D0 */
	173,
};
static const unsigned int sdhi0_data1_mux[] = {
	SDHID0_0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* D[0:3] */
	173, 174, 175, 176,
};
static const unsigned int sdhi0_data4_mux[] = {
	SDHID0_0_MARK, SDHID0_1_MARK, SDHID0_2_MARK, SDHID0_3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CMD, CLK */
	177, 171,
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SDHICMD0_MARK, SDHICLK0_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	172,
};
static const unsigned int sdhi0_cd_mux[] = {
	SDHICD0_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	178,
};
static const unsigned int sdhi0_wp_mux[] = {
	SDHIWP0_MARK,
};
/* - SDHI1 ------------------------------------------------------------------ */
static const unsigned int sdhi1_data1_pins[] = {
	/* D0 */
	180,
};
static const unsigned int sdhi1_data1_mux[] = {
	SDHID1_0_MARK,
};
static const unsigned int sdhi1_data4_pins[] = {
	/* D[0:3] */
	180, 181, 182, 183,
};
static const unsigned int sdhi1_data4_mux[] = {
	SDHID1_0_MARK, SDHID1_1_MARK, SDHID1_2_MARK, SDHID1_3_MARK,
};
static const unsigned int sdhi1_ctrl_pins[] = {
	/* CMD, CLK */
	184, 179,
};
static const unsigned int sdhi1_ctrl_mux[] = {
	SDHICMD1_MARK, SDHICLK1_MARK,
};

static const unsigned int sdhi2_data1_pins[] = {
	/* D0 */
	186,
};
static const unsigned int sdhi2_data1_mux[] = {
	SDHID2_0_MARK,
};
static const unsigned int sdhi2_data4_pins[] = {
	/* D[0:3] */
	186, 187, 188, 189,
};
static const unsigned int sdhi2_data4_mux[] = {
	SDHID2_0_MARK, SDHID2_1_MARK, SDHID2_2_MARK, SDHID2_3_MARK,
};
static const unsigned int sdhi2_ctrl_pins[] = {
	/* CMD, CLK */
	190, 185,
};
static const unsigned int sdhi2_ctrl_mux[] = {
	SDHICMD2_MARK, SDHICLK2_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(mmc0_data1_0),
	SH_PFC_PIN_GROUP(mmc0_data4_0),
	SH_PFC_PIN_GROUP(mmc0_data8_0),
	SH_PFC_PIN_GROUP(mmc0_ctrl_0),
	SH_PFC_PIN_GROUP(mmc0_data1_1),
	SH_PFC_PIN_GROUP(mmc0_data4_1),
	SH_PFC_PIN_GROUP(mmc0_data8_1),
	SH_PFC_PIN_GROUP(mmc0_ctrl_1),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_data1),
	SH_PFC_PIN_GROUP(sdhi1_data4),
	SH_PFC_PIN_GROUP(sdhi1_ctrl),
	SH_PFC_PIN_GROUP(sdhi2_data1),
	SH_PFC_PIN_GROUP(sdhi2_data4),
	SH_PFC_PIN_GROUP(sdhi2_ctrl),
};

static const char * const mmc0_groups[] = {
	"mmc0_data1_0",
	"mmc0_data4_0",
	"mmc0_data8_0",
	"mmc0_ctrl_0",
	"mmc0_data1_1",
	"mmc0_data4_1",
	"mmc0_data8_1",
	"mmc0_ctrl_1",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_data1",
	"sdhi1_data4",
	"sdhi1_ctrl",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_data1",
	"sdhi2_data4",
	"sdhi2_ctrl",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(mmc0),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
};

#define PINMUX_FN_BASE	ARRAY_SIZE(pinmux_pins)

static const struct pinmux_func pinmux_func_gpios[] = {
	/* IRQ */
	GPIO_FN(IRQ0_6),	GPIO_FN(IRQ0_162),	GPIO_FN(IRQ1),
	GPIO_FN(IRQ2_4),	GPIO_FN(IRQ2_5),	GPIO_FN(IRQ3_8),
	GPIO_FN(IRQ3_16),	GPIO_FN(IRQ4_17),	GPIO_FN(IRQ4_163),
	GPIO_FN(IRQ5),		GPIO_FN(IRQ6_39),	GPIO_FN(IRQ6_164),
	GPIO_FN(IRQ7_40),	GPIO_FN(IRQ7_167),	GPIO_FN(IRQ8_41),
	GPIO_FN(IRQ8_168),	GPIO_FN(IRQ9_42),	GPIO_FN(IRQ9_169),
	GPIO_FN(IRQ10),		GPIO_FN(IRQ11),		GPIO_FN(IRQ12_80),
	GPIO_FN(IRQ12_137),	GPIO_FN(IRQ13_81),	GPIO_FN(IRQ13_145),
	GPIO_FN(IRQ14_82),	GPIO_FN(IRQ14_146),	GPIO_FN(IRQ15_83),
	GPIO_FN(IRQ15_147),	GPIO_FN(IRQ16_84),	GPIO_FN(IRQ16_170),
	GPIO_FN(IRQ17),		GPIO_FN(IRQ18),		GPIO_FN(IRQ19),
	GPIO_FN(IRQ20),		GPIO_FN(IRQ21),		GPIO_FN(IRQ22),
	GPIO_FN(IRQ23),		GPIO_FN(IRQ24),		GPIO_FN(IRQ25),
	GPIO_FN(IRQ26_121),	GPIO_FN(IRQ26_172),	GPIO_FN(IRQ27_122),
	GPIO_FN(IRQ27_180),	GPIO_FN(IRQ28_123),	GPIO_FN(IRQ28_181),
	GPIO_FN(IRQ29_129),	GPIO_FN(IRQ29_182),	GPIO_FN(IRQ30_130),
	GPIO_FN(IRQ30_183),	GPIO_FN(IRQ31_138),	GPIO_FN(IRQ31_184),

	/* MSIOF0 */
	GPIO_FN(MSIOF0_TSYNC),	GPIO_FN(MSIOF0_TSCK),	GPIO_FN(MSIOF0_RXD),
	GPIO_FN(MSIOF0_RSCK),	GPIO_FN(MSIOF0_RSYNC),	GPIO_FN(MSIOF0_MCK0),
	GPIO_FN(MSIOF0_MCK1),	GPIO_FN(MSIOF0_SS1),	GPIO_FN(MSIOF0_SS2),
	GPIO_FN(MSIOF0_TXD),

	/* MSIOF1 */
	GPIO_FN(MSIOF1_TSCK_39),	GPIO_FN(MSIOF1_TSCK_88),
	GPIO_FN(MSIOF1_TSYNC_40),	GPIO_FN(MSIOF1_TSYNC_89),
	GPIO_FN(MSIOF1_TXD_41),		GPIO_FN(MSIOF1_TXD_90),
	GPIO_FN(MSIOF1_RXD_42),		GPIO_FN(MSIOF1_RXD_91),
	GPIO_FN(MSIOF1_SS1_43),		GPIO_FN(MSIOF1_SS1_92),
	GPIO_FN(MSIOF1_SS2_44),		GPIO_FN(MSIOF1_SS2_93),
	GPIO_FN(MSIOF1_RSCK),		GPIO_FN(MSIOF1_RSYNC),
	GPIO_FN(MSIOF1_MCK0),		GPIO_FN(MSIOF1_MCK1),

	/* MSIOF2 */
	GPIO_FN(MSIOF2_RSCK),	GPIO_FN(MSIOF2_RSYNC),	GPIO_FN(MSIOF2_MCK0),
	GPIO_FN(MSIOF2_MCK1),	GPIO_FN(MSIOF2_SS1),	GPIO_FN(MSIOF2_SS2),
	GPIO_FN(MSIOF2_TSYNC),	GPIO_FN(MSIOF2_TSCK),	GPIO_FN(MSIOF2_RXD),
	GPIO_FN(MSIOF2_TXD),

	/* BBIF1 */
	GPIO_FN(BBIF1_RXD),	GPIO_FN(BBIF1_TSYNC),	GPIO_FN(BBIF1_TSCK),
	GPIO_FN(BBIF1_TXD),	GPIO_FN(BBIF1_RSCK),	GPIO_FN(BBIF1_RSYNC),
	GPIO_FN(BBIF1_FLOW),	GPIO_FN(BB_RX_FLOW_N),

	/* BBIF2 */
	GPIO_FN(BBIF2_TSCK1),	GPIO_FN(BBIF2_TSYNC1),
	GPIO_FN(BBIF2_TXD1),	GPIO_FN(BBIF2_RXD),

	/* FSI */
	GPIO_FN(FSIACK),	GPIO_FN(FSIBCK),	GPIO_FN(FSIAILR),
	GPIO_FN(FSIAIBT),	GPIO_FN(FSIAISLD),	GPIO_FN(FSIAOMC),
	GPIO_FN(FSIAOLR),	GPIO_FN(FSIAOBT),	GPIO_FN(FSIAOSLD),
	GPIO_FN(FSIASPDIF_11),	GPIO_FN(FSIASPDIF_15),

	/* FMSI */
	GPIO_FN(FMSOCK),	GPIO_FN(FMSOOLR),	GPIO_FN(FMSIOLR),
	GPIO_FN(FMSOOBT),	GPIO_FN(FMSIOBT),	GPIO_FN(FMSOSLD),
	GPIO_FN(FMSOILR),	GPIO_FN(FMSIILR),	GPIO_FN(FMSOIBT),
	GPIO_FN(FMSIIBT),	GPIO_FN(FMSISLD),	GPIO_FN(FMSICK),

	/* SCIFA0 */
	GPIO_FN(SCIFA0_TXD),	GPIO_FN(SCIFA0_RXD),	GPIO_FN(SCIFA0_SCK),
	GPIO_FN(SCIFA0_RTS),	GPIO_FN(SCIFA0_CTS),

	/* SCIFA1 */
	GPIO_FN(SCIFA1_TXD),	GPIO_FN(SCIFA1_RXD),	GPIO_FN(SCIFA1_SCK),
	GPIO_FN(SCIFA1_RTS),	GPIO_FN(SCIFA1_CTS),

	/* SCIFA2 */
	GPIO_FN(SCIFA2_CTS1),	GPIO_FN(SCIFA2_RTS1),	GPIO_FN(SCIFA2_TXD1),
	GPIO_FN(SCIFA2_RXD1),	GPIO_FN(SCIFA2_SCK1),

	/* SCIFA3 */
	GPIO_FN(SCIFA3_CTS_43),		GPIO_FN(SCIFA3_CTS_140),
	GPIO_FN(SCIFA3_RTS_44),		GPIO_FN(SCIFA3_RTS_141),
	GPIO_FN(SCIFA3_SCK),		GPIO_FN(SCIFA3_TXD),
	GPIO_FN(SCIFA3_RXD),

	/* SCIFA4 */
	GPIO_FN(SCIFA4_RXD),	GPIO_FN(SCIFA4_TXD),

	/* SCIFA5 */
	GPIO_FN(SCIFA5_RXD),	GPIO_FN(SCIFA5_TXD),

	/* SCIFB */
	GPIO_FN(SCIFB_SCK),	GPIO_FN(SCIFB_RTS),	GPIO_FN(SCIFB_CTS),
	GPIO_FN(SCIFB_TXD),	GPIO_FN(SCIFB_RXD),

	/* CEU */
	GPIO_FN(VIO_HD),	GPIO_FN(VIO_CKO1),	GPIO_FN(VIO_CKO2),
	GPIO_FN(VIO_VD),	GPIO_FN(VIO_CLK),	GPIO_FN(VIO_FIELD),
	GPIO_FN(VIO_CKO),	GPIO_FN(VIO_D0),	GPIO_FN(VIO_D1),
	GPIO_FN(VIO_D2),	GPIO_FN(VIO_D3),	GPIO_FN(VIO_D4),
	GPIO_FN(VIO_D5),	GPIO_FN(VIO_D6),	GPIO_FN(VIO_D7),
	GPIO_FN(VIO_D8),	GPIO_FN(VIO_D9),	GPIO_FN(VIO_D10),
	GPIO_FN(VIO_D11),	GPIO_FN(VIO_D12),	GPIO_FN(VIO_D13),
	GPIO_FN(VIO_D14),	GPIO_FN(VIO_D15),

	/* USB0 */
	GPIO_FN(IDIN_0),	GPIO_FN(EXTLP_0),	GPIO_FN(OVCN2_0),
	GPIO_FN(PWEN_0),	GPIO_FN(OVCN_0),	GPIO_FN(VBUS0_0),

	/* USB1 */
	GPIO_FN(IDIN_1_18),	GPIO_FN(IDIN_1_113),
	GPIO_FN(OVCN_1_114),	GPIO_FN(OVCN_1_162),
	GPIO_FN(PWEN_1_115),	GPIO_FN(PWEN_1_138),
	GPIO_FN(EXTLP_1),	GPIO_FN(OVCN2_1),
	GPIO_FN(VBUS0_1),

	/* GPIO */
	GPIO_FN(GPI0),	GPIO_FN(GPI1),	GPIO_FN(GPO0),	GPIO_FN(GPO1),

	/* BSC */
	GPIO_FN(BS),	GPIO_FN(WE1),	GPIO_FN(CKO),
	GPIO_FN(WAIT),	GPIO_FN(RDWR),

	GPIO_FN(A0),	GPIO_FN(A1),	GPIO_FN(A2),
	GPIO_FN(A3),	GPIO_FN(A6),	GPIO_FN(A7),
	GPIO_FN(A8),	GPIO_FN(A9),	GPIO_FN(A10),
	GPIO_FN(A11),	GPIO_FN(A12),	GPIO_FN(A13),
	GPIO_FN(A14),	GPIO_FN(A15),	GPIO_FN(A16),
	GPIO_FN(A17),	GPIO_FN(A18),	GPIO_FN(A19),
	GPIO_FN(A20),	GPIO_FN(A21),	GPIO_FN(A22),
	GPIO_FN(A23),	GPIO_FN(A24),	GPIO_FN(A25),
	GPIO_FN(A26),

	GPIO_FN(CS0),	GPIO_FN(CS2),	GPIO_FN(CS4),
	GPIO_FN(CS5A),	GPIO_FN(CS5B),	GPIO_FN(CS6A),

	/* BSC/FLCTL */
	GPIO_FN(RD_FSC),	GPIO_FN(WE0_FWE),	GPIO_FN(A4_FOE),
	GPIO_FN(A5_FCDE),	GPIO_FN(D0_NAF0),	GPIO_FN(D1_NAF1),
	GPIO_FN(D2_NAF2),	GPIO_FN(D3_NAF3),	GPIO_FN(D4_NAF4),
	GPIO_FN(D5_NAF5),	GPIO_FN(D6_NAF6),	GPIO_FN(D7_NAF7),
	GPIO_FN(D8_NAF8),	GPIO_FN(D9_NAF9),	GPIO_FN(D10_NAF10),
	GPIO_FN(D11_NAF11),	GPIO_FN(D12_NAF12),	GPIO_FN(D13_NAF13),
	GPIO_FN(D14_NAF14),	GPIO_FN(D15_NAF15),

	/* SPU2 */
	GPIO_FN(VINT_I),

	/* FLCTL */
	GPIO_FN(FCE1),	GPIO_FN(FCE0),	GPIO_FN(FRB),

	/* HSI */
	GPIO_FN(GP_RX_FLAG),	GPIO_FN(GP_RX_DATA),	GPIO_FN(GP_TX_READY),
	GPIO_FN(GP_RX_WAKE),	GPIO_FN(MP_TX_FLAG),	GPIO_FN(MP_TX_DATA),
	GPIO_FN(MP_RX_READY),	GPIO_FN(MP_TX_WAKE),

	/* MFI */
	GPIO_FN(MFIv6),
	GPIO_FN(MFIv4),

	GPIO_FN(MEMC_BUSCLK_MEMC_A0),	GPIO_FN(MEMC_ADV_MEMC_DREQ0),
	GPIO_FN(MEMC_WAIT_MEMC_DREQ1),	GPIO_FN(MEMC_CS1_MEMC_A1),
	GPIO_FN(MEMC_CS0),	GPIO_FN(MEMC_NOE),
	GPIO_FN(MEMC_NWE),	GPIO_FN(MEMC_INT),

	GPIO_FN(MEMC_AD0),	GPIO_FN(MEMC_AD1),	GPIO_FN(MEMC_AD2),
	GPIO_FN(MEMC_AD3),	GPIO_FN(MEMC_AD4),	GPIO_FN(MEMC_AD5),
	GPIO_FN(MEMC_AD6),	GPIO_FN(MEMC_AD7),	GPIO_FN(MEMC_AD8),
	GPIO_FN(MEMC_AD9),	GPIO_FN(MEMC_AD10),	GPIO_FN(MEMC_AD11),
	GPIO_FN(MEMC_AD12),	GPIO_FN(MEMC_AD13),	GPIO_FN(MEMC_AD14),
	GPIO_FN(MEMC_AD15),

	/* SIM */
	GPIO_FN(SIM_RST),	GPIO_FN(SIM_CLK),	GPIO_FN(SIM_D),

	/* TPU */
	GPIO_FN(TPU0TO0),	GPIO_FN(TPU0TO1),	GPIO_FN(TPU0TO2_93),
	GPIO_FN(TPU0TO2_99),	GPIO_FN(TPU0TO3),

	/* I2C2 */
	GPIO_FN(I2C_SCL2),	GPIO_FN(I2C_SDA2),

	/* I2C3(1) */
	GPIO_FN(I2C_SCL3),	GPIO_FN(I2C_SDA3),

	/* I2C3(2) */
	GPIO_FN(I2C_SCL3S),	GPIO_FN(I2C_SDA3S),

	/* I2C4(2) */
	GPIO_FN(I2C_SCL4),	GPIO_FN(I2C_SDA4),

	/* I2C4(2) */
	GPIO_FN(I2C_SCL4S),	GPIO_FN(I2C_SDA4S),

	/* KEYSC */
	GPIO_FN(KEYOUT0),	GPIO_FN(KEYIN0_121),	GPIO_FN(KEYIN0_136),
	GPIO_FN(KEYOUT1),	GPIO_FN(KEYIN1_122),	GPIO_FN(KEYIN1_135),
	GPIO_FN(KEYOUT2),	GPIO_FN(KEYIN2_123),	GPIO_FN(KEYIN2_134),
	GPIO_FN(KEYOUT3),	GPIO_FN(KEYIN3_124),	GPIO_FN(KEYIN3_133),
	GPIO_FN(KEYOUT4),	GPIO_FN(KEYIN4),	GPIO_FN(KEYOUT5),
	GPIO_FN(KEYIN5),	GPIO_FN(KEYOUT6),	GPIO_FN(KEYIN6),
	GPIO_FN(KEYOUT7),	GPIO_FN(KEYIN7),

	/* LCDC */
	GPIO_FN(LCDHSYN),	GPIO_FN(LCDCS),	GPIO_FN(LCDVSYN),
	GPIO_FN(LCDDCK),	GPIO_FN(LCDWR),	GPIO_FN(LCDRD),
	GPIO_FN(LCDDISP),	GPIO_FN(LCDRS),	GPIO_FN(LCDLCLK),
	GPIO_FN(LCDDON),

	GPIO_FN(LCDD0),		GPIO_FN(LCDD1),		GPIO_FN(LCDD2),
	GPIO_FN(LCDD3),		GPIO_FN(LCDD4),		GPIO_FN(LCDD5),
	GPIO_FN(LCDD6),		GPIO_FN(LCDD7),		GPIO_FN(LCDD8),
	GPIO_FN(LCDD9),		GPIO_FN(LCDD10),	GPIO_FN(LCDD11),
	GPIO_FN(LCDD12),	GPIO_FN(LCDD13),	GPIO_FN(LCDD14),
	GPIO_FN(LCDD15),	GPIO_FN(LCDD16),	GPIO_FN(LCDD17),
	GPIO_FN(LCDD18),	GPIO_FN(LCDD19),	GPIO_FN(LCDD20),
	GPIO_FN(LCDD21),	GPIO_FN(LCDD22),	GPIO_FN(LCDD23),

	GPIO_FN(LCDC0_SELECT),
	GPIO_FN(LCDC1_SELECT),

	/* IRDA */
	GPIO_FN(IRDA_OUT),	GPIO_FN(IRDA_IN),	GPIO_FN(IRDA_FIRSEL),
	GPIO_FN(IROUT_139),	GPIO_FN(IROUT_140),

	/* TSIF1 */
	GPIO_FN(TS0_1SELECT),
	GPIO_FN(TS0_2SELECT),
	GPIO_FN(TS1_1SELECT),
	GPIO_FN(TS1_2SELECT),

	GPIO_FN(TS_SPSYNC1),	GPIO_FN(TS_SDAT1),
	GPIO_FN(TS_SDEN1),	GPIO_FN(TS_SCK1),

	/* TSIF2 */
	GPIO_FN(TS_SPSYNC2),	GPIO_FN(TS_SDAT2),
	GPIO_FN(TS_SDEN2),	GPIO_FN(TS_SCK2),

	/* HDMI */
	GPIO_FN(HDMI_HPD),	GPIO_FN(HDMI_CEC),

	/* SDENC */
	GPIO_FN(SDENC_CPG),
	GPIO_FN(SDENC_DV_CLKI),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	PORTCR(0,	0xE6051000), /* PORT0CR */
	PORTCR(1,	0xE6051001), /* PORT1CR */
	PORTCR(2,	0xE6051002), /* PORT2CR */
	PORTCR(3,	0xE6051003), /* PORT3CR */
	PORTCR(4,	0xE6051004), /* PORT4CR */
	PORTCR(5,	0xE6051005), /* PORT5CR */
	PORTCR(6,	0xE6051006), /* PORT6CR */
	PORTCR(7,	0xE6051007), /* PORT7CR */
	PORTCR(8,	0xE6051008), /* PORT8CR */
	PORTCR(9,	0xE6051009), /* PORT9CR */
	PORTCR(10,	0xE605100A), /* PORT10CR */
	PORTCR(11,	0xE605100B), /* PORT11CR */
	PORTCR(12,	0xE605100C), /* PORT12CR */
	PORTCR(13,	0xE605100D), /* PORT13CR */
	PORTCR(14,	0xE605100E), /* PORT14CR */
	PORTCR(15,	0xE605100F), /* PORT15CR */
	PORTCR(16,	0xE6051010), /* PORT16CR */
	PORTCR(17,	0xE6051011), /* PORT17CR */
	PORTCR(18,	0xE6051012), /* PORT18CR */
	PORTCR(19,	0xE6051013), /* PORT19CR */
	PORTCR(20,	0xE6051014), /* PORT20CR */
	PORTCR(21,	0xE6051015), /* PORT21CR */
	PORTCR(22,	0xE6051016), /* PORT22CR */
	PORTCR(23,	0xE6051017), /* PORT23CR */
	PORTCR(24,	0xE6051018), /* PORT24CR */
	PORTCR(25,	0xE6051019), /* PORT25CR */
	PORTCR(26,	0xE605101A), /* PORT26CR */
	PORTCR(27,	0xE605101B), /* PORT27CR */
	PORTCR(28,	0xE605101C), /* PORT28CR */
	PORTCR(29,	0xE605101D), /* PORT29CR */
	PORTCR(30,	0xE605101E), /* PORT30CR */
	PORTCR(31,	0xE605101F), /* PORT31CR */
	PORTCR(32,	0xE6051020), /* PORT32CR */
	PORTCR(33,	0xE6051021), /* PORT33CR */
	PORTCR(34,	0xE6051022), /* PORT34CR */
	PORTCR(35,	0xE6051023), /* PORT35CR */
	PORTCR(36,	0xE6051024), /* PORT36CR */
	PORTCR(37,	0xE6051025), /* PORT37CR */
	PORTCR(38,	0xE6051026), /* PORT38CR */
	PORTCR(39,	0xE6051027), /* PORT39CR */
	PORTCR(40,	0xE6051028), /* PORT40CR */
	PORTCR(41,	0xE6051029), /* PORT41CR */
	PORTCR(42,	0xE605102A), /* PORT42CR */
	PORTCR(43,	0xE605102B), /* PORT43CR */
	PORTCR(44,	0xE605102C), /* PORT44CR */
	PORTCR(45,	0xE605102D), /* PORT45CR */
	PORTCR(46,	0xE605202E), /* PORT46CR */
	PORTCR(47,	0xE605202F), /* PORT47CR */
	PORTCR(48,	0xE6052030), /* PORT48CR */
	PORTCR(49,	0xE6052031), /* PORT49CR */
	PORTCR(50,	0xE6052032), /* PORT50CR */
	PORTCR(51,	0xE6052033), /* PORT51CR */
	PORTCR(52,	0xE6052034), /* PORT52CR */
	PORTCR(53,	0xE6052035), /* PORT53CR */
	PORTCR(54,	0xE6052036), /* PORT54CR */
	PORTCR(55,	0xE6052037), /* PORT55CR */
	PORTCR(56,	0xE6052038), /* PORT56CR */
	PORTCR(57,	0xE6052039), /* PORT57CR */
	PORTCR(58,	0xE605203A), /* PORT58CR */
	PORTCR(59,	0xE605203B), /* PORT59CR */
	PORTCR(60,	0xE605203C), /* PORT60CR */
	PORTCR(61,	0xE605203D), /* PORT61CR */
	PORTCR(62,	0xE605203E), /* PORT62CR */
	PORTCR(63,	0xE605203F), /* PORT63CR */
	PORTCR(64,	0xE6052040), /* PORT64CR */
	PORTCR(65,	0xE6052041), /* PORT65CR */
	PORTCR(66,	0xE6052042), /* PORT66CR */
	PORTCR(67,	0xE6052043), /* PORT67CR */
	PORTCR(68,	0xE6052044), /* PORT68CR */
	PORTCR(69,	0xE6052045), /* PORT69CR */
	PORTCR(70,	0xE6052046), /* PORT70CR */
	PORTCR(71,	0xE6052047), /* PORT71CR */
	PORTCR(72,	0xE6052048), /* PORT72CR */
	PORTCR(73,	0xE6052049), /* PORT73CR */
	PORTCR(74,	0xE605204A), /* PORT74CR */
	PORTCR(75,	0xE605204B), /* PORT75CR */
	PORTCR(76,	0xE605004C), /* PORT76CR */
	PORTCR(77,	0xE605004D), /* PORT77CR */
	PORTCR(78,	0xE605004E), /* PORT78CR */
	PORTCR(79,	0xE605004F), /* PORT79CR */
	PORTCR(80,	0xE6050050), /* PORT80CR */
	PORTCR(81,	0xE6050051), /* PORT81CR */
	PORTCR(82,	0xE6050052), /* PORT82CR */
	PORTCR(83,	0xE6050053), /* PORT83CR */
	PORTCR(84,	0xE6050054), /* PORT84CR */
	PORTCR(85,	0xE6050055), /* PORT85CR */
	PORTCR(86,	0xE6050056), /* PORT86CR */
	PORTCR(87,	0xE6050057), /* PORT87CR */
	PORTCR(88,	0xE6050058), /* PORT88CR */
	PORTCR(89,	0xE6050059), /* PORT89CR */
	PORTCR(90,	0xE605005A), /* PORT90CR */
	PORTCR(91,	0xE605005B), /* PORT91CR */
	PORTCR(92,	0xE605005C), /* PORT92CR */
	PORTCR(93,	0xE605005D), /* PORT93CR */
	PORTCR(94,	0xE605005E), /* PORT94CR */
	PORTCR(95,	0xE605005F), /* PORT95CR */
	PORTCR(96,	0xE6050060), /* PORT96CR */
	PORTCR(97,	0xE6050061), /* PORT97CR */
	PORTCR(98,	0xE6050062), /* PORT98CR */
	PORTCR(99,	0xE6050063), /* PORT99CR */
	PORTCR(100,	0xE6053064), /* PORT100CR */
	PORTCR(101,	0xE6053065), /* PORT101CR */
	PORTCR(102,	0xE6053066), /* PORT102CR */
	PORTCR(103,	0xE6053067), /* PORT103CR */
	PORTCR(104,	0xE6053068), /* PORT104CR */
	PORTCR(105,	0xE6053069), /* PORT105CR */
	PORTCR(106,	0xE605306A), /* PORT106CR */
	PORTCR(107,	0xE605306B), /* PORT107CR */
	PORTCR(108,	0xE605306C), /* PORT108CR */
	PORTCR(109,	0xE605306D), /* PORT109CR */
	PORTCR(110,	0xE605306E), /* PORT110CR */
	PORTCR(111,	0xE605306F), /* PORT111CR */
	PORTCR(112,	0xE6053070), /* PORT112CR */
	PORTCR(113,	0xE6053071), /* PORT113CR */
	PORTCR(114,	0xE6053072), /* PORT114CR */
	PORTCR(115,	0xE6053073), /* PORT115CR */
	PORTCR(116,	0xE6053074), /* PORT116CR */
	PORTCR(117,	0xE6053075), /* PORT117CR */
	PORTCR(118,	0xE6053076), /* PORT118CR */
	PORTCR(119,	0xE6053077), /* PORT119CR */
	PORTCR(120,	0xE6053078), /* PORT120CR */
	PORTCR(121,	0xE6050079), /* PORT121CR */
	PORTCR(122,	0xE605007A), /* PORT122CR */
	PORTCR(123,	0xE605007B), /* PORT123CR */
	PORTCR(124,	0xE605007C), /* PORT124CR */
	PORTCR(125,	0xE605007D), /* PORT125CR */
	PORTCR(126,	0xE605007E), /* PORT126CR */
	PORTCR(127,	0xE605007F), /* PORT127CR */
	PORTCR(128,	0xE6050080), /* PORT128CR */
	PORTCR(129,	0xE6050081), /* PORT129CR */
	PORTCR(130,	0xE6050082), /* PORT130CR */
	PORTCR(131,	0xE6050083), /* PORT131CR */
	PORTCR(132,	0xE6050084), /* PORT132CR */
	PORTCR(133,	0xE6050085), /* PORT133CR */
	PORTCR(134,	0xE6050086), /* PORT134CR */
	PORTCR(135,	0xE6050087), /* PORT135CR */
	PORTCR(136,	0xE6050088), /* PORT136CR */
	PORTCR(137,	0xE6050089), /* PORT137CR */
	PORTCR(138,	0xE605008A), /* PORT138CR */
	PORTCR(139,	0xE605008B), /* PORT139CR */
	PORTCR(140,	0xE605008C), /* PORT140CR */
	PORTCR(141,	0xE605008D), /* PORT141CR */
	PORTCR(142,	0xE605008E), /* PORT142CR */
	PORTCR(143,	0xE605008F), /* PORT143CR */
	PORTCR(144,	0xE6050090), /* PORT144CR */
	PORTCR(145,	0xE6050091), /* PORT145CR */
	PORTCR(146,	0xE6050092), /* PORT146CR */
	PORTCR(147,	0xE6050093), /* PORT147CR */
	PORTCR(148,	0xE6050094), /* PORT148CR */
	PORTCR(149,	0xE6050095), /* PORT149CR */
	PORTCR(150,	0xE6050096), /* PORT150CR */
	PORTCR(151,	0xE6050097), /* PORT151CR */
	PORTCR(152,	0xE6053098), /* PORT152CR */
	PORTCR(153,	0xE6053099), /* PORT153CR */
	PORTCR(154,	0xE605309A), /* PORT154CR */
	PORTCR(155,	0xE605309B), /* PORT155CR */
	PORTCR(156,	0xE605009C), /* PORT156CR */
	PORTCR(157,	0xE605009D), /* PORT157CR */
	PORTCR(158,	0xE605009E), /* PORT158CR */
	PORTCR(159,	0xE605009F), /* PORT159CR */
	PORTCR(160,	0xE60500A0), /* PORT160CR */
	PORTCR(161,	0xE60500A1), /* PORT161CR */
	PORTCR(162,	0xE60500A2), /* PORT162CR */
	PORTCR(163,	0xE60500A3), /* PORT163CR */
	PORTCR(164,	0xE60500A4), /* PORT164CR */
	PORTCR(165,	0xE60500A5), /* PORT165CR */
	PORTCR(166,	0xE60500A6), /* PORT166CR */
	PORTCR(167,	0xE60520A7), /* PORT167CR */
	PORTCR(168,	0xE60520A8), /* PORT168CR */
	PORTCR(169,	0xE60520A9), /* PORT169CR */
	PORTCR(170,	0xE60520AA), /* PORT170CR */
	PORTCR(171,	0xE60520AB), /* PORT171CR */
	PORTCR(172,	0xE60520AC), /* PORT172CR */
	PORTCR(173,	0xE60520AD), /* PORT173CR */
	PORTCR(174,	0xE60520AE), /* PORT174CR */
	PORTCR(175,	0xE60520AF), /* PORT175CR */
	PORTCR(176,	0xE60520B0), /* PORT176CR */
	PORTCR(177,	0xE60520B1), /* PORT177CR */
	PORTCR(178,	0xE60520B2), /* PORT178CR */
	PORTCR(179,	0xE60520B3), /* PORT179CR */
	PORTCR(180,	0xE60520B4), /* PORT180CR */
	PORTCR(181,	0xE60520B5), /* PORT181CR */
	PORTCR(182,	0xE60520B6), /* PORT182CR */
	PORTCR(183,	0xE60520B7), /* PORT183CR */
	PORTCR(184,	0xE60520B8), /* PORT184CR */
	PORTCR(185,	0xE60520B9), /* PORT185CR */
	PORTCR(186,	0xE60520BA), /* PORT186CR */
	PORTCR(187,	0xE60520BB), /* PORT187CR */
	PORTCR(188,	0xE60520BC), /* PORT188CR */
	PORTCR(189,	0xE60520BD), /* PORT189CR */
	PORTCR(190,	0xE60520BE), /* PORT190CR */

	{ PINMUX_CFG_REG("MSEL1CR", 0xE605800C, 32, 1) {
			MSEL1CR_31_0,	MSEL1CR_31_1,
			MSEL1CR_30_0,	MSEL1CR_30_1,
			MSEL1CR_29_0,	MSEL1CR_29_1,
			MSEL1CR_28_0,	MSEL1CR_28_1,
			MSEL1CR_27_0,	MSEL1CR_27_1,
			MSEL1CR_26_0,	MSEL1CR_26_1,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,
			MSEL1CR_16_0,	MSEL1CR_16_1,
			MSEL1CR_15_0,	MSEL1CR_15_1,
			MSEL1CR_14_0,	MSEL1CR_14_1,
			MSEL1CR_13_0,	MSEL1CR_13_1,
			MSEL1CR_12_0,	MSEL1CR_12_1,
			0, 0, 0, 0,
			MSEL1CR_9_0,	MSEL1CR_9_1,
			MSEL1CR_8_0,	MSEL1CR_8_1,
			MSEL1CR_7_0,	MSEL1CR_7_1,
			MSEL1CR_6_0,	MSEL1CR_6_1,
			0, 0,
			MSEL1CR_4_0,	MSEL1CR_4_1,
			MSEL1CR_3_0,	MSEL1CR_3_1,
			MSEL1CR_2_0,	MSEL1CR_2_1,
			0, 0,
			MSEL1CR_0_0,	MSEL1CR_0_1,
		}
	},
	{ PINMUX_CFG_REG("MSEL3CR", 0xE6058020, 32, 1) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL3CR_27_0,	MSEL3CR_27_1,
			MSEL3CR_26_0,	MSEL3CR_26_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL3CR_21_0,	MSEL3CR_21_1,
			MSEL3CR_20_0,	MSEL3CR_20_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL3CR_15_0,	MSEL3CR_15_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0,
			MSEL3CR_9_0,	MSEL3CR_9_1,
			0, 0, 0, 0,
			MSEL3CR_6_0,	MSEL3CR_6_1,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			}
	},
	{ PINMUX_CFG_REG("MSEL4CR", 0xE6058024, 32, 1) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			MSEL4CR_19_0,	MSEL4CR_19_1,
			MSEL4CR_18_0,	MSEL4CR_18_1,
			MSEL4CR_17_0,	MSEL4CR_17_1,
			MSEL4CR_16_0,	MSEL4CR_16_1,
			MSEL4CR_15_0,	MSEL4CR_15_1,
			MSEL4CR_14_0,	MSEL4CR_14_1,
			0, 0, 0, 0,
			0, 0,
			MSEL4CR_10_0,	MSEL4CR_10_1,
			0, 0, 0, 0,
			0, 0,
			MSEL4CR_6_0,	MSEL4CR_6_1,
			0, 0,
			MSEL4CR_4_0,	MSEL4CR_4_1,
			0, 0, 0, 0,
			MSEL4CR_1_0,	MSEL4CR_1_1,
			0, 0,
		}
	},
	{ },
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PORTL095_064DR", 0xE6054008, 32) {
			PORT95_DATA, PORT94_DATA, PORT93_DATA, PORT92_DATA,
			PORT91_DATA, PORT90_DATA, PORT89_DATA, PORT88_DATA,
			PORT87_DATA, PORT86_DATA, PORT85_DATA, PORT84_DATA,
			PORT83_DATA, PORT82_DATA, PORT81_DATA, PORT80_DATA,
			PORT79_DATA, PORT78_DATA, PORT77_DATA, PORT76_DATA,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTL127_096DR", 0xE605400C, 32) {
			PORT127_DATA, PORT126_DATA, PORT125_DATA, PORT124_DATA,
			PORT123_DATA, PORT122_DATA, PORT121_DATA, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			PORT99_DATA,  PORT98_DATA,  PORT97_DATA,  PORT96_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTL159_128DR", 0xE6054010, 32) {
			PORT159_DATA, PORT158_DATA, PORT157_DATA, PORT156_DATA,
			0, 0, 0, 0,
			PORT151_DATA, PORT150_DATA, PORT149_DATA, PORT148_DATA,
			PORT147_DATA, PORT146_DATA, PORT145_DATA, PORT144_DATA,
			PORT143_DATA, PORT142_DATA, PORT141_DATA, PORT140_DATA,
			PORT139_DATA, PORT138_DATA, PORT137_DATA, PORT136_DATA,
			PORT135_DATA, PORT134_DATA, PORT133_DATA, PORT132_DATA,
			PORT131_DATA, PORT130_DATA, PORT129_DATA, PORT128_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTL191_160DR", 0xE6054014, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0,	      PORT166_DATA, PORT165_DATA, PORT164_DATA,
			PORT163_DATA, PORT162_DATA, PORT161_DATA, PORT160_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTD031_000DR", 0xE6055000, 32) {
			PORT31_DATA, PORT30_DATA, PORT29_DATA, PORT28_DATA,
			PORT27_DATA, PORT26_DATA, PORT25_DATA, PORT24_DATA,
			PORT23_DATA, PORT22_DATA, PORT21_DATA, PORT20_DATA,
			PORT19_DATA, PORT18_DATA, PORT17_DATA, PORT16_DATA,
			PORT15_DATA, PORT14_DATA, PORT13_DATA, PORT12_DATA,
			PORT11_DATA, PORT10_DATA, PORT9_DATA,  PORT8_DATA,
			PORT7_DATA,  PORT6_DATA,  PORT5_DATA,  PORT4_DATA,
			PORT3_DATA,  PORT2_DATA,  PORT1_DATA,  PORT0_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTD063_032DR", 0xE6055004, 32) {
			0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0,
			0,           0,           PORT45_DATA, PORT44_DATA,
			PORT43_DATA, PORT42_DATA, PORT41_DATA, PORT40_DATA,
			PORT39_DATA, PORT38_DATA, PORT37_DATA, PORT36_DATA,
			PORT35_DATA, PORT34_DATA, PORT33_DATA, PORT32_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR063_032DR", 0xE6056004, 32) {
			PORT63_DATA, PORT62_DATA, PORT61_DATA, PORT60_DATA,
			PORT59_DATA, PORT58_DATA, PORT57_DATA, PORT56_DATA,
			PORT55_DATA, PORT54_DATA, PORT53_DATA, PORT52_DATA,
			PORT51_DATA, PORT50_DATA, PORT49_DATA, PORT48_DATA,
			PORT47_DATA, PORT46_DATA, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTR095_064DR", 0xE6056008, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			PORT75_DATA, PORT74_DATA, PORT73_DATA, PORT72_DATA,
			PORT71_DATA, PORT70_DATA, PORT69_DATA, PORT68_DATA,
			PORT67_DATA, PORT66_DATA, PORT65_DATA, PORT64_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR191_160DR", 0xE6056014, 32) {
			0,	      PORT190_DATA, PORT189_DATA, PORT188_DATA,
			PORT187_DATA, PORT186_DATA, PORT185_DATA, PORT184_DATA,
			PORT183_DATA, PORT182_DATA, PORT181_DATA, PORT180_DATA,
			PORT179_DATA, PORT178_DATA, PORT177_DATA, PORT176_DATA,
			PORT175_DATA, PORT174_DATA, PORT173_DATA, PORT172_DATA,
			PORT171_DATA, PORT170_DATA, PORT169_DATA, PORT168_DATA,
			PORT167_DATA, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTU127_096DR", 0xE605700C, 32) {
			0, 0, 0, 0,
			0, 0, 0, PORT120_DATA,
			PORT119_DATA, PORT118_DATA, PORT117_DATA, PORT116_DATA,
			PORT115_DATA, PORT114_DATA, PORT113_DATA, PORT112_DATA,
			PORT111_DATA, PORT110_DATA, PORT109_DATA, PORT108_DATA,
			PORT107_DATA, PORT106_DATA, PORT105_DATA, PORT104_DATA,
			PORT103_DATA, PORT102_DATA, PORT101_DATA, PORT100_DATA,
			0, 0, 0, 0,
		}
	},
	{ PINMUX_DATA_REG("PORTU159_128DR", 0xE6057010, 32) {
			0, 0, 0, 0,
			PORT155_DATA, PORT154_DATA, PORT153_DATA, PORT152_DATA,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
		}
	},
	{ },
};

#define EXT_IRQ16L(n) evt2irq(0x200 + ((n) << 5))
#define EXT_IRQ16H(n) evt2irq(0x3200 + (((n) - 16) << 5))
static const struct pinmux_irq pinmux_irqs[] = {
	PINMUX_IRQ(EXT_IRQ16L(0), GPIO_PORT6, GPIO_PORT162),
	PINMUX_IRQ(EXT_IRQ16L(1), GPIO_PORT12),
	PINMUX_IRQ(EXT_IRQ16L(2), GPIO_PORT4, GPIO_PORT5),
	PINMUX_IRQ(EXT_IRQ16L(3), GPIO_PORT8, GPIO_PORT16),
	PINMUX_IRQ(EXT_IRQ16L(4), GPIO_PORT17, GPIO_PORT163),
	PINMUX_IRQ(EXT_IRQ16L(5), GPIO_PORT18),
	PINMUX_IRQ(EXT_IRQ16L(6), GPIO_PORT39, GPIO_PORT164),
	PINMUX_IRQ(EXT_IRQ16L(7), GPIO_PORT40, GPIO_PORT167),
	PINMUX_IRQ(EXT_IRQ16L(8), GPIO_PORT41, GPIO_PORT168),
	PINMUX_IRQ(EXT_IRQ16L(9), GPIO_PORT42, GPIO_PORT169),
	PINMUX_IRQ(EXT_IRQ16L(10), GPIO_PORT65),
	PINMUX_IRQ(EXT_IRQ16L(11), GPIO_PORT67),
	PINMUX_IRQ(EXT_IRQ16L(12), GPIO_PORT80, GPIO_PORT137),
	PINMUX_IRQ(EXT_IRQ16L(13), GPIO_PORT81, GPIO_PORT145),
	PINMUX_IRQ(EXT_IRQ16L(14), GPIO_PORT82, GPIO_PORT146),
	PINMUX_IRQ(EXT_IRQ16L(15), GPIO_PORT83, GPIO_PORT147),
	PINMUX_IRQ(EXT_IRQ16H(16), GPIO_PORT84, GPIO_PORT170),
	PINMUX_IRQ(EXT_IRQ16H(17), GPIO_PORT85),
	PINMUX_IRQ(EXT_IRQ16H(18), GPIO_PORT86),
	PINMUX_IRQ(EXT_IRQ16H(19), GPIO_PORT87),
	PINMUX_IRQ(EXT_IRQ16H(20), GPIO_PORT92),
	PINMUX_IRQ(EXT_IRQ16H(21), GPIO_PORT93),
	PINMUX_IRQ(EXT_IRQ16H(22), GPIO_PORT94),
	PINMUX_IRQ(EXT_IRQ16H(23), GPIO_PORT95),
	PINMUX_IRQ(EXT_IRQ16H(24), GPIO_PORT112),
	PINMUX_IRQ(EXT_IRQ16H(25), GPIO_PORT119),
	PINMUX_IRQ(EXT_IRQ16H(26), GPIO_PORT121, GPIO_PORT172),
	PINMUX_IRQ(EXT_IRQ16H(27), GPIO_PORT122, GPIO_PORT180),
	PINMUX_IRQ(EXT_IRQ16H(28), GPIO_PORT123, GPIO_PORT181),
	PINMUX_IRQ(EXT_IRQ16H(29), GPIO_PORT129, GPIO_PORT182),
	PINMUX_IRQ(EXT_IRQ16H(30), GPIO_PORT130, GPIO_PORT183),
	PINMUX_IRQ(EXT_IRQ16H(31), GPIO_PORT138, GPIO_PORT184),
};

const struct sh_pfc_soc_info sh7372_pinmux_info = {
	.name = "sh7372_pfc",
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.input_pu = { PINMUX_INPUT_PULLUP_BEGIN, PINMUX_INPUT_PULLUP_END },
	.input_pd = { PINMUX_INPUT_PULLDOWN_BEGIN, PINMUX_INPUT_PULLDOWN_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.func_gpios = pinmux_func_gpios,
	.nr_func_gpios = ARRAY_SIZE(pinmux_func_gpios),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),

	.gpio_irq = pinmux_irqs,
	.gpio_irq_size = ARRAY_SIZE(pinmux_irqs),
};
