/*
 * arch/arm/mach-shark/include/mach/memory.h
 *
 * by Alexander Schulz
 *
 * derived from:
 * arch/arm/mach-ebsa110/include/mach/memory.h
 * Copyright (c) 1996-1999 Russell King.
 */
#ifndef __ASM_ARCH_MEMORY_H
#define __ASM_ARCH_MEMORY_H

#include <asm/sizes.h>

/*
 * Physical DRAM offset.
 */
#define PHYS_OFFSET     UL(0x08000000)

#ifndef __ASSEMBLY__

static inline void __arch_adjust_zones(unsigned long *zone_size, unsigned long *zhole_size)
{
  /* Only the first 4 MB (=1024 Pages) are usable for DMA */
  /* See dev / -> .properties in OpenFirmware. */
  zone_size[1] = zone_size[0] - 1024;
  zone_size[0] = 1024;
  zhole_size[1] = zhole_size[0];
  zhole_size[0] = 0;
}

#define arch_adjust_zones(size, holes) \
	__arch_adjust_zones(size, holes)

#define ISA_DMA_THRESHOLD	(PHYS_OFFSET + SZ_4M - 1)
#define MAX_DMA_ADDRESS		(PAGE_OFFSET + SZ_4M)

#endif

/*
 * Cache flushing area
 */
#define FLUSH_BASE_PHYS		0x80000000
#define FLUSH_BASE		0xdf000000

#endif
