/* $Id: systbls.S,v 1.1 1996/12/28 18:39:36 davem Exp $
 * systbls.S: System call entry point tables for OS compatibility.
 *            The native Linux system call table lives here also.
 *
 * Copyright (C) 1995, 1996 David S. Miller (davem@caip.rutgers.edu)
 *
 * Based upon preliminary work which is:
 *
 * Copyright (C) 1995 Adrian M. Rodriguez (adrian@remus.rutgers.edu)
 */

	.data
	.align	8

	/* First, the 32-bit Linux native syscall table. */

	.globl C_LABEL(sys_call_table32)
C_LABEL(sys_call_table32):
/*0*/	.xword C_LABEL(sys_setup), C_LABEL(sys_exit), C_LABEL(sys_fork)
	.xword C_LABEL(sys_read), C_LABEL(sys_write)
/*5*/	.xword C_LABEL(sys_open), C_LABEL(sys_close), C_LABEL(sys_wait4)
	.xword C_LABEL(sys_creat), C_LABEL(sys_link)
/*10*/  .xword C_LABEL(sys_unlink), C_LABEL(sunos_execv), C_LABEL(sys_chdir)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_mknod)
/*15*/	.xword C_LABEL(sys_chmod), C_LABEL(sys_chown), C_LABEL(sparc_brk)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_lseek)
/*20*/	.xword C_LABEL(sys_getpid), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_setuid), C_LABEL(sys_getuid)
/*25*/	.xword C_LABEL(sys_time), C_LABEL(sys_ptrace), C_LABEL(sys_alarm)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_pause)
/*30*/	.xword C_LABEL(sys_utime), C_LABEL(sys_stty), C_LABEL(sys_gtty)
	.xword C_LABEL(sys_access), C_LABEL(sys_nice), C_LABEL(sys_ftime)
	.xword C_LABEL(sys_sync), C_LABEL(sys_kill), C_LABEL(sys_newstat)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_newlstat), C_LABEL(sys_dup)
	.xword C_LABEL(sys_pipe), C_LABEL(sys_times), C_LABEL(sys_profil)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_setgid), C_LABEL(sys_getgid)
	.xword C_LABEL(sys_signal), C_LABEL(sys_geteuid)
/*50*/	.xword C_LABEL(sys_getegid), C_LABEL(sys_acct), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_ioctl), C_LABEL(sys_reboot)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_symlink), C_LABEL(sys_readlink)
	.xword C_LABEL(sys_execve), C_LABEL(sys_umask), C_LABEL(sys_chroot)
	.xword C_LABEL(sys_newfstat), C_LABEL(sys_nis_syscall), C_LABEL(sys_getpagesize)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_vfork), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_mmap), C_LABEL(sys_nis_syscall), C_LABEL(sys_munmap)
	.xword C_LABEL(sys_mprotect), C_LABEL(sys_nis_syscall), C_LABEL(sys_vhangup)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall), C_LABEL(sys_getgroups)
	.xword C_LABEL(sys_setgroups), C_LABEL(sys_getpgrp), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_setitimer), C_LABEL(sys_nis_syscall), C_LABEL(sys_swapon)
	.xword C_LABEL(sys_getitimer), C_LABEL(sys_nis_syscall), C_LABEL(sys_sethostname)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_dup2), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_fcntl), C_LABEL(sys_select), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_fsync), C_LABEL(sys_setpriority), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
/*100*/	.xword C_LABEL(sys_getpriority), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_gettimeofday), C_LABEL(sys_getrusage)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall), C_LABEL(sys_readv)
	.xword C_LABEL(sys_writev), C_LABEL(sys_settimeofday), C_LABEL(sys_fchown)
	.xword C_LABEL(sys_fchmod), C_LABEL(sys_nis_syscall), C_LABEL(sys_setreuid)
	.xword C_LABEL(sys_setregid), C_LABEL(sys_rename), C_LABEL(sys_truncate)
	.xword C_LABEL(sys_ftruncate), C_LABEL(sys_flock), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_mkdir), C_LABEL(sys_rmdir), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall), C_LABEL(sys_getrlimit)
	.xword C_LABEL(sys_setrlimit), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
/*150*/	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_statfs), C_LABEL(sys_fstatfs)
	.xword C_LABEL(sys_umount), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_setdomainname)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_quotactl), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_mount), C_LABEL(sys_ustat), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_getdents), C_LABEL(sys_setsid)
	.xword C_LABEL(sys_fchdir), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_sigpending), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_setpgid), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_newuname), C_LABEL(sys_init_module)
	.xword C_LABEL(sys_personality), C_LABEL(sys_prof), C_LABEL(sys_break)
	.xword C_LABEL(sys_lock), C_LABEL(sys_mpx), C_LABEL(sys_ulimit)
	.xword C_LABEL(sys_getppid), C_LABEL(sparc_sigaction), C_LABEL(sys_sgetmask)
/*200*/	.xword C_LABEL(sys_ssetmask), C_LABEL(sys_sigsuspend), C_LABEL(sys_newlstat)
	.xword C_LABEL(sys_uselib), C_LABEL(old_readdir), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_socketcall), C_LABEL(sys_syslog), C_LABEL(sys_olduname)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_idle), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_waitpid), C_LABEL(sys_swapoff), C_LABEL(sys_sysinfo)
	.xword C_LABEL(sys_ipc), C_LABEL(sys_sigreturn), C_LABEL(sys_clone)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_adjtimex), C_LABEL(sys_sigprocmask)
	.xword C_LABEL(sys_create_module), C_LABEL(sys_delete_module)
	.xword C_LABEL(sys_get_kernel_syms), C_LABEL(sys_getpgid), C_LABEL(sys_bdflush)
	.xword C_LABEL(sys_sysfs), C_LABEL(sys_nis_syscall), C_LABEL(sys_setfsuid)
	.xword C_LABEL(sys_setfsgid), C_LABEL(sys_llseek), C_LABEL(sys_time)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_stime), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_llseek)
	/* "We are the Knights of the Forest of Ni!!" */
	.xword C_LABEL(sys_mlock), C_LABEL(sys_munlock), C_LABEL(sys_mlockall)
	.xword C_LABEL(sys_munlockall), C_LABEL(sys_sched_setparam)
	.xword C_LABEL(sys_sched_getparam), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_sched_get_priority_max), C_LABEL(sys_sched_get_priority_min)
	.xword C_LABEL(sys_sched_rr_get_interval), C_LABEL(sys_nanosleep)
/*250*/	.xword C_LABEL(sys_mremap)
	.xword C_LABEL(sys_sysctl)
	.xword C_LABEL(sys_getsid), C_LABEL(sys_fdatasync), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_aplib), C_LABEL(sys_nis_syscall)

	/* Now the 64-bit native Linux syscall table. */

	.globl C_LABEL(sys_call_table64)
C_LABEL(sys_call_table64):
/*0*/	.xword C_LABEL(sys_setup), C_LABEL(sys_exit), C_LABEL(sys_fork)
	.xword C_LABEL(sys_read), C_LABEL(sys_write)
/*5*/	.xword C_LABEL(sys_open), C_LABEL(sys_close), C_LABEL(sys_wait4)
	.xword C_LABEL(sys_creat), C_LABEL(sys_link)
/*10*/  .xword C_LABEL(sys_unlink), C_LABEL(sunos_execv), C_LABEL(sys_chdir)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_mknod)
/*15*/	.xword C_LABEL(sys_chmod), C_LABEL(sys_chown), C_LABEL(sparc_brk)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_lseek)
/*20*/	.xword C_LABEL(sys_getpid), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_setuid), C_LABEL(sys_getuid)
/*25*/	.xword C_LABEL(sys_time), C_LABEL(sys_ptrace), C_LABEL(sys_alarm)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_pause)
/*30*/	.xword C_LABEL(sys_utime), C_LABEL(sys_stty), C_LABEL(sys_gtty)
	.xword C_LABEL(sys_access), C_LABEL(sys_nice), C_LABEL(sys_ftime)
	.xword C_LABEL(sys_sync), C_LABEL(sys_kill), C_LABEL(sys_newstat)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_newlstat), C_LABEL(sys_dup)
	.xword C_LABEL(sys_pipe), C_LABEL(sys_times), C_LABEL(sys_profil)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_setgid), C_LABEL(sys_getgid)
	.xword C_LABEL(sys_signal), C_LABEL(sys_geteuid)
/*50*/	.xword C_LABEL(sys_getegid), C_LABEL(sys_acct), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_ioctl), C_LABEL(sys_reboot)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_symlink), C_LABEL(sys_readlink)
	.xword C_LABEL(sys_execve), C_LABEL(sys_umask), C_LABEL(sys_chroot)
	.xword C_LABEL(sys_newfstat), C_LABEL(sys_nis_syscall), C_LABEL(sys_getpagesize)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_vfork), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_mmap), C_LABEL(sys_nis_syscall), C_LABEL(sys_munmap)
	.xword C_LABEL(sys_mprotect), C_LABEL(sys_nis_syscall), C_LABEL(sys_vhangup)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall), C_LABEL(sys_getgroups)
	.xword C_LABEL(sys_setgroups), C_LABEL(sys_getpgrp), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_setitimer), C_LABEL(sys_nis_syscall), C_LABEL(sys_swapon)
	.xword C_LABEL(sys_getitimer), C_LABEL(sys_nis_syscall), C_LABEL(sys_sethostname)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_dup2), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_fcntl), C_LABEL(sys_select), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_fsync), C_LABEL(sys_setpriority), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
/*100*/	.xword C_LABEL(sys_getpriority), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_gettimeofday), C_LABEL(sys_getrusage)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall), C_LABEL(sys_readv)
	.xword C_LABEL(sys_writev), C_LABEL(sys_settimeofday), C_LABEL(sys_fchown)
	.xword C_LABEL(sys_fchmod), C_LABEL(sys_nis_syscall), C_LABEL(sys_setreuid)
	.xword C_LABEL(sys_setregid), C_LABEL(sys_rename), C_LABEL(sys_truncate)
	.xword C_LABEL(sys_ftruncate), C_LABEL(sys_flock), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_mkdir), C_LABEL(sys_rmdir), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall), C_LABEL(sys_getrlimit)
	.xword C_LABEL(sys_setrlimit), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
/*150*/	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_statfs), C_LABEL(sys_fstatfs)
	.xword C_LABEL(sys_umount), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_setdomainname)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_quotactl), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_mount), C_LABEL(sys_ustat), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_getdents), C_LABEL(sys_setsid)
	.xword C_LABEL(sys_fchdir), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_sigpending), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_setpgid), C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_newuname), C_LABEL(sys_init_module)
	.xword C_LABEL(sys_personality), C_LABEL(sys_prof), C_LABEL(sys_break)
	.xword C_LABEL(sys_lock), C_LABEL(sys_mpx), C_LABEL(sys_ulimit)
	.xword C_LABEL(sys_getppid), C_LABEL(sparc_sigaction), C_LABEL(sys_sgetmask)
/*200*/	.xword C_LABEL(sys_ssetmask), C_LABEL(sys_sigsuspend), C_LABEL(sys_newlstat)
	.xword C_LABEL(sys_uselib), C_LABEL(old_readdir), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_socketcall), C_LABEL(sys_syslog), C_LABEL(sys_olduname)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_idle), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_waitpid), C_LABEL(sys_swapoff), C_LABEL(sys_sysinfo)
	.xword C_LABEL(sys_ipc), C_LABEL(sys_sigreturn), C_LABEL(sys_clone)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_adjtimex), C_LABEL(sys_sigprocmask)
	.xword C_LABEL(sys_create_module), C_LABEL(sys_delete_module)
	.xword C_LABEL(sys_get_kernel_syms), C_LABEL(sys_getpgid), C_LABEL(sys_bdflush)
	.xword C_LABEL(sys_sysfs), C_LABEL(sys_nis_syscall), C_LABEL(sys_setfsuid)
	.xword C_LABEL(sys_setfsgid), C_LABEL(sys_llseek), C_LABEL(sys_time)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_stime), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_llseek)
	/* "We are the Knights of the Forest of Ni!!" */
	.xword C_LABEL(sys_mlock), C_LABEL(sys_munlock), C_LABEL(sys_mlockall)
	.xword C_LABEL(sys_munlockall), C_LABEL(sys_sched_setparam)
	.xword C_LABEL(sys_sched_getparam), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_nis_syscall), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_sched_get_priority_max), C_LABEL(sys_sched_get_priority_min)
	.xword C_LABEL(sys_sched_rr_get_interval), C_LABEL(sys_nanosleep)
/*250*/	.xword C_LABEL(sys_mremap)
	.xword C_LABEL(sys_sysctl)
	.xword C_LABEL(sys_getsid), C_LABEL(sys_fdatasync), C_LABEL(sys_nis_syscall)
	.xword C_LABEL(sys_aplib), C_LABEL(sys_nis_syscall)

	/* Now the 32-bit SunOS syscall table. */

	.align 4
	.globl C_LABEL(sunos_sys_table)
C_LABEL(sunos_sys_table):
/*0*/	.xword C_LABEL(sunos_indir), C_LABEL(sys_exit), C_LABEL(sys_fork)
	.xword C_LABEL(sunos_read), C_LABEL(sunos_write), C_LABEL(sunos_open)
	.xword C_LABEL(sys_close), C_LABEL(sunos_wait4), C_LABEL(sys_creat)
	.xword C_LABEL(sys_link), C_LABEL(sys_unlink), C_LABEL(sunos_execv)
	.xword C_LABEL(sys_chdir), C_LABEL(sunos_nosys), C_LABEL(sys_mknod)
	.xword C_LABEL(sys_chmod), C_LABEL(sys_chown), C_LABEL(sunos_brk)
	.xword C_LABEL(sunos_nosys), C_LABEL(sys_lseek), C_LABEL(sunos_getpid)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_getuid), C_LABEL(sunos_nosys), C_LABEL(sys_ptrace)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sys_access), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sys_sync), C_LABEL(sys_kill), C_LABEL(sys_newstat)
	.xword C_LABEL(sunos_nosys), C_LABEL(sys_newlstat), C_LABEL(sys_dup)
	.xword C_LABEL(sys_pipe), C_LABEL(sunos_nosys), C_LABEL(sys_profil)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_getgid)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
/*50*/	.xword C_LABEL(sunos_nosys), C_LABEL(sys_acct), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_mctl), C_LABEL(sunos_ioctl), C_LABEL(sys_reboot)
	.xword C_LABEL(sunos_nosys), C_LABEL(sys_symlink), C_LABEL(sys_readlink)
	.xword C_LABEL(sys_execve), C_LABEL(sys_umask), C_LABEL(sys_chroot)
	.xword C_LABEL(sys_newfstat), C_LABEL(sunos_nosys), C_LABEL(sys_getpagesize)
	.xword C_LABEL(sys_msync), C_LABEL(sys_vfork), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_sbrk), C_LABEL(sunos_sstk)
	.xword C_LABEL(sunos_mmap), C_LABEL(sunos_vadvise), C_LABEL(sys_munmap)
	.xword C_LABEL(sys_mprotect), C_LABEL(sunos_madvise), C_LABEL(sys_vhangup)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_mincore), C_LABEL(sys_getgroups)
	.xword C_LABEL(sys_setgroups), C_LABEL(sys_getpgrp), C_LABEL(sunos_setpgrp)
	.xword C_LABEL(sys_setitimer), C_LABEL(sunos_nosys), C_LABEL(sys_swapon)
	.xword C_LABEL(sys_getitimer), C_LABEL(sys_gethostname), C_LABEL(sys_sethostname)
	.xword C_LABEL(sunos_getdtablesize), C_LABEL(sys_dup2), C_LABEL(sunos_nop)
	.xword C_LABEL(sys_fcntl), C_LABEL(sunos_select), C_LABEL(sunos_nop)
	.xword C_LABEL(sys_fsync), C_LABEL(sys_setpriority), C_LABEL(sys_socket)
	.xword C_LABEL(sys_connect), C_LABEL(sunos_accept)
/*100*/	.xword C_LABEL(sys_getpriority), C_LABEL(sunos_send), C_LABEL(sunos_recv)
	.xword C_LABEL(sunos_nosys), C_LABEL(sys_bind), C_LABEL(sunos_setsockopt)
	.xword C_LABEL(sys_listen), C_LABEL(sunos_nosys), C_LABEL(sunos_sigaction)
	.xword C_LABEL(sunos_sigblock), C_LABEL(sunos_sigsetmask), C_LABEL(sys_sigpause)
	.xword C_LABEL(sys_sigstack), C_LABEL(sys_recvmsg), C_LABEL(sys_sendmsg)
	.xword C_LABEL(sunos_nosys), C_LABEL(sys_gettimeofday), C_LABEL(sys_getrusage)
	.xword C_LABEL(sunos_getsockopt), C_LABEL(sunos_nosys), C_LABEL(sunos_readv)
	.xword C_LABEL(sunos_writev), C_LABEL(sys_settimeofday), C_LABEL(sys_fchown)
	.xword C_LABEL(sys_fchmod), C_LABEL(sys_recvfrom), C_LABEL(sys_setreuid)
	.xword C_LABEL(sys_setregid), C_LABEL(sys_rename), C_LABEL(sys_truncate)
	.xword C_LABEL(sys_ftruncate), C_LABEL(sys_flock), C_LABEL(sunos_nosys)
	.xword C_LABEL(sys_sendto), C_LABEL(sys_shutdown), C_LABEL(sys_socketpair)
	.xword C_LABEL(sys_mkdir), C_LABEL(sys_rmdir), C_LABEL(sys_utimes)
	.xword C_LABEL(sys_sigreturn), C_LABEL(sunos_nosys), C_LABEL(sys_getpeername)
	.xword C_LABEL(sunos_gethostid), C_LABEL(sunos_nosys), C_LABEL(sys_getrlimit)
	.xword C_LABEL(sys_setrlimit), C_LABEL(sunos_killpg), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
/*150*/	.xword C_LABEL(sys_getsockname), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_poll), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_getdirentries), C_LABEL(sys_statfs), C_LABEL(sys_fstatfs)
	.xword C_LABEL(sys_umount), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_getdomainname), C_LABEL(sys_setdomainname)
	.xword C_LABEL(sunos_nosys), C_LABEL(sys_quotactl), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_mount), C_LABEL(sys_ustat), C_LABEL(sunos_semsys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_shmsys), C_LABEL(sunos_audit)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_getdents), C_LABEL(sys_setsid)
	.xword C_LABEL(sys_fchdir), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sys_sigpending), C_LABEL(sunos_nosys)
	.xword C_LABEL(sys_setpgid), C_LABEL(sunos_pathconf), C_LABEL(sunos_fpathconf)
	.xword C_LABEL(sunos_sysconf), C_LABEL(sunos_uname), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
/*200*/	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
/*250*/	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sunos_nosys)
	.xword C_LABEL(sunos_nosys), C_LABEL(sunos_nosys), C_LABEL(sys_aplib)
