/*
 * Network disk client
 * Kernel block device driver
 *
 * Copyright (c) 1996 Petr Salinger
 * Copyright (c) 1999 Libor Bus <l.bus@sh.cvut.cz>
 * Copyright (c) 2001 Lubomir Bulej <pallas@kadan.cz>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _LINUX_NWD_H
#define _LINUX_NWD_H

#include <linux/ioctl.h>


/*****************************************************************************\
| KERNEL & USER SPACE                                                         |
\*****************************************************************************/

#define NWD_IOCTL_CHAR		'N'
#define NWD_CTL_SETPEER		_IOW (NWD_IOCTL_CHAR, 0, nwd_peer_t)
#define NWD_CTL_GETPEER		_IOR (NWD_IOCTL_CHAR, 1, nwd_peer_t)
#define NWD_CTL_SETOPTS		_IO (NWD_IOCTL_CHAR, 3)
#define NWD_CTL_GETOPTS		_IO (NWD_IOCTL_CHAR, 4)
#define NWD_CTL_DISPOSE		_IO (NWD_IOCTL_CHAR, 5)

#define	NWD_OPT_DISPOSE		0x1				/* dispose changes on release		*/
#define	NWD_OPT_DISCONNECT	0x2				/* disconnect from server on release	*/
#define NWD_OPT_PROTO_TCP	0x4				/* use TCP for RPC transport		*/

typedef struct nwd_peer {
	struct sockaddr_in	saddr;				/* socket address of the server		*/
	int 			devid;				/* requested identification for lookup	*/
} nwd_peer_t;


/*****************************************************************************\
| KERNEL ONLY                                                                 |
\*****************************************************************************/

#ifdef __KERNEL__

#include <linux/fs.h>
#include <asm/semaphore.h>
#include <linux/sunrpc/clnt.h>

#define NWD_MAJOR		62

#define NWD_DFL_DEVID		1
#define NWD_DFL_OPTIONS		(NWD_OPT_DISPOSE)
#define NWD_DFL_INIDISPOSE	1

#define NWD_SEC_BITS		9				/* device sector size in bits		*/
#define NWD_SEC_SIZE		(1U << NWD_SEC_BITS)		/* sector size (must be power of 2)	*/
#define NWD_B2S_SHIFT		(BLOCK_SIZE_BITS-NWD_SEC_BITS)	/* shift to convert blocks to sectors	*/


/*
 * NWD_MAX_DGLEN determines the number of fragments per datagram
 *	1024 - one fragment is enough; this is usually used for ext2
 *	4096 - more fragments; useful for paging
 */
 
#define NWD_MAX_DGLEN		(4 * NWD_SEC_SIZE)		/* must be multiple of NWD_SEC_SIZE	*/
#define NWD_MAX_SNLEN		20				/* max. length of server name		*/
#define NWD_MAX_DEVICES		8				/* default number of nwd devices	*/
#define NWD_MAX_RETRIES		10				/* how many times we retry the request	*/


typedef struct nwd_device {
	int 			remid;    			/* id of remote file disk operations	*/
	int			devnum;				/* NWD device number			*/
	int 			options;			/* NWD device options			*/
	nwd_peer_t		server;				/* server address & lookup id		*/
	struct rpc_clnt *	client;  			/* RPC client				*/
	char			sname [NWD_MAX_SNLEN];		/* server name for debug messages	*/

	int			users;				/* reference counter			*/
	struct semaphore	mxctl;				/* device control mutex			*/
	
	request_queue_t		queue;				/* device request queue			*/
} nwd_device_t;

#endif /* __KERNEL__ */

#endif /* _LINUX_NWD_H */
