
#ifndef __CRYPTOMARK_LOG_H
#define __CRYPTOMARK_LOG_H

/* Module versioning code  */
#include <linux/autoconf.h> 		/* Retrieve the CONFIG_* macros */
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
	#define MODVERSIONS 		/* Force it on */
	#include <linux/modversions.h>
#endif

#undef TRACE_CRYPTOMARK
//#define TRACE_CRYPTOMARK

#ifdef __KERNEL__

#include <linux/kernel.h>
#include <linux/string.h>

/*======================================================================
 *
 *  Debugging macros
 *
 *======================================================================*/
#ifdef CONFIG_CRYPTOMARK_DEBUG
        #define dbg(fmt, args...) printk(KERN_DEBUG "CryptoMark: " fmt "\n" , ## args)
#else
        #define dbg(fmt, args...) do {} while (0)
#endif

#ifdef TRACE_CRYPTOMARK
        #define trace()		printk(KERN_DEBUG "CryptoMark: "__FUNCTION__"\n")
#else
        #define trace()		do {} while (0)
#endif
	

#define err(format, arg...)	printk(KERN_ERR		"CryptoMark: " format "\n" , ## arg)
#define info(format, arg...)	printk(KERN_INFO	"CryptoMark: " format "\n" , ## arg)
#define warn(format, arg...)	printk(KERN_WARNING	"CryptoMark: " format "\n" , ## arg)


#ifdef CONFIG_CRYPTOMARK_DEBUG
	#define g10_log_debug(format, args...)	printk(KERN_DEBUG	"CryptoMark g10: " format "\n", ## args)
	#define g10_log_info(format, arg...)	printk(KERN_INFO	"CryptoMark gnupg: " format "\n", ## arg)
	#define g10_log_error(format, arg...)	printk(KERN_ERR		"CryptoMark gnupg: " format "\n", ## arg)
	#define g10_log_fatal(format, arg...)	printk(KERN_ERR		"CryptoMark gnupg: " format "\n", ## arg)
	#define g10_log_warn(format, arg...)	printk(KERN_WARNING	"CryptoMark gnupg: " format "\n", ## arg)
	#define g10_log_bug0(format, arg...)	printk(KERN_ERR		"CryptoMark gnupg Bug: " format "\n", ## arg)
	#define g10_log_bug(format, arg...)	printk(KERN_ERR		"CryptoMark gnupg Bug: " format "\n", ## arg)
#else
        #define g10_log_debug(format, args...)	do {} while (0)
	#define g10_log_info(format, arg...)	do {} while (0)
	#define g10_log_error(format, arg...)	do {} while (0)
	#define g10_log_fatal(format, arg...)	do {} while (0)
	#define g10_log_warn(format, arg...)	do {} while (0)
	#define g10_log_bug0(format, arg...)	do {} while (0)
	#define g10_log_bug(format, arg...)	do {} while (0)
#endif


#endif	/* __KERNEL__ */

#endif	/* __CRYPTOMARK_LOG_H */
