/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Connection component state management 
 */


#ifndef LLC_C_ST_H
#define LLC_C_ST_H


/* connection states */
#define CONN_OUT_OF_SVC            0       /* prior to allocation */

#define CONN_STATE_ADM             1       /* disconnected, initial state */
#define CONN_STATE_SETUP           2       /* disconnected state */
#define CONN_STATE_NORMAL          3       /* connected state */
#define CONN_STATE_BUSY            4       /* connected state */
#define CONN_STATE_REJECT          5       /* connected state */
#define CONN_STATE_AWAIT           6       /* connected state */
#define CONN_STATE_AWAIT_BUSY      7       /* connected state */
#define CONN_STATE_AWAIT_REJECT    8       /* connected state */
#define CONN_STATE_D_CONN          9       /* disconnected state */
#define CONN_STATE_RESET           10      /* disconnected state */
#define CONN_STATE_ERROR           11      /* disconnected state */
#define CONN_STATE_TEMP            12      /* disconnected state */

#define NBR_CONN_STATES            12      /* size of state table */

#define NO_STATE_CHANGE            100      


#ifndef LLC_MAIN_C

/* Connection state table structure */
typedef struct
{
#if 0
   us8                     event;
#else
   conn_event_t            event;
#endif
   us8                     next_state;
   conn_event_qfyr_t *     event_qualifiers;
   conn_action_t *         event_actions;
} conn_state_transition_t;


typedef struct
{
   us8  	           current_state;
   conn_state_transition_t **
                           transitions;
} conn_state_t;


#ifdef LLC_C_ST_C
#define EXTRN
#else
#define EXTRN extern

EXTRN conn_state_t          Connection_state_table [];

#endif /* LLC_C_ST_C */

#endif /* LLC_MAIN_C */

#undef EXTRN
#endif LLC_C_ST_H

