#!/bin/bash
###########################################################################
#
# Linux NetBEUI un-installation script
#
# Copyright (c) 1999 by Procom Technology,Inc.
#
# This program can be redistributed or modified under the terms of the
# GNU General Public License as published by the Free Software Foundation.
# This program is distributed without any warranty or implied warranty
# of merchantability or fitness for a particular purpose.
#
# See the GNU General Public License for more details.
#
###########################################################################
 
TMP_FILE=/tmp/netb_inst$$
KERNEL_TREE=$1

FILES_UPDATED=""
UPDATED="YES"
LAST_ERROR=""


inform_errors()
{
        echo ""
        echo "NetBEUI uninstallation finished with errors: $1"
        echo ""
}


inform_update()
{
	echo $1 updated
}

inform_not_found()
{
        echo "Error: $1 is not found below the kernel tree!"
}

inform_not_updated()
{
        echo "$1 not updated by NetBEUI yet"
}

check_if_updated()
{
        NOT_FOUND=""
        UPDATED="YES"
        if [ "$2" != "0" ]
        then
                identity="# Updated by NetBEUI on "
        else
                identity="Updated by NetBEUI on "
        fi
        identity=`sed -n -e "/$identity/=" $1 2>/dev/null`
        if [ $? != 0 ]
        then
                inform_not_found $1
                LAST_ERROR="SOME FILES ARE MISSING!"
                NOT_FOUND="YES"
		return
        fi
        if [ "$identity" = "" ]
        then
                inform_not_updated $1
                UPDATED=""
        else
                FILES_UPDATED="YES"
        fi
}


remove_files()
{
        echo Removing NetBEUI files ...
        rm -rf $KERNEL_TREE/net/netbeui
        echo Removing LLC files ...
        rm -rf $KERNEL_TREE/net/8022llc
        rm -f $KERNEL_TREE/net/core/ext8022.c
        echo Removing include files ...
        rm -f $KERNEL_TREE/include/linux/af_netb.h
        rm -f $KERNEL_TREE/include/linux/dextab.h
        rm -f $KERNEL_TREE/include/linux/netbeui.h
        rm -f $KERNEL_TREE/include/net/cm_{bp,dll,frame,mm,types}.h
        rm -f $KERNEL_TREE/include/net/decode.h
        rm -f $KERNEL_TREE/include/net/lan_hdrs.h
        rm -f $KERNEL_TREE/include/net/llc_*.h
        rm -f $KERNEL_TREE/include/net/stk_{init,rsrc}.h
        rm -f $KERNEL_TREE/include/net/usr_to_krnl.h
        rm -f $KERNEL_TREE/include/net/os_if.h
	rm -f /usr/bin/netb
	rm -f /usr/bin/nbview
 
}

uninstall_net_makefile()
{
	ORG_FILE=$KERNEL_TREE/net/Makefile
	check_if_updated $ORG_FILE 1
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "^ALL_SUB_DIRS :=")) 
		{ gsub("8022llc |netbeui ", "", $0) }
	else if (match($0, "CONFIG_NETBEUI"))
		{ getline; getline; getline; getline }
	else if (match($0, "# Updated by NetBEUI on"))
		getline
	print $0
	}' $ORG_FILE > $TMP_FILE
	
	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_net_configin()
{
	ORG_FILE=$KERNEL_TREE/net/Config.in
	check_if_updated $ORG_FILE 1
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "NetBEUI Protocol"))
		{ getline; getline; getline; getline; getline }
	else if (match($0, "# Updated by NetBEUI on"))
		getline
	print $0
	}' $ORG_FILE > $TMP_FILE
	
	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_include_procfs()
{
	ORG_FILE=$KERNEL_TREE/include/linux/proc_fs.h
	check_if_updated $ORG_FILE 0
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "PROC_NETBEUI"))
		{ getline; getline; getline; getline }
	else if (match($0, "Updated by NetBEUI on"))
		{ getline; getline }
	print $0
	}' $ORG_FILE > $TMP_FILE

	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_include_socket()
{
	ORG_FILE=$KERNEL_TREE/include/linux/socket.h
	check_if_updated $ORG_FILE 0
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
BEGIN	{
	MAX_PROTOCOL=0
	}
	{
	if (match($0, "AF_NETBEUI|PF_NETBEUI"))
		{
		MAX_PROTOCOL=$3
		next
		}
	else if (match($0, "AF_MAX"))
		{
		if (MAX_PROTOCOL+1 == $3)
			{
			printf "#define AF_MAX 		%u\n", MAX_PROTOCOL
			getline
			}
		}
	else if (match($0, "Updated by NetBEUI on"))
		{ getline; getline }
	print $0
	}' $ORG_FILE > $TMP_FILE

	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_core_makefile()
{
	ORG_FILE=$KERNEL_TREE/net/core/Makefile
	check_if_updated $ORG_FILE 1
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "ext8022.o")) 
		{ gsub("ext8022.o", "", $0) }
	else if (match($0, "# Updated by NetBEUI on"))
		getline
	print $0
	}' $ORG_FILE > $TMP_FILE
	
	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_net_netsyms()
{
	ORG_FILE=$KERNEL_TREE/net/netsyms.c
	check_if_updated $ORG_FILE 0
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "^extern void P8022_register_sap"))
		{ getline; getline; getline; getline }
	else if (match($0, "X[(]P8022_register_sap[)]"))
		{ getline; getline; getline; }
	else if (match($0, "Updated by NetBEUI on"))
		{ getline; getline }
	else if (match($0, "X[(]tr_source_route[)]"))
		{ getline }
	else if (match($0, "X[(]dev_mc_delete[)]"))
		{ getline }
	print $0
	}' $ORG_FILE > $TMP_FILE

	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_net_p8022()
{
	ORG_FILE=$KERNEL_TREE/net/802/p8022.c
	check_if_updated $ORG_FILE 0
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "dev_add_pack"))
		{ 
		print "	dev_add_pack(&p8022_packet_type);"
		getline 
		}
	else if (match($0, "P8022_register_sap"))
		{ getline }
	else if (match($0, "P8022_unregister_sap"))
		{ getline }
	else if (match($0, "Updated by NetBEUI on"))
		{ getline; getline }
	print $0
	}' $ORG_FILE > $TMP_FILE

	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_net_p8022tr()
{
	ORG_FILE=$KERNEL_TREE/net/802/p8022tr.c
	check_if_updated $ORG_FILE 0
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "dev_add_pack"))
		{ 
		print "	dev_add_pack(&p8022tr_packet_type);"
		getline 
		}
	else if (match($0, "P8022_register_sap"))
		{ getline }
	else if (match($0, "P8022_unregister_sap"))
		{ getline }
	else if (match($0, "Updated by NetBEUI on"))
		{ getline; getline }
	print $0
	}' $ORG_FILE > $TMP_FILE

	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_net_802_tr()
{
	ORG_FILE=$KERNEL_TREE/net/802/tr.c
	check_if_updated $ORG_FILE 0
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "void tr_source_route\\(struct trh_hdr \\*trh,struct device \\*dev\\);"))
		{ 
		print "static void tr_source_route(struct trh_hdr *trh,struct device *dev);"
		getline 
		}
	else if (match($0, "void tr_source_route\\(struct trh_hdr \\*trh,struct device \\*dev\\) {"))
		{
		print "static void tr_source_route(struct trh_hdr *trh,struct device *dev) {"
		getline
		}
	else if (match($0, "Updated by NetBEUI on"))
		{ getline; getline }
	print $0
	}' $ORG_FILE > $TMP_FILE

	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


uninstall_net_trdevice()
{
	ORG_FILE=$KERNEL_TREE/include/linux/trdevice.h
	check_if_updated $ORG_FILE 0
        if [ "$UPDATED" = "" -o "$NOT_FOUND" != "" ]
        then
                return
        fi

awk '
	{
	if (match($0, "tr_source_route"))
		{ 
		getline 
		}
	else if (match($0, "Updated by NetBEUI on"))
		{ getline; getline }
	print $0
	}' $ORG_FILE > $TMP_FILE

	mv $TMP_FILE $ORG_FILE

	inform_update $ORG_FILE
}


orgdir=`pwd`
cd $KERNEL_TREE

echo Modifying the files in the kernel tree
uninstall_net_makefile
uninstall_net_configin
uninstall_include_procfs
uninstall_include_socket
uninstall_core_makefile
uninstall_net_netsyms
uninstall_net_p8022
uninstall_net_p8022tr
uninstall_net_802_tr
uninstall_net_trdevice

remove_files

if [ "$LAST_ERROR" != "" ]
then
        inform_errors "$LAST_ERROR"
fi

cd $orgdir
echo ""
