#!/bin/bash
###########################################################################
#
# NetBEUI for SAMBA patching/unpatching script
#
# Copyright (c) 1999 by Procom Technology,Inc.
#
# This program can be redistributed or modified under the terms of the
# GNU General Public License as published by the Free Software Foundation.
# This program is distributed without any warranty or implied warranty
# of merchantability or fitness for a particular purpose.
#
# See the GNU General Public License for more details.
#
###########################################################################

SAMBA_DIR=$2
SAMBA_VER=$3
PKG_DIR=$4
SRC_DIR=$PKG_DIR/source/samba/$SAMBA_VER

APPLIED=""
LAST_ERROR=""

inform_errors()
{
        echo ""
        echo "NetBEUI modification for SAMBA finished with errors: $1"
        echo ""
}

modify_makefile()
{
	ORG_FILE=$SAMBA_DIR/source/Makefile
	TMP_FILE=$ORG_FILE.tmp
	
	if [ ! -r $ORG_FILE ]
	then
		LAST_ERROR="SAMBA is not configured yet"
		echo You must configure SAMBA first.
		return
	fi
	echo $ACTION Makefile ...

	identity="# Updated by NetBEUI on "
	identity=`sed -n -e "/$identity/=" $ORG_FILE`
	if [ "$identity" != "" ] 	
	then
		echo Makefile already updated by NetBEUI.
		return
	fi
	
	if [ "$1" = "1.9.xx" ] 
	then
awk '
BEGIN 	{
	printf "# Updated by NetBEUI on "
	system("date")
	check = 0;
	}
	{
	if (match($0, "^[#| ]*FLAGSM =")) {
		sub("=", "= -DCONFIG_NETBEUI", $0);
		check = 1;
	}
	print $0
	}' $ORG_FILE > $TMP_FILE

	else

awk '
BEGIN 	{
	printf "# Updated by NetBEUI on "
	system("date")
	check = 0;
	}
	{
	if (match($0, "^[ ]*FLAGS1 =")) {
		sub("=", "= -DCONFIG_NETBEUI", $0);
		check = 1;
	}
	print $0
	}' $ORG_FILE > $TMP_FILE

	fi
	mv $TMP_FILE $ORG_FILE
}


restore_makefile()
{
        ORG_FILE=$SAMBA_DIR/source/Makefile
	TMP_FILE=$ORG_FILE.tmp

	if [ ! -r $ORG_FILE ]
	then
		LAST_ERROR="SAMBA is not configured yet"
		echo You must configure SAMBA first.
		return
	fi
	echo $ACTION Makefile ...
	
	if [ "$1" = "1.9.xx" ] 
	then

awk '
        {
	if (match($0, "^[#| ]*FLAGSM =")) 
                { gsub("-DCONFIG_NETBEUI ", "", $0) }
        else if (match($0, "# Updated by NetBEUI on"))
                getline
        print $0
        }' $ORG_FILE > $TMP_FILE

	else

awk '
        {
	if (match($0, "^[ ]*FLAGS1 =")) 
                { gsub("-DCONFIG_NETBEUI ", "", $0) }
        else if (match($0, "# Updated by NetBEUI on"))
                getline
        print $0
        }' $ORG_FILE > $TMP_FILE

	fi
        mv $TMP_FILE $ORG_FILE
}

patch_a_file()
{
	FNAME=`echo $1 | sed 's/[a-zA-Z0-9._]*\///g'`
	FNAME=`echo $FNAME | sed 's/.diff//'`
	if [ -r $2/$FNAME.orig ]
	then
		LAST_ERROR="SAMBA already updated by NetBEUI"
		return
	fi
	echo $ACTION $FNAME ...
	if [ ! -r $2/$FNAME ]; 
	then
		LAST_ERROR="File $FNAME is missing in $SAMBA_DIR"
		return
	fi
	patch -n -f -s $2/$FNAME < $1
}

patch_files()
{
	for i in $1/*; do
		patch_a_file $i $2
		if [ "$LAST_ERROR" != "" ];
		then
			return
		fi
	done
}

do_patch()
{
	if [ -r $SRC_DIR ]; 
	then
		for i in `cat $SRC_DIR/list`; do
			patch_files $SRC_DIR/$i $SAMBA_DIR/$i
		done
	else
		LAST_ERROR="The SAMBA version $SAMBA_VER not supported"
	fi
}

do_restore()
{
	for i in `cat $SRC_DIR/list`; do
		for j in $SAMBA_DIR/$i/*.orig; do
			if [ ! -r $j ]
			then
				LAST_ERROR="SAMBA is not updated by NetBEUI yet"
				return
			fi
			FNAME=`echo $j | sed 's/.orig//g'`
			SNAME=`echo $FNAME | sed 's/[a-zA-Z0-9._]*\///g'`
			echo $ACTION $SNAME ...
			cp $j $FNAME
			rm -f $j
		done
	done
}

if [ "$SAMBA_VER" = "" ]
then
	echo You should specify the SAMBA version in the Makefile first.
	echo See README file for more information.
else
	echo SAMBA version is $SAMBA_VER
	if [ "$1" = "PATCH" ]
	then
		ACTION="Patching"
		modify_makefile $SAMBA_VER
		if [ "$LAST_ERROR" = "" ]
		then
			do_patch
		fi
	fi
	if [ "$1" = "RESTORE" ]
	then
		ACTION="Restoring"
		restore_makefile $SAMBA_VER
		if [ "$LAST_ERROR" = "" ]
		then
			do_restore
		fi
	fi
	if [ "$LAST_ERROR" != "" ]
	then
		inform_errors "$LAST_ERROR"
	else
		echo "$ACTION SAMBA files finished successfully."
	fi
fi
