Only structural-match types (that is, types that derive `PartialEq` and `Eq`)
may be used as the types of const generic parameters.

```compile_fail,E0741
#![feature(const_generics)]

struct A;

struct B<const X: A>; // error!
```

To fix this example, we derive `PartialEq` and `Eq`.

```
#![feature(const_generics)]

#[derive(PartialEq, Eq)]
struct A;

struct B<const X: A>; // ok!
```
