'\" t
.\"     Title: xsetdevicevaluators
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.76.1 <http://docbook.sf.net/>
.\"      Date: 03/18/2011
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XSETDEVICEVALUATORS" "libmansuffix" "03/18/2011" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XSetDeviceValuators \- initialize the valuators on an extension input device
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
XSetDeviceValuators( Display *display,
                     XDevice *device,
                     int *valuators,
                     int first_valuator,
                     int num_valuators);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device whose valuators are to be
       initialized\&.
.fi
.sp
.nf
valuators
       Specifies a pointer to an array of integer values to be
       used to initialize thedevice valuators\&.
.fi
.sp
.nf
first_valuator
       Specifies the first valuator to be set\&. Valuators are
       numbered beginning withzero\&.
.fi
.sp
.nf
num_valuators
       Specifies the number of valuators to be set\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The XSetDeviceValuators request sets the current values of the
valuators of an input device\&. The valuators in the range
first_valuator to (first_valuator + num_valuators) are set to
the specified values\&. Valuators are numbered beginning with 0\&.
Not all input devices support initialization of valuator
values\&. If this request is made to a device that does not
support valuators initialization, a BadMatch error will occur\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the request succeeds, a status of Success is returned\&. If
another client has the device grabbed, a status of
AlreadyGrabbed is returned\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XSetDeviceValuators can generate a BadLength, BadDevice,
BadMatch, or BadValue error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The specified device
       does not exist or has not been opened by this client via
       XOpenInputDevice\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       This error may occur if an XSetDeviceValuators request
       is made specifying a device that has no valuators and
       reports no axes of motion, or if such a request is made
       specifying a device that does not support valuator
       initialization\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       An invalid first_valuator or num_valuators values was
       specified\&.
.fi
.if n \{\
.RE
.\}
