.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbTranslateKeySym __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbTranslateKeySym \- Find the string and symbol associated with a keysym for a 
given keyboard state
.SH SYNOPSIS
.B int XkbTranslateKeySym
(
.I dpy ,
.I sym_inout ,
.I mods ,
.I buf ,
.I nbytes ,
.I extra_rtrn
)
.br
      Display *\fIdpy\fP\^;
.br
      KeySym *\fIsym_inout\fP\^;
.br
      unsigned int  \fImods\fP\^;
.br
      char *\fIbuf\fP\^;
.br
      int \fInbytes\fP\^;
.br
      int *\fIextra_rtrn\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- sym_inout
symbol to be translated; result of translation
.TP
.I \- mods
modifiers to apply to sym_inout 
.TP
.I \- buf
buffer into which returned string is written 
.TP
.I \- nbytes
size of buffer in bytes
.TP
.I \- extra_rtrn
number of bytes overflow
.SH DESCRIPTION
.LP
.I XkbTranslateKeySym 
applies the transformations specified in 
.I mods 
to the symbol specified by 
.I sym_inout. 
It returns in 
.I buf 
the string, if any, associated with the keysym for the current locale. If the 
transformations in 
.I mods 
changes the keysym, 
.I sym_inout 
is updated accordingly. If the string returned is larger than 
.I nbytes,
a count of bytes that does not fit into the buffer is returned in 
.I extra_rtrn. XkbTranslateKeySym 
returns the number of bytes it placed into 
.I buf.
.SH "RETURN VALUES"
.TP 15
buf
Returns the string, if any, associated with the keysym for the current locale.


