/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinusIteration<E, X extends Exception>
extends FilterIteration<E, X> {
    private Iteration<? extends E, X> rightArg;
    private boolean distinct;
    private boolean initialized;
    private Set<E> excludeSet;

    public MinusIteration(Iteration<? extends E, X> leftArg, Iteration<? extends E, X> rightArg) {
        this(leftArg, rightArg, false);
    }

    public MinusIteration(Iteration<? extends E, X> leftArg, Iteration<? extends E, X> rightArg, boolean distinct) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.distinct = distinct;
        this.initialized = false;
    }

    @Override
    protected boolean accept(E object) throws X {
        if (!this.initialized) {
            this.excludeSet = Iterations.addAll(this.rightArg, new HashSet());
            this.initialized = true;
        }
        if (!this.excludeSet.contains(object)) {
            if (this.distinct) {
                this.excludeSet.add(object);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void handleClose() throws X {
        if (this.initialized) {
            this.excludeSet.clear();
        } else {
            Iterations.closeCloseable(this.rightArg);
        }
        super.handleClose();
    }
}

