// META: title=test WebNN API element-wise erf operation
// META: global=window
// META: variant=?cpu
// META: variant=?gpu
// META: variant=?npu
// META: script=../resources/utils.js
// META: timeout=long

'use strict';

// https://www.w3.org/TR/webnn/#api-mlgraphbuilder-unary
// Compute the error function of the input tensor, element-wise.
//
// MLOperand erf(MLOperand input);


const getErfPrecisionTolerance = (graphResources) => {
  const toleranceValueDict = {float32: 1 / 1024, float16: 1 / 512};
  const expectedDataType =
      getExpectedDataTypeOfSingleOutput(graphResources.expectedOutputs);
  return {metricType: 'ATOL', value: toleranceValueDict[expectedDataType]};
};

const erfTests = [
  {
    'name': 'erf float32 0D scalar',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [-0.004352752584964037],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [-0.004911554511636496],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'erf float32 1D constant tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.5883062481880188, -0.5323766469955444, 0.1279870569705963,
            0.5772181749343872,  0.904577910900116,   -0.49856746196746826,
            0.9843886494636536,  0.21642258763313293, 0.25235170125961304,
            -0.1491669863462448, 0.9136939644813538,  -0.5736439824104309,
            0.7404468059539795,  0.5202203392982483,  -0.16549505293369293,
            0.8005731701850891,  0.4001320004463196,  -0.7489422559738159,
            -0.8946002721786499, -0.3920256197452545, 0.6854220628738403,
            -0.6744900345802307, -0.439808189868927,  0.2709762454032898
          ],
          'descriptor': {shape: [24], dataType: 'float32'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5945858955383301,  -0.5484867095947266,  0.14363321661949158,
            0.5856771469116211,   0.7991966009140015,   -0.5192402005195618,
            0.8361185789108276,   0.2404468059539795,   0.27881762385368347,
            -0.16707675158977509, 0.8036975860595703,   -0.5827808976173401,
            0.7049695253372192,   0.5380884408950806,   -0.1850501298904419,
            0.742441713809967,    0.4285193383693695,   -0.710474967956543,
            -0.7941843867301941,  -0.4207003712654114,  0.6676210165023804,
            -0.6598520874977112,  -0.46604686975479126, 0.29844197630882263
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'erf float32 1D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.5883062481880188, -0.5323766469955444, 0.1279870569705963,
            0.5772181749343872,  0.904577910900116,   -0.49856746196746826,
            0.9843886494636536,  0.21642258763313293, 0.25235170125961304,
            -0.1491669863462448, 0.9136939644813538,  -0.5736439824104309,
            0.7404468059539795,  0.5202203392982483,  -0.16549505293369293,
            0.8005731701850891,  0.4001320004463196,  -0.7489422559738159,
            -0.8946002721786499, -0.3920256197452545, 0.6854220628738403,
            -0.6744900345802307, -0.439808189868927,  0.2709762454032898
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5945858955383301,  -0.5484867095947266,  0.14363321661949158,
            0.5856771469116211,   0.7991966009140015,   -0.5192402005195618,
            0.8361185789108276,   0.2404468059539795,   0.27881762385368347,
            -0.16707675158977509, 0.8036975860595703,   -0.5827808976173401,
            0.7049695253372192,   0.5380884408950806,   -0.1850501298904419,
            0.742441713809967,    0.4285193383693695,   -0.710474967956543,
            -0.7941843867301941,  -0.4207003712654114,  0.6676210165023804,
            -0.6598520874977112,  -0.46604686975479126, 0.29844197630882263
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'erf float32 2D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.5883062481880188, -0.5323766469955444, 0.1279870569705963,
            0.5772181749343872,  0.904577910900116,   -0.49856746196746826,
            0.9843886494636536,  0.21642258763313293, 0.25235170125961304,
            -0.1491669863462448, 0.9136939644813538,  -0.5736439824104309,
            0.7404468059539795,  0.5202203392982483,  -0.16549505293369293,
            0.8005731701850891,  0.4001320004463196,  -0.7489422559738159,
            -0.8946002721786499, -0.3920256197452545, 0.6854220628738403,
            -0.6744900345802307, -0.439808189868927,  0.2709762454032898
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5945858955383301,  -0.5484867095947266,  0.14363321661949158,
            0.5856771469116211,   0.7991966009140015,   -0.5192402005195618,
            0.8361185789108276,   0.2404468059539795,   0.27881762385368347,
            -0.16707675158977509, 0.8036975860595703,   -0.5827808976173401,
            0.7049695253372192,   0.5380884408950806,   -0.1850501298904419,
            0.742441713809967,    0.4285193383693695,   -0.710474967956543,
            -0.7941843867301941,  -0.4207003712654114,  0.6676210165023804,
            -0.6598520874977112,  -0.46604686975479126, 0.29844197630882263
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'erf float32 3D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.5883062481880188, -0.5323766469955444, 0.1279870569705963,
            0.5772181749343872,  0.904577910900116,   -0.49856746196746826,
            0.9843886494636536,  0.21642258763313293, 0.25235170125961304,
            -0.1491669863462448, 0.9136939644813538,  -0.5736439824104309,
            0.7404468059539795,  0.5202203392982483,  -0.16549505293369293,
            0.8005731701850891,  0.4001320004463196,  -0.7489422559738159,
            -0.8946002721786499, -0.3920256197452545, 0.6854220628738403,
            -0.6744900345802307, -0.439808189868927,  0.2709762454032898
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5945858955383301,  -0.5484867095947266,  0.14363321661949158,
            0.5856771469116211,   0.7991966009140015,   -0.5192402005195618,
            0.8361185789108276,   0.2404468059539795,   0.27881762385368347,
            -0.16707675158977509, 0.8036975860595703,   -0.5827808976173401,
            0.7049695253372192,   0.5380884408950806,   -0.1850501298904419,
            0.742441713809967,    0.4285193383693695,   -0.710474967956543,
            -0.7941843867301941,  -0.4207003712654114,  0.6676210165023804,
            -0.6598520874977112,  -0.46604686975479126, 0.29844197630882263
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'erf float32 4D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.5883062481880188, -0.5323766469955444, 0.1279870569705963,
            0.5772181749343872,  0.904577910900116,   -0.49856746196746826,
            0.9843886494636536,  0.21642258763313293, 0.25235170125961304,
            -0.1491669863462448, 0.9136939644813538,  -0.5736439824104309,
            0.7404468059539795,  0.5202203392982483,  -0.16549505293369293,
            0.8005731701850891,  0.4001320004463196,  -0.7489422559738159,
            -0.8946002721786499, -0.3920256197452545, 0.6854220628738403,
            -0.6744900345802307, -0.439808189868927,  0.2709762454032898
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5945858955383301,  -0.5484867095947266,  0.14363321661949158,
            0.5856771469116211,   0.7991966009140015,   -0.5192402005195618,
            0.8361185789108276,   0.2404468059539795,   0.27881762385368347,
            -0.16707675158977509, 0.8036975860595703,   -0.5827808976173401,
            0.7049695253372192,   0.5380884408950806,   -0.1850501298904419,
            0.742441713809967,    0.4285193383693695,   -0.710474967956543,
            -0.7941843867301941,  -0.4207003712654114,  0.6676210165023804,
            -0.6598520874977112,  -0.46604686975479126, 0.29844197630882263
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'erf float32 5D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.5883062481880188, -0.5323766469955444, 0.1279870569705963,
            0.5772181749343872,  0.904577910900116,   -0.49856746196746826,
            0.9843886494636536,  0.21642258763313293, 0.25235170125961304,
            -0.1491669863462448, 0.9136939644813538,  -0.5736439824104309,
            0.7404468059539795,  0.5202203392982483,  -0.16549505293369293,
            0.8005731701850891,  0.4001320004463196,  -0.7489422559738159,
            -0.8946002721786499, -0.3920256197452545, 0.6854220628738403,
            -0.6744900345802307, -0.439808189868927,  0.2709762454032898
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5945858955383301,  -0.5484867095947266,  0.14363321661949158,
            0.5856771469116211,   0.7991966009140015,   -0.5192402005195618,
            0.8361185789108276,   0.2404468059539795,   0.27881762385368347,
            -0.16707675158977509, 0.8036975860595703,   -0.5827808976173401,
            0.7049695253372192,   0.5380884408950806,   -0.1850501298904419,
            0.742441713809967,    0.4285193383693695,   -0.710474967956543,
            -0.7941843867301941,  -0.4207003712654114,  0.6676210165023804,
            -0.6598520874977112,  -0.46604686975479126, 0.29844197630882263
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      }
    }
  },

  // float16 tests
  {
    'name': 'erf float16 0D scalar',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [-0.004352569580078125],
          'descriptor': {shape: [], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [-0.004909515380859375],
          'descriptor': {shape: [], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'erf float16 1D constant tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.58837890625, -0.5322265625,   0.1279296875,    0.5771484375,
            0.90478515625,  -0.49853515625,  0.984375,        0.2164306640625,
            0.25244140625,  -0.149169921875, 0.91357421875,   -0.57373046875,
            0.740234375,    0.52001953125,   -0.16552734375,  0.80078125,
            0.400146484375, -0.7490234375,   -0.89453125,     -0.39208984375,
            0.685546875,    -0.67431640625,  -0.439697265625, 0.27099609375
          ],
          'descriptor': {shape: [24], dataType: 'float16'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5947265625,  -0.54833984375,   0.1435546875,    0.58544921875,
            0.79931640625,  -0.51904296875,   0.8359375,       0.240478515625,
            0.27880859375,  -0.1671142578125, 0.8037109375,    -0.5830078125,
            0.70458984375,  0.5380859375,     -0.18505859375,  0.74267578125,
            0.428466796875, -0.71044921875,   -0.7939453125,   -0.420654296875,
            0.66748046875,  -0.65966796875,   -0.466064453125, 0.298583984375
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'erf float16 1D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.58837890625, -0.5322265625,   0.1279296875,    0.5771484375,
            0.90478515625,  -0.49853515625,  0.984375,        0.2164306640625,
            0.25244140625,  -0.149169921875, 0.91357421875,   -0.57373046875,
            0.740234375,    0.52001953125,   -0.16552734375,  0.80078125,
            0.400146484375, -0.7490234375,   -0.89453125,     -0.39208984375,
            0.685546875,    -0.67431640625,  -0.439697265625, 0.27099609375
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5947265625,  -0.54833984375,   0.1435546875,    0.58544921875,
            0.79931640625,  -0.51904296875,   0.8359375,       0.240478515625,
            0.27880859375,  -0.1671142578125, 0.8037109375,    -0.5830078125,
            0.70458984375,  0.5380859375,     -0.18505859375,  0.74267578125,
            0.428466796875, -0.71044921875,   -0.7939453125,   -0.420654296875,
            0.66748046875,  -0.65966796875,   -0.466064453125, 0.298583984375
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'erf float16 2D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.58837890625, -0.5322265625,   0.1279296875,    0.5771484375,
            0.90478515625,  -0.49853515625,  0.984375,        0.2164306640625,
            0.25244140625,  -0.149169921875, 0.91357421875,   -0.57373046875,
            0.740234375,    0.52001953125,   -0.16552734375,  0.80078125,
            0.400146484375, -0.7490234375,   -0.89453125,     -0.39208984375,
            0.685546875,    -0.67431640625,  -0.439697265625, 0.27099609375
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5947265625,  -0.54833984375,   0.1435546875,    0.58544921875,
            0.79931640625,  -0.51904296875,   0.8359375,       0.240478515625,
            0.27880859375,  -0.1671142578125, 0.8037109375,    -0.5830078125,
            0.70458984375,  0.5380859375,     -0.18505859375,  0.74267578125,
            0.428466796875, -0.71044921875,   -0.7939453125,   -0.420654296875,
            0.66748046875,  -0.65966796875,   -0.466064453125, 0.298583984375
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'erf float16 3D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.58837890625, -0.5322265625,   0.1279296875,    0.5771484375,
            0.90478515625,  -0.49853515625,  0.984375,        0.2164306640625,
            0.25244140625,  -0.149169921875, 0.91357421875,   -0.57373046875,
            0.740234375,    0.52001953125,   -0.16552734375,  0.80078125,
            0.400146484375, -0.7490234375,   -0.89453125,     -0.39208984375,
            0.685546875,    -0.67431640625,  -0.439697265625, 0.27099609375
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5947265625,  -0.54833984375,   0.1435546875,    0.58544921875,
            0.79931640625,  -0.51904296875,   0.8359375,       0.240478515625,
            0.27880859375,  -0.1671142578125, 0.8037109375,    -0.5830078125,
            0.70458984375,  0.5380859375,     -0.18505859375,  0.74267578125,
            0.428466796875, -0.71044921875,   -0.7939453125,   -0.420654296875,
            0.66748046875,  -0.65966796875,   -0.466064453125, 0.298583984375
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'erf float16 4D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.58837890625, -0.5322265625,   0.1279296875,    0.5771484375,
            0.90478515625,  -0.49853515625,  0.984375,        0.2164306640625,
            0.25244140625,  -0.149169921875, 0.91357421875,   -0.57373046875,
            0.740234375,    0.52001953125,   -0.16552734375,  0.80078125,
            0.400146484375, -0.7490234375,   -0.89453125,     -0.39208984375,
            0.685546875,    -0.67431640625,  -0.439697265625, 0.27099609375
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5947265625,  -0.54833984375,   0.1435546875,    0.58544921875,
            0.79931640625,  -0.51904296875,   0.8359375,       0.240478515625,
            0.27880859375,  -0.1671142578125, 0.8037109375,    -0.5830078125,
            0.70458984375,  0.5380859375,     -0.18505859375,  0.74267578125,
            0.428466796875, -0.71044921875,   -0.7939453125,   -0.420654296875,
            0.66748046875,  -0.65966796875,   -0.466064453125, 0.298583984375
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'erf float16 5D tensor',
    'graph': {
      'inputs': {
        'erfInput': {
          'data': [
            -0.58837890625, -0.5322265625,   0.1279296875,    0.5771484375,
            0.90478515625,  -0.49853515625,  0.984375,        0.2164306640625,
            0.25244140625,  -0.149169921875, 0.91357421875,   -0.57373046875,
            0.740234375,    0.52001953125,   -0.16552734375,  0.80078125,
            0.400146484375, -0.7490234375,   -0.89453125,     -0.39208984375,
            0.685546875,    -0.67431640625,  -0.439697265625, 0.27099609375
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'erf',
        'arguments': [{'input': 'erfInput'}],
        'outputs': 'erfOutput'
      }],
      'expectedOutputs': {
        'erfOutput': {
          'data': [
            -0.5947265625,  -0.54833984375,   0.1435546875,    0.58544921875,
            0.79931640625,  -0.51904296875,   0.8359375,       0.240478515625,
            0.27880859375,  -0.1671142578125, 0.8037109375,    -0.5830078125,
            0.70458984375,  0.5380859375,     -0.18505859375,  0.74267578125,
            0.428466796875, -0.71044921875,   -0.7939453125,   -0.420654296875,
            0.66748046875,  -0.65966796875,   -0.466064453125, 0.298583984375
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      }
    }
  }
];

if (navigator.ml) {
  erfTests.forEach((test) => {
    webnn_conformance_test(
        buildAndExecuteGraph, getErfPrecisionTolerance, test);
  });
} else {
  test(() => assert_implements(navigator.ml, 'missing navigator.ml'));
}
