/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.CharBufferImpl;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public abstract class CharBuffer
extends Buffer
implements Comparable,
CharSequence {
    protected char[] backing_buffer;

    public static CharBuffer allocate(int capacity) {
        return new CharBufferImpl(capacity, 0, capacity);
    }

    public static final CharBuffer wrap(char[] array, int offset, int length) {
        return new CharBufferImpl(array, offset, length);
    }

    public static final CharBuffer wrap(CharSequence a) {
        return CharBuffer.wrap(a, 0, a.length());
    }

    public static final CharBuffer wrap(CharSequence a, int offset, int length) {
        if (offset < 0 || offset > a.length() || length < 0 || length > a.length() - offset) {
            throw new IndexOutOfBoundsException();
        }
        char[] buffer = new char[a.length()];
        for (int i = offset; i < length; ++i) {
            buffer[i] = a.charAt(i);
        }
        return CharBuffer.wrap(buffer, offset, length);
    }

    public static final CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    CharBuffer(int cap, int lim, int pos, int mark) {
        super(cap, lim, pos, mark);
    }

    public CharBuffer get(char[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public CharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public CharBuffer put(CharBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.length() > 0) {
            char[] toPut = new char[src.length()];
            src.get(toPut);
            src.put(toPut);
        }
        return this;
    }

    public CharBuffer put(char[] src, int offset, int length) {
        if (offset < 0 || offset >= src.length || length < 0 || length >= src.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final char[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object obj) {
        CharBuffer a = (CharBuffer)obj;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = this.get(i1) - a.get(i2);
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public String toString() {
        return new String(this.array(), this.position(), this.length());
    }

    public final int length() {
        return this.remaining();
    }

    public abstract ByteOrder order();

    public abstract CharSequence subSequence(int var1, int var2);

    public CharBuffer put(String str, int start, int length) {
        return this.put(str.toCharArray(), start, length);
    }

    public final CharBuffer put(String str) {
        return this.put(str, 0, str.length());
    }

    public final char charAt(int index) {
        if (index < 0 || index >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + index);
    }
}

