/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;

public final class SocketPermission
extends Permission
implements Serializable {
    static final long serialVersionUID = -7204263841984476862L;
    private transient String hostport;
    private String actions;

    public SocketPermission(String hostport, String actions) {
        super(hostport);
        this.hostport = hostport;
        this.actions = actions;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SocketPermission)) {
            return false;
        }
        return ((SocketPermission)obj).hostport.equals(this.hostport) && ((SocketPermission)obj).actions.equals(this.actions);
    }

    public int hashCode() {
        int hash = 100;
        if (this.hostport != null) {
            hash += this.hostport.hashCode();
        }
        if (this.actions != null) {
            hash += this.actions.hashCode();
        }
        return hash;
    }

    public String getActions() {
        boolean found = false;
        StringBuffer sb = new StringBuffer("");
        if (this.actions.indexOf("connect") != -1) {
            sb.append("connect");
            found = true;
        }
        if (this.actions.indexOf("listen") != -1) {
            if (found) {
                sb.append(",listen");
            } else {
                sb.append("listen");
                found = true;
            }
        }
        if (this.actions.indexOf("accept") != -1) {
            if (found) {
                sb.append(",accept");
            } else {
                sb.append("accept");
                found = true;
            }
        }
        if (found) {
            sb.append(",resolve");
        } else if (this.actions.indexOf("resolve") != -1) {
            sb.append("resolve");
        }
        return sb.toString();
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    public boolean implies(Permission perm) {
        String wild_domain;
        String theircanonical;
        String ourcanonical;
        String ourhost;
        block12: {
            String theirhost;
            String range;
            if (!(perm instanceof SocketPermission)) {
                return false;
            }
            SocketPermission p = (SocketPermission)perm;
            String ourlist = this.getActions();
            String theirlist = p.getActions();
            if (!ourlist.startsWith(theirlist)) {
                return false;
            }
            int ourfirstport = 0;
            int ourlastport = 0;
            int theirfirstport = 0;
            int theirlastport = 0;
            if (this.hostport.indexOf(":") == -1) {
                ourfirstport = 0;
                ourlastport = 65535;
            } else {
                range = this.hostport.substring(this.hostport.indexOf(":") + 1);
                ourfirstport = range.startsWith("-") ? 0 : (range.indexOf("-") == -1 ? Integer.parseInt(range) : Integer.parseInt(range.substring(0, range.indexOf("-"))));
                ourlastport = range.endsWith("-") ? 65535 : (range.indexOf("-") == -1 ? Integer.parseInt(range) : Integer.parseInt(range.substring(range.indexOf("-") + 1, range.length())));
            }
            if (p.hostport.indexOf(":") == -1) {
                theirfirstport = 0;
                ourlastport = 65535;
            } else {
                range = p.hostport.substring(this.hostport.indexOf(":") + 1);
                theirfirstport = range.startsWith("-") ? 0 : (range.indexOf("-") == -1 ? Integer.parseInt(range) : Integer.parseInt(range.substring(0, range.indexOf("-"))));
                theirlastport = range.endsWith("-") ? 65535 : (range.indexOf("-") == -1 ? Integer.parseInt(range) : Integer.parseInt(range.substring(range.indexOf("-") + 1, range.length())));
            }
            if (theirfirstport < ourfirstport || theirlastport > ourlastport) {
                return false;
            }
            ourhost = this.hostport.indexOf(":") == -1 ? this.hostport : this.hostport.substring(0, this.hostport.indexOf(":"));
            if (ourhost.equals(theirhost = p.hostport.indexOf(":") == -1 ? p.hostport : p.hostport.substring(0, p.hostport.indexOf(":")))) {
                return true;
            }
            ourcanonical = null;
            theircanonical = null;
            try {
                ourcanonical = InetAddress.getByName(ourhost).getHostName();
                theircanonical = InetAddress.getByName(theirhost).getHostName();
            }
            catch (UnknownHostException e) {
                if (ourcanonical == null) {
                    ourcanonical = ourhost;
                }
                if (theircanonical != null) break block12;
                theircanonical = theirhost;
            }
        }
        if (ourcanonical.equals(theircanonical)) {
            return true;
        }
        return ourhost.indexOf("*.") != -1 && theircanonical.endsWith(wild_domain = ourhost.substring(ourhost.indexOf("*1")));
    }
}

