/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;

public abstract class Authenticator {
    private static Authenticator default_authenticator;
    private String host;
    private InetAddress addr;
    private int port;
    private String protocol;
    private String prompt;
    private String scheme;

    public static void setDefault(Authenticator def_auth) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new NetPermission("setDefaultAuthenticator"));
        }
        default_authenticator = def_auth;
    }

    public static PasswordAuthentication requestPasswordAuthentication(InetAddress addr, int port, String protocol, String prompt, String scheme) throws SecurityException {
        return Authenticator.requestPasswordAuthentication(null, addr, port, protocol, prompt, scheme);
    }

    public static PasswordAuthentication requestPasswordAuthentication(String host, InetAddress addr, int port, String protocol, String prompt, String scheme) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new NetPermission("requestPasswordAuthentication"));
        }
        if (default_authenticator == null) {
            return null;
        }
        Authenticator.default_authenticator.host = host;
        Authenticator.default_authenticator.addr = addr;
        Authenticator.default_authenticator.port = port;
        Authenticator.default_authenticator.protocol = protocol;
        Authenticator.default_authenticator.prompt = prompt;
        Authenticator.default_authenticator.scheme = scheme;
        return default_authenticator.getPasswordAuthentication();
    }

    protected final String getRequestingHost() {
        return this.host;
    }

    protected final InetAddress getRequestingSite() {
        return this.addr;
    }

    protected final int getRequestingPort() {
        return this.port;
    }

    protected final String getRequestingProtocol() {
        return this.protocol;
    }

    protected final String getRequestingPrompt() {
        return this.prompt;
    }

    protected final String getRequestingScheme() {
        return this.scheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }
}

