/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    public static final DataFlavor plainTextFlavor;
    public static final DataFlavor stringFlavor;
    public static final DataFlavor javaFileListFlavor;
    public static final DataFlavor imageFlavor;
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-object";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private final String mimeType;
    private final Class representationClass;
    private String humanPresentableName;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    protected static final Class tryToLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            if (classLoader != null) {
                return classLoader.loadClass(className);
            }
            throw new ClassNotFoundException(className);
        }
    }

    public DataFlavor() {
        this.mimeType = null;
        this.representationClass = null;
        this.humanPresentableName = null;
    }

    private DataFlavor(Class representationClass, String mimeType, String humanPresentableName) {
        this.representationClass = representationClass;
        this.mimeType = mimeType;
        this.humanPresentableName = humanPresentableName != null ? humanPresentableName : mimeType;
    }

    public DataFlavor(Class representationClass, String humanPresentableName) {
        this(representationClass, "application/x-java-serialized-object; class=" + representationClass.getName(), humanPresentableName);
    }

    public DataFlavor(String mimeType, String humanPresentableName, ClassLoader classLoader) throws ClassNotFoundException {
        this(DataFlavor.getRepresentationClassFromMime(mimeType, classLoader), mimeType, humanPresentableName);
    }

    private static Class getRepresentationClassFromMime(String mimeString, ClassLoader classLoader) {
        String classname = DataFlavor.getParameter("class", mimeString);
        if (classname != null) {
            try {
                return DataFlavor.tryToLoadClass(classname, classLoader);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("classname: " + e.getMessage());
            }
        }
        return DataFlavor.class$("java.io.InputStream");
    }

    public DataFlavor(String mimeType, String humanPresentableName) throws ClassNotFoundException {
        this(mimeType, humanPresentableName, null);
    }

    public DataFlavor(String mimeType) throws ClassNotFoundException {
        this(mimeType, null);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        int idx = this.mimeType.indexOf("/");
        if (idx == -1) {
            return this.mimeType;
        }
        return this.mimeType.substring(0, idx);
    }

    public String getSubType() {
        int idx = this.mimeType.indexOf("/");
        if (idx == -1) {
            return "";
        }
        String subtype = this.mimeType.substring(idx + 1);
        if ((idx = subtype.indexOf(" ")) == -1) {
            return subtype;
        }
        return subtype.substring(0, idx);
    }

    private static String getParameter(String paramName, String mimeString) {
        int idx = mimeString.indexOf(paramName + "=");
        if (idx == -1) {
            return null;
        }
        String value = mimeString.substring(idx + paramName.length() + 2);
        if ((idx = value.indexOf(" ")) == -1) {
            return value;
        }
        return value.substring(0, idx);
    }

    public String getParameter(String paramName) {
        return DataFlavor.getParameter(paramName, this.mimeType);
    }

    public void setHumanPresentableName(String humanPresentableName) {
        this.humanPresentableName = humanPresentableName;
    }

    public final boolean isMimeTypeEqual(String mimeType) {
        return this.mimeType.equals(mimeType);
    }

    public boolean isMimeTypeEqual(DataFlavor flavor) {
        return this.isMimeTypeEqual(flavor.getMimeType());
    }

    public boolean isMimeTypeSerializedObject() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return this.representationClass.getName().equals("java.io.InputStream");
    }

    public boolean isRepresentationClassSerializable() {
        Class[] interfaces = this.representationClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals("java.io.Serializable")) continue;
            return true;
        }
        return false;
    }

    public boolean isRepresentationClassRemote() {
        throw new RuntimeException("Not implemented");
    }

    public boolean isFlavorSerializedObjectType() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.mimeType.startsWith(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        return this.mimeType.equals(DataFlavor.javaFileListFlavor.mimeType) && this.representationClass.equals(DataFlavor.javaFileListFlavor.representationClass);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(DataFlavor flavor) {
        if (flavor == null) {
            return false;
        }
        if (!this.mimeType.toLowerCase().equals(flavor.mimeType.toLowerCase())) {
            return false;
        }
        return this.representationClass.equals(flavor.representationClass);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)obj);
    }

    public boolean equals(String str) {
        return this.isMimeTypeEqual(str);
    }

    public int hashCode() {
        return this.mimeType.toLowerCase().hashCode() ^ this.representationClass.hashCode();
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    protected String normalizeMimeTypeParameter(String name, String value) {
        return name + "=" + value;
    }

    protected String normalizeMimeType(String type) {
        return type;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
    }

    public String toString() {
        return "DataFlavor[representationClass=" + this.representationClass.getName() + ",mimeType=" + this.mimeType + "humanPresentableName=" + this.humanPresentableName;
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public final Class getDefaultRepresentationClass() {
        return DataFlavor.class$("java.io.InputStream");
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] availableFlavors) {
        for (int i = 0; i < availableFlavors.length; ++i) {
            DataFlavor df = availableFlavors[i];
            Class c = df.representationClass;
            if (DataFlavor.class$("java.io.Reader").isAssignableFrom(c) || DataFlavor.class$("java.lang.String").isAssignableFrom(c)) {
                return df;
            }
            if (!DataFlavor.class$("java.io.InputStream").isAssignableFrom(c) || !"text".equals(df.getPrimaryType())) continue;
            String encoding = availableFlavors[i].getParameter("charset");
            if (encoding == null) {
                encoding = "us-ascii";
            }
            InputStreamReader r = null;
            try {
                r = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), encoding);
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            if (r == null) continue;
            return df;
        }
        return null;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException, UnsupportedEncodingException {
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        if (DataFlavor.class$("java.io.Reader").isAssignableFrom(this.representationClass)) {
            return (Reader)transferable.getTransferData(this);
        }
        if (DataFlavor.class$("java.lang.String").isAssignableFrom(this.representationClass)) {
            return new StringReader((String)transferable.getTransferData(this));
        }
        if (DataFlavor.class$("java.io.InputStream").isAssignableFrom(this.representationClass) && "text".equals(this.getPrimaryType())) {
            InputStream in = (InputStream)transferable.getTransferData(this);
            String encoding = this.getParameter("charset");
            if (encoding == null) {
                encoding = "us-ascii";
            }
            return new InputStreamReader(in, encoding);
        }
        throw new UnsupportedFlavorException(this);
    }

    static {
        javaSerializedObjectMimeType = javaSerializedObjectMimeType;
        javaJVMLocalObjectMimeType = javaJVMLocalObjectMimeType;
        javaRemoteObjectMimeType = javaRemoteObjectMimeType;
        plainTextFlavor = new DataFlavor(DataFlavor.class$("java.io.InputStream"), "text/plain; charset=unicode", "plain unicode text");
        stringFlavor = new DataFlavor(DataFlavor.class$("java.lang.String"), "Java Unicode String");
        javaFileListFlavor = new DataFlavor(DataFlavor.class$("java.util.List"), "Java File List");
        imageFlavor = new DataFlavor(DataFlavor.class$("java.awt.Image"), "Java Image");
    }
}

