/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef SPELLDLG_H
#define SPELLDLG_H

#include <kdialogbase.h>


class QRadioButton;
class QCheckBox;

class SpellDlg : public KDialogBase
{
	Q_OBJECT

public:
	SpellDlg(bool haveMarkedText, QWidget* parent, const char *name=0);
	~SpellDlg();
	
	bool all() const;
	bool current() const;
	bool begin() const;
	bool end() const;
	bool marked() const;

private slots:
	void markedChecked(bool);
	
private:
	QRadioButton *allBtn;
	QRadioButton *currentBtn;
	QRadioButton *beginBtn;
	QRadioButton *endBtn;
	QRadioButton *markedBtn;

	QCheckBox *defaultBtn;
};

#endif // SPELLDLG_H
