 













































class QFontPrivate;                                      
class QStringList;

class   QFont
{
public:
    enum StyleHint {
	Helvetica,  SansSerif = Helvetica,
	Times,      Serif = Times,
	Courier,    TypeWriter = Courier,
	OldEnglish, Decorative = OldEnglish,
	System,
	AnyStyle
    };

    enum StyleStrategy {
	PreferDefault = 0x0001,
	PreferBitmap  = 0x0002,
	PreferDevice  = 0x0004,
	PreferOutline = 0x0008,
	ForceOutline  = 0x0010,
	PreferMatch   = 0x0020,
	PreferQuality = 0x0040,
	PreferAntialias = 0x0080,
	NoAntialias = 0x0100
    };

    enum Weight {
	Light    = 25,
	Normal   = 50,
	DemiBold = 63,
	Bold     = 75,
	Black	 = 87
    };

     
    QFont();
     
    QFont( const QString &family, int pointSize = 12, int weight = Normal,
	   bool italic = FALSE );
     
    QFont( const QFont & );

    ~QFont();

    QString family() const;
    void setFamily( const QString &);

    int pointSize() const;
    float pointSizeFloat() const;
    void setPointSize( int );
    void setPointSizeFloat( float );

    int pixelSize() const;
    void setPixelSize( int );
    void setPixelSizeFloat( float );

    int weight() const;
    void setWeight( int );

    bool bold() const;
    void setBold( bool );

    bool italic() const;
    void setItalic( bool );

    bool underline() const;
    void setUnderline( bool );

    bool strikeOut() const;
    void setStrikeOut( bool );

    bool fixedPitch() const;
    void setFixedPitch( bool );

    StyleHint styleHint() const;
    StyleStrategy styleStrategy() const;
    void setStyleHint( StyleHint, StyleStrategy = PreferDefault );
    void setStyleStrategy( StyleStrategy s );

     
    bool rawMode() const;
    void setRawMode( bool );

     
    bool exactMatch() const;

    QFont &operator=( const QFont & );
    bool operator==( const QFont & ) const;
    bool operator!=( const QFont & ) const;
    bool isCopyOf( const QFont & ) const;



    Qt::HANDLE handle() const;



     
    void setRawName( const QString & );
    QString rawName() const;

    QString key() const;


    QString toString() const;
    bool fromString(const QString &);

    static QString substitute(const QString &);
    static QStringList substitutes(const QString &);
    static QStringList substitutions();
    static void insertSubstitution(const QString&, const QString &);
    static void insertSubstitutions(const QString&, const QStringList &);
    static void removeSubstitution(const QString &);

    static void initialize();
    static void cleanup();
    static void cacheStatistics();





    enum Script {
	 
	Latin,
	Greek,
	Cyrillic,
	Armenian,
	Georgian,
	Runic,
	Ogham,
	SpacingModifiers,
	CombiningMarks,

	 
	Hebrew,
	Arabic,
	Syriac,
	Thaana,

	 
	Devanagari,
	Bengali,
	Gurmukhi,
	Gujarati,
	Oriya,
	Tamil,
	Telugu,
	Kannada,
	Malayalam,
	Sinhala,
	Thai,
	Lao,
	Tibetan,
	Myanmar,
	Khmer,

	 
	Han,
	Hiragana,
	Katakana,
	Hangul,
	Bopomofo,
	Yi,

	 
	Ethiopic,
	Cherokee,
	CanadianAboriginal,
	Mongolian,

	 
	CurrencySymbols,
	LetterlikeSymbols,
	NumberForms,
	MathematicalOperators,
	TechnicalSymbols,
	GeometricSymbols,
	MiscellaneousSymbols,
	EnclosedAndSquare,
	Braille,

	Unicode,

	 
	NScripts,
	UnknownScript = NScripts,

	NoScript,

	 
	 
	 

       	 
	HanX11,

	LatinBasic = Latin,              
	LatinExtendedA_2 = HanX11 + 1,   
	LatinExtendedA_3,                
	LatinExtendedA_4,                
	LatinExtendedA_14,               
	LatinExtendedA_15,               

	LastPrivateScript
    };

    QString defaultFamily() const;
    QString lastResortFamily() const;
    QString lastResortFont() const;



    static QFont defaultFont();
    static void setDefaultFont( const QFont & );




protected:
     
    bool dirty() const;
    int deciPointSize() const;


private:
    QFont( QFontPrivate *, bool deep = TRUE );
    QFont( QFontPrivate *, QPaintDevice *pd );

    void detach();







    friend class QFontMetrics;
    friend class QFontInfo;
    friend class QPainter;
    friend class QPSPrinterFont;


    friend   QDataStream &operator<<( QDataStream &, const QFont & );
    friend   QDataStream &operator>>( QDataStream &, QFont & );


    QFontPrivate *d;
};


inline bool QFont::bold() const
{ return weight() > Normal; }


inline void QFont::setBold( bool enable )
{ setWeight( enable ? Bold : Normal ); }




 




  QDataStream &operator<<( QDataStream &, const QFont & );
  QDataStream &operator>>( QDataStream &, QFont & );




