/***************************************************************************
* $Id: Main.java,v 1.2 2002/03/10 16:08:03 rdale Exp $
**
* Ritual main() for Qt applications
**
* Copyright (C) 1996 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;

public class Main {


static DropSite addStuff( QWidget  parent, boolean image )
{
	return addStuff(parent, image, false);
}

static DropSite addStuff( QWidget  parent, boolean image, boolean secret )
{
    QVBoxLayout  tll = new QVBoxLayout( parent, 10 );
    DropSite  d = new DropSite( parent );
    d.setFrameStyle( QFrame.Sunken + QFrame.WinPanel );
    tll.addWidget( d );
    if ( image ) {
	QPixmap stuff = new QPixmap();
	if ( !stuff.load( "trolltech.bmp" ) ) {
	    stuff = new QPixmap(20,20);
	    stuff.fill(Qt.green());
	}
	d.setPixmap( stuff );
    } else {
	d.setText("Drag and Drop");
    }
    d.setFont(new QFont("Helvetica",18));
    if ( secret ) {
	SecretSource s = new SecretSource( (byte) 42, parent );
	tll.addWidget( s );
	d.setSecretSource( s);
    }

    QLabel  format = new QLabel( "\n\n\n\nNone\n\n\n\n", parent );
    tll.addWidget( format );
    tll.activate();
    parent.resize( parent.sizeHint() );

    QObject.connect( d, Qt.SIGNAL("message(String)"),
		      format, Qt.SLOT("setText(String)") );
	return d;
}




public static void main( String[] args )
{
    QApplication a = new QApplication( args );

    QWidget mw = new QWidget();
    DropSite d1 = addStuff( mw, true );
    mw.setCaption( "Qt Example - Drag and Drop" );
    mw.show();

    QWidget mw2 = new QWidget();
    DropSite d2 = addStuff( mw2, false );
    mw2.setCaption( "Qt Example - Drag and Drop" );
    mw2.show();

    QWidget mw3 = new QWidget();
    DropSite d3 = addStuff( mw3, true, true );
    mw3.setCaption( "Qt Example - Drag and Drop" );
    mw3.show();

    QObject.connect(Qt.qApp(),Qt.SIGNAL("lastWindowClosed()"),Qt.qApp(),Qt.SLOT("quit()"));
    a.exec();
	return;
}

static {
	qtjava.initialize();
}

}
