/***************************************************************************
                            KIconLoader.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KICONLOADER_H
#define KICONLOADER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Iconloader for KDE.

 KIconLoader will load the current icon theme and all its base themes.
 Icons will be searched in any of these themes. Additionally, it caches
 icons and applies effects according the the user's preferences.

 In KDE, it is encouraged to load icons by "Group". An icon group is a
 location on the screen where icons are being used. Standard groups are:
 Desktop, Toolbar, MainToolbar, Small and Panel. Each group has some
 centrally configured properties bound to it, including the icon size
 and effects. This makes it possible to offer a consistent icon look in
 all KDE applications.

 The standard groups are defined below.

 The icons are stored on disk in an icon theme or in a standalone
 directory. The icon theme directories contain multiple sizes and/or
 depths for the same icon. The iconloader will load the correct one based
 on the icon group and the current theme. Icon themes are stored globally
 in share/icons, or, application specific in share/apps/$appdir/icons.

 The standalone directories contain just one version of an icon. The
 directories that are searched are: $appdir/pics and $appdir/toolbar.
 Icons in these directories can be loaded by using the special group
 "User".

 
 @short 
 Iconloader for KDE.
*/
@class KIconEffect; 
@class KIconTheme; 
@class KStandardDirs; 
@class QImage; 
@class QPixmap; 
@class parse; 

@class KInstance; 
@class QIconSet; 
@class QMovie; 

@interface  KIconLoader : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Constructs an iconloader.

*/
- initWithText: (NSString *)appname dirs: (KStandardDirs*)dirs;
- init;

/**  Cleanup 
*/
- (void) dealloc;

/** 
 Adds @p appname to the list of application specific directories.

*/
- addAppDir: (NSString *)appname;

/** 
 Loads an icon. It will try very hard to find an icon which is
 suitable. If no exact match is found, a close match is searched.
 If neither an exact nor a close match is found, a null pixmap or
 the "unknown" pixmap is returned, depending on the value of the
 @p canReturnNull parameter.

*/
- (QPixmap*) loadIcon: (NSString *)name group: (int)group size: (int)size state: (int)state path_store: (NSString *)path_store canReturnNull: (BOOL)canReturnNull;
- (QPixmap*) loadIcon: (NSString *)name group: (int)group ;

/** 
 Creates an icon set, that will do on-demand loading of the icon.
 Loading itself is done by calling @ref loadIcon .

*/
- (QIconSet*) loadIconSet: (NSString *)name group: (int)group size: (int)size;
- (QIconSet*) loadIconSet: (NSString *)name group: (int)group ;

/** 
 Returns the path of an icon.

*/
- (NSString *) iconPath: (NSString *)name group_or_size: (int)group_or_size canReturnNull: (BOOL)canReturnNull;

/** 
 Loads an animated icon.

*/
- (QMovie) loadMovie: (NSString *)name group: (int)group size: (int)size;
- (QMovie) loadMovie: (NSString *)name group: (int)group ;

/** 
 Returns the path to an animated icon.

*/
- (NSString *) moviePath: (NSString *)name group: (int)group size: (int)size;

/** 
 Loads an animated icon. In the future, this will be replaced by a
 routine which loads an MNG animation and returns a QMovie.

*/
- (NSArray *) loadAnimated: (NSString *)name group: (int)group size: (int)size;

/** 
 Queries all available icons for a specific group, having a specific
 context.

*/
- (NSArray *) queryIcons: (int)group_or_size context: (int)context;

/** 
 Queries all available icons for a specific context.

*/
- (NSArray *) queryIconsByContext: (int)group_or_size context: (int)context;

/** 

*/
- (int) currentSize: (int)group;

/** 
 Returns a pointer to the current theme. Can be used to query
 available and default sizes for groups.
     
*/
- (KIconTheme*) theme;

/** 
 Returns a pointer to the KIconEffect object used by the icon loader.
     
*/
- (KIconEffect*) iconEffect;

/** 
 Called by -[KInstance newIconLoader]to reconfigure the icon loader
     
*/
- reconfigure: (NSString *)_appname _dirs: (KStandardDirs*)_dirs;

/** 
 Returns if the user wants to use blend the icons with the background
  using the alpha channel information for a given group.
     
*/
- (BOOL) alphaBlending: (int)group;

/** 
 Returns the unknown icon. An icon that is used when no other icon
 can be found.
     
*/
+ (QPixmap*) unknown;

/**  Load a desktop icon.  
*/
+ (QPixmap*) DesktopIcon: (NSString *)name size: (int)size state: (int)state instance: (KInstance*)instance;
+ (QPixmap*) DesktopIcon: (NSString *)name ;

/**  Load a desktop icon. 
*/
+ (QPixmap*) DesktopIcon: (NSString *)name instance: (KInstance*)instance;

/**  Load a desktop icon, and apply the necessary effects to get an IconSet.  
*/
+ (QIconSet*) DesktopIconSet: (NSString *)name size: (int)size instance: (KInstance*)instance;
+ (QIconSet*) DesktopIconSet: (NSString *)name ;

/**  Load a toolbar icon.  
*/
+ (QPixmap*) BarIcon: (NSString *)name size: (int)size state: (int)state instance: (KInstance*)instance;
+ (QPixmap*) BarIcon: (NSString *)name ;

/**  Load a toolbar icon.  
*/
+ (QPixmap*) BarIcon: (NSString *)name instance: (KInstance*)instance;

/**  Load a toolbar icon, and apply the neccesary effects to get an IconSet.  
*/
+ (QIconSet*) BarIconSet: (NSString *)name size: (int)size instance: (KInstance*)instance;
+ (QIconSet*) BarIconSet: (NSString *)name ;

/**  Load a small icon.  
*/
+ (QPixmap*) SmallIcon: (NSString *)name size: (int)size state: (int)state instance: (KInstance*)instance;
+ (QPixmap*) SmallIcon: (NSString *)name ;

/**  Load a small icon.  
*/
+ (QPixmap*) SmallIcon: (NSString *)name instance: (KInstance*)instance;

/**  Load a small icon, and apply the neccesary effects to get an IconSet.  
*/
+ (QIconSet*) SmallIconSet: (NSString *)name size: (int)size instance: (KInstance*)instance;
+ (QIconSet*) SmallIconSet: (NSString *)name ;

/**  Load a main toolbar icon.  
*/
+ (QPixmap*) MainBarIcon: (NSString *)name size: (int)size state: (int)state instance: (KInstance*)instance;
+ (QPixmap*) MainBarIcon: (NSString *)name ;

/**  Load a main toolbar icon.  
*/
+ (QPixmap*) MainBarIcon: (NSString *)name instance: (KInstance*)instance;

/**  Load a main toolbar icon, and apply the effects to get an IconSet.  
*/
+ (QIconSet*) MainBarIconSet: (NSString *)name size: (int)size instance: (KInstance*)instance;
+ (QIconSet*) MainBarIconSet: (NSString *)name ;

/**  Load a user icon. 
*/
+ (QPixmap*) UserIcon: (NSString *)name state: (int)state instance: (KInstance*)instance;
+ (QPixmap*) UserIcon: (NSString *)name ;

/**  Load a user icon. 
*/
+ (QPixmap*) UserIcon: (NSString *)name instance: (KInstance*)instance;

/**  Load a user icon, and apply the effects to get an IconSet.  
*/
+ (QIconSet*) UserIconSet: (NSString *)name instance: (KInstance*)instance;
+ (QIconSet*) UserIconSet: (NSString *)name ;

/**  Returns the current icon size for a specific group.  
*/
+ (int) IconSize: (int)group instance: (KInstance*)instance;
+ (int) IconSize: (int)group ;
@end

#endif
