package org.kde.koala;
import org.kde.qt.*;
import java.util.ArrayList;


/** {@link KDirLister} emits these signals */
public interface KDirListerSignals {

/** 
 Emitted to display information about the speed of the jobs.
   
*/
	void speed( int bytes_per_second );

/** 
 Send a list of items filtered-out by mime-type.
   
*/
	void itemsFilteredByMime( ArrayList items );

/** 
 Signal to empty the directory _url.
 It is only emitted if the lister is holding more than one directory.
   
*/
	void clear( KURL _url );

/** 
 Signal an item to remove.

 ATTENTION: if <code>_fileItem</code> == <code>rootItem</code>() the directory this lister
            is holding was deleted and you HAVE to release especially the
            rootItem of this lister otherwise your app will CRASH!!
            The clear() signals have been emitted already.
   
*/
	void deleteItem( KFileItem _fileItem );

/** 
 Regularly emitted to show the progress of this KDirLister.
   
*/
	void processedSize( int size );

/** 
 Signal a redirection.
   
*/
	void redirection( KURL oldUrl, KURL newUrl );

/** 
 Emitted to display information about running jobs.
 Examples of message are "Resolving host", "Connecting to host...", etc.
   
*/
	void infoMessage( String msg );

/** 
 Signal new items.
   
*/
	void newItems( ArrayList items );
	void destroyed( QObject obj );

/** 
 Signal an item to refresh (its mimetype/icon/name has changed)
 Note: KFileItem.refresh has already been called on those items.
   
*/
	void refreshItems( ArrayList items );

/** 
 Tell the view that the listing of the directory <code>_url</code> was canceled.
 There might be other running jobs left.
 This signal is only emitted if KDirLister is watching more than one directory.

*/
	void canceled( KURL _url );

/** 
 Tell the view that we started to list _url. NOTE: this does _not_ imply that there
 is really a job running! I.e. KDirLister.jobs() may return an empty list. In this case
 the items are taken from the cache.

 The view knows that openURL should start it, so it might seem useless,
 but the view also needs to know when an automatic update happens.
   
*/
	void started( KURL _url );

/** 
 Progress signal showing the overall progress of the KDirLister.
 This allows using a progress bar very easily. (see {@link KProgress})
   
*/
	void percent( int percent );

/** 
 Emitted when we know the size of the jobs.
   
*/
	void totalSize( int size );

/** 
 Tell the view that the listing of the directory <code>_url</code> is finished.
 There might be other running jobs left.
 This signal is only emitted if KDirLister is watching more than one directory.

*/
	void completed( KURL _url );
}

