/*
Copyright (c) 2000 Simon Hausmann <hausmann@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <dcopc/dcopc.h>
#include <dcopc/dcopobject.h>
#include <stdio.h>
#include <glib.h>

#define C( call ) \
    if ( !call ) \
    { \
      fprintf( stderr, "dcop error: %s\n", dcop_client_error_message() ); \
      return 1; \
    }

gboolean dcop_socket_notify( GIOChannel *chan, GIOCondition condition, gpointer data )
{
    DcopClient *client = (DcopClient *)data;
    fprintf( stderr, "dcop_socket_notify\n" );
    dcop_client_process_socket_data( client );
}

gboolean (*old_process_func) ( DcopObject *obj, const gchar *fun, dcop_data *data,
			      gchar **reply_type, dcop_data **reply_data );

gboolean my_obj_process( DcopObject *obj, const gchar *fun, dcop_data *data,
			 gchar **reply_type, dcop_data **reply_data )
{
    if ( strcmp( fun, "doExit()" ) == 0 )
    {
	gtk_main_quit();
	return TRUE;
    }
    if ( strcmp( fun, "mySlot()" ) == 0 )
	{
	    g_message( "mySlot called!" );
	    return TRUE;
	}

    return old_process_func( obj, fun, data, reply_type, reply_data );
}

GList *(*old_functions_func)( DcopObject *obj ) = 0;

GList *my_obj_functions( DcopObject *obj )
{
    GList *res = old_functions_func( obj );
    res = g_list_append( res, g_strdup( "doExit()" ) );
    res = g_list_append( res, g_strdup( "mySlot()" ) );
    return res;
}

GList *(*old_interfaces_func)( DcopObject *obj ) = 0;

GList *my_obj_interfaces( DcopObject *obj )
{
    GList *res = old_interfaces_func( obj );
    res = g_list_append( res, g_strdup( "MyObj" ) );
    return res;
}

int main( int argc, char **argv )
{
  DcopClient *c;
  dcop_data *d;
  dcop_data *reply;
  char *reply_type;
  GIOChannel *chan;
  DcopObject *obj;

  gtk_init( &argc, &argv );

  c = dcop_client_new();

  C( dcop_client_register_as( c, "dcoptest", False ) );

  chan = g_io_channel_unix_new( dcop_client_socket( c ) );
  g_io_channel_ref( chan );

  g_io_add_watch( chan, G_IO_IN, dcop_socket_notify, c );

  obj = dcop_object_new();
  dcop_object_set_id( obj, "myServer" );

  old_process_func = DCOP_OBJECT_CLASS( GTK_OBJECT( obj )->klass )->process;
  old_functions_func = DCOP_OBJECT_CLASS( GTK_OBJECT( obj )->klass )->functions;
  old_interfaces_func = DCOP_OBJECT_CLASS( GTK_OBJECT( obj )->klass )->interfaces;

  DCOP_OBJECT_CLASS( GTK_OBJECT( obj )->klass )->process = my_obj_process;
  DCOP_OBJECT_CLASS( GTK_OBJECT( obj )->klass )->functions = my_obj_functions;
  DCOP_OBJECT_CLASS( GTK_OBJECT( obj )->klass )->interfaces = my_obj_interfaces;

  if ( 	dcop_client_connect_dcop_signal( c, dcop_client_app_id( c ), "myServer",
					 "mySignal()",
					 "myServer", "mySlot()", FALSE ) == FALSE )
      g_message( "error connecting dcop signal :-(" );

  d = dcop_data_ref( dcop_data_new() );

  dcop_client_emit_dcop_signal( c, "myServer", "mySignal()", d );

  dcop_data_deref( d );

  dcop_client_set_daemon_mode( c, TRUE );  

  gtk_main();

  g_io_channel_unref( chan );

  C( dcop_client_detach( c ) );

  gtk_object_unref( GTK_OBJECT( c ) );

  return 0;
}
