/*
 *  Copyright (C) 2003  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_stop_button_h
#define __galeon_stop_button_h

#include "galeon-tbi.h"

/* object forward declarations */

typedef struct _GaleonStopButton GaleonStopButton;
typedef struct _GaleonStopButtonClass GaleonStopButtonClass;
typedef struct _GaleonStopButtonPrivate GaleonStopButtonPrivate;

/**
 * TbiZoom object
 */

#define GALEON_TYPE_STOP_BUTTON				(galeon_stop_button_get_type())
#define GALEON_STOP_BUTTON(object)			(G_TYPE_CHECK_INSTANCE_CAST((object), \
							 GALEON_TYPE_STOP_BUTTON, GaleonStopButton))
#define GALEON_STOP_BUTTON_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), GALEON_TYPE_STOP_BUTTON,\
							 GaleonStopButtonClass))
#define GALEON_IS_STOP_BUTTON(object)			(G_TYPE_CHECK_INSTANCE_TYPE((object), \
							 GALEON_TYPE_STOP_BUTTON))
#define GALEON_IS_STOP_BUTTON_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), GALEON_TYPE_STOP_BUTTON))
#define GALEON_STOP_BUTTON_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GALEON_TYPE_STOP_BUTTON,\
							 GaleonStopButtonClass))

struct _GaleonStopButtonClass 
{
	GaleonTbiClass parent_class;
};

/* Remember: fields are public read-only */
struct _GaleonStopButton
{
	GaleonTbi parent_object;
	GaleonStopButtonPrivate *priv;
};

/* this class is abstract */

GType				galeon_stop_button_get_type		(void);
GaleonStopButton *		galeon_stop_button_new			(void);
void				galeon_stop_button_set_sensitive	(GaleonStopButton *b, gboolean s);

#endif
