/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

	/* ------------------------------------------------------------
 	*      get trx info  
 	*
 	*--------------------------------------------------------------*/

#include "gettxinfo.h"
#include <curses.h>

  int gettxinfo(void)
  {

#ifdef HAVE_LIBHAMLIB
  extern RIG *my_rig;
  extern freq_t rigfreq;
  extern freq_t outfreq;
  extern float freq;
  extern int bandinx;
  extern float bandfrequency[];
#endif

  extern int trx_control;

#ifdef HAVE_LIBHAMLIB           // code for hamlib interface
	int retval;
	int qrg;
	char qrg_string[8];
#endif

  if (trx_control != 1)
  	return(0);

#ifdef HAVE_LIBHAMLIB              // Code for Hamlib interface

 if (outfreq == 0) {

	retval =  rig_get_freq(my_rig, RIG_VFO_CURR, &rigfreq);

    freq = rigfreq/1000.0;
    qrg = rigfreq/1000;

    qrg_string[7] = '\0';

	switch (qrg)
	{
	  case 1800 ... 1900 :{
	  	bandinx = 0;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	  case 3500 ... 4000 :{
	  	bandinx = 1;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	   case 7000 ... 7200 : {
	  	bandinx = 2;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 10100 ... 10150 : {
	  	bandinx = 3;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 14000 ... 14350 : {
	  	bandinx = 4;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 18068 ... 18168 : {
	  	bandinx = 5;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 21000 ... 21450 : {
	  	bandinx = 6;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 24890 ... 24990 : {
	  	bandinx = 7;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 28000 ... 29700 : {
	  	bandinx = 8;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }


	}
   } else if (outfreq == SETCWMODE)  {

		retval =  rig_set_mode(my_rig, RIG_VFO_CURR, RIG_MODE_CW,  RIG_PASSBAND_NORMAL);
			if (retval != RIG_OK)  {
				mvprintw(24,0,"Problem with rig link!\n");
				refresh();
				sleep(1);
			}

		outfreq = 0;


   } else if (outfreq == SETSSBMODE)  {

		if (freq > 13999.9)
			retval =  rig_set_mode(my_rig, RIG_VFO_CURR, RIG_MODE_USB,  RIG_PASSBAND_NORMAL);
		else
			retval =  rig_set_mode(my_rig, RIG_VFO_CURR, RIG_MODE_LSB,  RIG_PASSBAND_NORMAL);

			if (retval != RIG_OK)  {
				mvprintw(24,0,"Problem with rig link!\n");
				refresh();
				sleep(1);
			}

		outfreq = 0;




   }  else if (outfreq == RESETRIT){

		retval =  rig_set_rit(my_rig, RIG_VFO_CURR, 0);

			if (retval != RIG_OK)  {
				mvprintw(24,0,"Problem with rig link!\n");
				refresh();
				sleep(1);
			}

		outfreq = 0;

   } else {

		 retval = rig_set_freq(my_rig, RIG_VFO_CURR, outfreq);

			if (retval != RIG_OK)  {
				mvprintw(24,0,"Problem with rig link!\n");
				refresh();
				sleep(1);
			}

			outfreq = 0;

   }

#endif                // End Hamlib interface

   return(0);
  }

