// Copyright (C) 2002 Neil Stevens <neil@qualityassistant.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kglobal.h>

#include "megamiwindow.h"

void noMessageOutput(QtMsgType, const char *)
{
}

static KCmdLineOptions options[] =
{
#ifdef DEBUG
	{ "qdebug",   I18N_NOOP("Turn on Qt Debug output"), 0 },
#endif
	{ 0, 0, 0}
};

const char *license = "Copyright (C) 2002 Neil Stevens <neil@qualityassistant.com>\n\
\n\
Permission is hereby granted, free of charge, to any person obtaining a copy\n\
of this software and associated documentation files (the ""Software""), to deal\n\
in the Software without restriction, including without limitation the rights\n\
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n\
copies of the Software, and to permit persons to whom the Software is\n\
furnished to do so, subject to the following conditions:\n\
\n\
The above copyright notice and this permission notice shall be included in\n\
all copies or substantial portions of the Software.\n\
\n\
THE SOFTWARE IS PROVIDED ""AS IS"", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n\
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n\
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE\n\
THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN\n\
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\n\
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\
\n\
Except as contained in this notice, the name(s) of the author(s) shall not be\n\
used in advertising or otherwise to promote the sale, use or other dealings\n\
in this Software without prior written authorization from the author(s).";

int main(int argc, char **argv)
{
	// about data
	KAboutData aboutData("megami", I18N_NOOP("Megami"), "1.2",
	                     I18N_NOOP("Popular gambling game"),
	                     KAboutData::License_Custom,
	                     "Copyright (C) 2002 Neil Stevens", 0,
	                     "http://www.freekde.org/neil/megami/");

	aboutData.addAuthor("Neil Stevens", I18N_NOOP("Maintainer"), "neil@qualityassistant.com");
	aboutData.setLicenseText(license);

	// command line
	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);
	KApplication::addCmdLineOptions();

#ifdef DEBUG
	if(!KCmdLineArgs::parsedArgs()->isSet("qdebug"))
		qInstallMsgHandler(noMessageOutput);
#endif

	KApplication app;
	KGlobal::locale()->insertCatalogue("libkdegames");
	app.disableSessionManagement();
	MegamiWindow window;
	app.setMainWidget(&window);
	window.show();
	return app.exec();
}
