namespace Binge.Generators
{
	using System;
	using System.Collections;
	using Binge.Bits;

	public abstract class GlueStick: Binge.Bits.Object
	{
		private string glueLibrary;
		private string targetLibrary;
		private bool usePascalCase;
		private IMangler mangler;

		public string GlueLibrary
		{
			get { return glueLibrary; }
			set { glueLibrary = value; }
		}

		public string TargetLibrary
		{
			get { return targetLibrary; }
			set { targetLibrary = value; }
		}

		public bool UsePascalCase
		{
			get { return usePascalCase; }
			set { usePascalCase = value; }
		}
		
		public IMangler Mangler
		{
			get { return mangler; }
			set { mangler = value; }
		}

		protected GlueStick ()
		{
			glueLibrary = String.Empty;
			targetLibrary = String.Empty;
			usePascalCase = true;
			mangler = null;
		}

		public abstract void Glue (Property prop);
		public abstract void Glue (Constructor ctor);
		public abstract void Glue (Destructor dtor);
		public abstract void Glue (Method method);
	}
}
