/***************************************************************************
                            StatJob.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef STATJOB_H
#define STATJOB_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/SimpleJob.h>

/**
*/
@interface StatJob : SimpleJob 
- initWithURL: (KURL*)url command: (int)command packedArgs: (QByteArray*)packedArgs showProgressInfo: (BOOL)showProgressInfo;

/**  A -stat can have two meanings. Either we want to read from this URL,
 or to check if we can write to it. First case is "source", second is "dest".
 It is necessary to know what the StatJob is for, to tune the kioslave's behaviour
 (e.g. with FTP)
         
*/
- setSide: (BOOL)source;

/** 
 Selects the level of details we want.
 By default this is 2 (all details wanted, including modification time, size, etc.),
 setDetails(1) is used when deleting: we don't need all the information if it takes
 too much time, no need to follow symlinks etc.
 setDetails(0) is used for very simple probing: we'll only get the answer
 "it's a file or a directory, or it doesn't exist". This is used by KRun.
         
*/
- setDetails: (short int)details;

/** 
 Call this in the slot connected to @ref result,
 and only after making sure no error happened.
         
*/
//- (UDSEntry*) statResult;

/** 
 Called by the scheduler when a slave gets to
 work on this job.
         
*/
- start: (Slave*)slave;
//- slotStatEntry: (UDSEntry*)entry;
- slotRedirection: (KURL*)url;
- slotFinished;
@end

/** Override these methods in subclasses of StatJob to customise event handling behaviour */
@protocol StatJobEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
