/***************************************************************************
                            KPropsDlgPlugin.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROPSDLGPLUGIN_H
#define KPROPSDLGPLUGIN_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 A Plugin in the Properties dialog
 This is an abstract class. You must inherit from this class
 to build a new kind of page.
 A plugin in itself is just a library containing code, not a dialog's page.
 It's up to the plugin to insert pages into the parent dialog.

 To make a plugin available, define a service that implements the KPropsDlg/Plugin
 servicetype, as well as the mimetypes for which the plugin should be created.
 For instance, ServiceTypes=KPropsDlg/Plugin,text/html,application/x-mymimetype.

 You can also include X-KDE-Protocol=file if you want that plugin
 to be loaded only for local files, for instance.
 
 @short 
 A Plugin in the Properties dialog
 This is an abstract class.
*/
@class KFileItem; 
@class KPropertiesDialog; 

@interface KPropsDlgPlugin : QObject 

/** 
 Constructor
 To insert tabs into the properties dialog, use the add methods provided by
 KDialogBase (the properties dialog is a KDialogBase).
   
*/
- initWithPropertiesDialog: (KPropertiesDialog*)_props;
- (void) dealloc;

/** 
 Applies all changes to the file.
 This function is called when the user presses 'Ok'. The last plugin inserted
 is called first.
   
*/
- applyChanges;
- setDirty: (BOOL)b;
- (BOOL) isDirty;
- setDirty;

/** 
 Convenience method for -[most supports]methods

*/
+ (BOOL) isDesktopFile: (KFileItem*)_item;
@end

/** Override these methods in subclasses of KPropsDlgPlugin to customise event handling behaviour */
@protocol KPropsDlgPluginEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
