/***************************************************************************
                            KJanusWidget.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KJANUSWIDGET_H
#define KJANUSWIDGET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 Provides a number of ready to use layouts (faces). It is used
 as an internal widget in @ref KDialogBase, but can also used as a
 widget of its own.

 It provides TreeList, IconList, Tabbed, Plain and Swallow layouts.

 The TreeList face provides a list in the left area and pages in the
 right. The area are separated by a movable splitter. The style is somewhat
 similar to the layout in the Control Center. A page is raised by
 selecting the corresponding tree list item.

 The IconList face provides an icon list in the left area and pages in the
 right. For each entry the Icon is on top with the text below. The style
 is somewhat similar to the layout of the Eudora configuation dialog box.
 A page is raised by selecting the corresponding icon list item. The
 preferred icon size is 32x32 pixels.

 The Tabbed face is a common tabbed widget. The procedure for creating a
 page is similar for creating a TreeList. This has the advantage that if
 your widget contain too many pages it is trivial to convert it into a
 TreeList. Just change the face in the KJanusWidget constructor to
 -[KJanusWidget TreeList]and you have a tree list layout instead.

 The Plain face provides an empty widget (QFrame) where you can place your
 widgets. The KJanusWidget makes no assumptions regarding the contents so
 you are free to add whatever you want.

 The Swallow face is provided in order to simplify the usage of existing
 widgets and to allow changing the visible widget. You specify the widget
 to be displayed by @ref  #--setSwallowedWidget. Your widget will be
 reparented inside the widget. You can specify a Null (0) widget. A empty
 space is then displayed.

 For all modes it is important that you specify the @ref -[QWidget minimumSize]
 on the page, plain widget or the swallowed widget. If you use a QLayout
 on the page, plain widget or the swallowed widget this will be taken care
 of automatically. The size is used when the KJanusWidget determines its
 own minimum size. You get the minimum size by using the
 @ref  #--minimumSizeHint or @ref  #--sizeHint methods.

 Pages that have been added in TreeList, IconList or Tabbed mode can be
 removed by simply deleting the page.

 @author Espen Sand (espen@kde.org)
 
 @short Easy to use widget with many layouts.
*/
@class QFrame; 
@class QGrid; 
@class QHBox; 
@class QVBox; 
@class parse; 

@interface KJanusWidget : QWidget 

/** 
 Constructor where you specify the face.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name face: (int)face;
- init;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 Raises the page which was added by @ref -addPage.

*/
- (BOOL) showPage: (int)index;

/** 
 Returns the index of the page that are currently displayed.

*/
- (int) activePageIndex;

/** 
 Use this to verify
 that no memory allocation failed.

*/
- (BOOL) isValid;

/** 
 Returns the face type.

*/
- (int) face;

/** 
 Returns the minimum size that must be made available for the widget
 so that UIs can be displayed properly

*/
- (QSize*) minimumSizeHint;

/** 
 Returns the recommended size for the widget in order to be displayed
 properly.

*/
- (QSize*) sizeHint;

/** 
 Returns the empty widget that is available in Plain mode.

*/
- (QFrame*) plainPage;

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. In most cases you must create a layout
 manager and associate it with this widget as well.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QFrame*) addPage: (NSString *)item header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QFrame*) addPage: (NSString *)item ;

/** 
 This is like addPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.
 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QFrame*) addPageWithStringList: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QFrame*) addPageWithStringList: (NSArray *)items ;

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a @ref QVBox
 so it contains a QVBoxLayout layout that lines up the child widgets
 are vertically.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QVBox*) addVBoxPage: (NSString *)item header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QVBox*) addVBoxPage: (NSString *)item ;

/** 
 This is like addVBoxPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QVBox*) addVBoxPageWithStringList: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QVBox*) addVBoxPageWithStringList: (NSArray *)items ;

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a @ref QHBox
 so it contains a QHBoxLayout layout that lines up the child widgets
 are horizontally.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QHBox*) addHBoxPage: (NSString *)itemName header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QHBox*) addHBoxPage: (NSString *)itemName ;

/** 
 This is like addHBoxPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QHBox*) addHBoxPageWithStringList: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QHBox*) addHBoxPageWithStringList: (NSArray *)items ;

/** 
 Add a new page when the class is used in either TreeList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a @ref QGrid
 so it contains a QGridLayout layout that places up the child widgets
 in a grid.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QGrid*) addGridPage: (int)n dir: (int)dir itemName: (NSString *)itemName header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QGrid*) addGridPage: (int)n dir: (int)dir itemName: (NSString *)itemName ;

/** 
 This is like addGridPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
- (QGrid*) addGridPage: (int)n dir: (int)dir items: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- (QGrid*) addGridPage: (int)n dir: (int)dir items: (NSArray *)items ;

/** 
 Returns the index of a page created with @ref addPage ,
 @ref addVBoxPage , @ref addHBoxPage or @ref addGridPage .
 You can can compare this index with the value returned from
 @ref activePageIndex if you need to do some page specific actions
 in your code.

 The returned index will never change so you can safely use this
 function once and save the value.

*/
- (int) pageIndex: (QWidget *)widget;

/** 
 Defines the widget to be swallowed.

 This method can be used several
 times. Only the latest defined widget will be shown.

*/
- (BOOL) setSwallowedWidget: (QWidget *)widget;

/** 
 This function has only effect in TreeList mode.

 Defines how the tree list is resized when the widget is resized
 horizontally. By default the tree list keeps its width when the
 widget becomes wider.

*/
- setTreeListAutoResize: (BOOL)state;

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the icons given in the @ref addPage,
 @ref addVBoxPage, @ref addHBoxPage, or @ref addGridPage methods should
 be shown in the TreeList.

 Note: This method must be called before calling any of the methods
 which add icons to the page.

*/
- setShowIconsInTreeList: (BOOL)state;

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the root should be decorated.
 For details see @ref -[QListView setRootIsDecorated]
*/
- setRootIsDecorated: (BOOL)state;

/** 
 This function has only effect in IconList mode.

 Defines how the icon list widget is displayed. By default it is
 the widgets in the pages that decide the minimum height
 of the toplevel widget. A vertical scrollbar can be used in
 the icon list area.

*/
- setIconListAllVisible: (BOOL)state;

/** 
 Sets the icon used in TreeList Mode for the given path.

*/
- setFolderIcon: (NSArray *)path pixmap: (QPixmap *)pixmap;

/** 
 Give the keyboard input focus to the widget.
     
*/
- setFocus;

/** 
 This function is used internally when in IconList mode. If you
 reimplement this class a make your own event filter, make sure to
 call this function from your filter.

*/
- (BOOL) eventFilter: (QObject *)o e: (QEvent *)e;
- (BOOL) showPageForWidget: (QWidget *)w;
- addPageWidget: (QFrame*)page items: (NSArray *)items header: (NSString *)header pixmap: (QPixmap *)pixmap;
- InsertTreeListItem: (NSArray *)items pixmap: (QPixmap *)pixmap page: (QFrame*)page;
- (QWidget*) FindParent;
+ (int) TreeList;
+ (int) Tabbed;
+ (int) Plain;
+ (int) Swallow;
+ (int) IconList;
@end

/** Override these methods in subclasses of KJanusWidget to customise event handling behaviour */
@protocol KJanusWidgetEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;

/** 
 Reimplemented to handle the splitter width when the the face
 is TreeList
     
*/
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
