/***************************************************************************
                            KGlobalAccel.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KGLOBALACCEL_H
#define KGLOBALACCEL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

@class KShortcut;
@class KConfigBase;

@interface KGlobalAccel : QObject 
- initWithObject: (QObject *)pParent psName: (NSString *)psName;
- initWithObject: (QObject *)pParent ;
- (void) dealloc;
- (BOOL) isEnabled;
- setEnabled: (BOOL)bEnabled;

/** 
 Create an accelerator action.

 Usage:
<pre>
 insert( "Do Something", i18n("Do Something"),
   i18n("This action allows you to do something really great with this program to "
        "the currently open document."),
   ALT+CTRL+Key_Q, -[KKey QtWIN]+CTRL+Key_Q, this, SLOT(-slotDoSomething) );
</pre>

*/
//- (KAccelAction*) insert: (NSString *)sAction sLabel: (NSString *)sLabel sWhatsThis: (NSString *)sWhatsThis cutDef3: (KShortcut*)cutDef3 cutDef4: (KShortcut*)cutDef4 pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot bConfigurable: (BOOL)bConfigurable bEnabled: (BOOL)bEnabled;
//- (KAccelAction*) insert: (NSString *)sAction sLabel: (NSString *)sLabel sWhatsThis: (NSString *)sWhatsThis cutDef3: (KShortcut*)cutDef3 cutDef4: (KShortcut*)cutDef4 pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot ;

/** 
 Use this to insert a label into the action list.  This will be
 displayed when the user configures shortcuts.
	 
*/
//- (KAccelAction*) insert: (NSString *)sName sLabel: (NSString *)sLabel;
- (BOOL) updateConnections;

/** 
 Set the shortcut to be associated with the action named by @p sAction.
	 
*/
- (KShortcut*) shortcut: (NSString *)sAction;

/** 
 Set the shortcut to be associated with the action named by @p sAction.
	 
*/
- (BOOL) setShortcut: (NSString *)sAction shortcut: (KShortcut*)arg1;

/** 
 Set the slot to be called when the shortcut of the action named
 by @p sAction is pressed.
	 
*/
- (BOOL) setSlot: (NSString *)sAction pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot;

/**  
 Enable or disable the action named by @p sAction.
	 
*/
- (BOOL) setEnabled: (NSString *)sAction bEnabled: (BOOL)bEnabled;
- (NSString *) configGroup;
- setConfigGroup: (NSString *)arg1;

/** 
 Read all shortcuts from @p pConfig, or (if @p pConfig
 is zero) from the application's configuration file
 @ref -[KGlobal config].
	 
*/
- (BOOL) readSettings: (KConfigBase*)pConfig;
- (BOOL) readSettings;

/** 
 Write the current shortcuts to @p pConfig,
 or (if @p pConfig is zero) to the application's
 configuration file.
	 
*/
- (BOOL) writeSettings: (KConfigBase*)pConfig;
- (BOOL) writeSettings;

/** 

 -[KAccelActions useFourModifierKeys].
	 
*/
+ (BOOL) useFourModifierKeys;
- virtual_hook: (int)identifier data: (void*)data;
@end

/** Override these methods in subclasses of KGlobalAccel to customise event handling behaviour */
@protocol KGlobalAccelEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
