/***************************************************************************
                            KColorDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOLORDIALOG_H
#define KCOLORDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 The KColorDialog provides a dialog for color selection.

 In most cases, you will want to use the static method @ref -[KColorDialog getColor].
 This pops up the dialog (with an initial selection provided by you), lets the
 user choose a color, and returns.

 Example:

 <pre>
 	QColor myColor;
 	int result = -[KColorDialog getColor]( myColor );
         if ( result == -[KColorDialog Accepted])
            ...
 </pre>

 The color dialog is really a collection of several widgets which can
 you can also use separately: the quadratic plane in the top left of
 the dialog is a @ref KXYSelector. Right next to it is a @ref KHSSelector
 for chosing hue/saturation.

 On the right side of the dialog you see a @ref KPaletteTable showing
 up to 40 colors with a combo box which offers several predefined
 palettes or a palette configured by the user. The small field showing
 the currently selected color is a @ref KColorPatch.

 @short A color selection dialog.

*/
@interface KColorDialog : KDialogBase 

/** 
 Constructs a color selection dialog.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- init;

/** 
 Destroys the color selection dialog.
     
*/
- (void) dealloc;

/** 
 Returns the currently selected color.

*/
- (QColor*) color;

/** 
 Call this to make the dialog show a "Default Color" checkbox.
 If this checkbox is selected, the dialog will return an "invalid" color (-QColor).
 This can be used to mean "the default text color", for instance,
 the one with the KDE text color on screen, but black when printing.
     
*/
- setDefaultColor: (QColor *)defaultCol;

/** 

*/
- (QColor*) defaultColor;

/** 
 Preselects a color.
     
*/
- setColor: (QColor *)col;

/** 
 Creates a modal color dialog, let the user choose a
 color, and returns when the dialog is closed.

 The selected color is returned in the argument @p theColor.

*/
+ (int) getColor: (QColor *)theColor parent: (QWidget *)parent;
+ (int) getColor: (QColor *)theColor ;

/** 
 Creates a modal color dialog, lets the user choose a
 color, and returns when the dialog is closed.

 The selected color is returned in the argument @p theColor.

 This version takes a @p defaultColor argument, which sets the color
 selected by the "default color" checkbox. When this checkbox is checked,
 the invalid color (-QColor) is returned into @p theColor.

*/
+ (int) getColor: (QColor *)theColor defaultColor: (QColor *)defaultColor parent: (QWidget *)parent;
+ (int) getColor: (QColor *)theColor defaultColor: (QColor *)defaultColor ;

/** 
 Gets the color from the pixel at point p on the screen.
     
*/
+ (QColor*) grabColor: (QPoint*)p;
@end

/** Override these methods in subclasses of KColorDialog to customise event handling behaviour */
@protocol KColorDialogEventHandling

/** 

    
*/
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;

/** 

    
*/
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
