/***************************************************************************
                            AlsaOut.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef ALSAOUT_H
#define ALSAOUT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/MidiOut.h>

/**


 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to a MIDI devices using ALSA.
*/
@interface AlsaOut : MidiOut 

/** 
 Constructor. After constructing a MidiOut device, you must open it
 (using @ref  #--openDev ). Additionally you may want to initialize it
 (with @ref  #--initDev ),
   
*/
- initWithInt: (int)d client: (int)client port: (int)port cname: (NSString *)cname pname: (NSString *)pname;
- initWithInt: (int)d ;

/** 
 Destructor. It doesn't matter if you close the device (@ref -closeDev )
 before you destruct the object because in other case, it will be closed
 here.
   
*/
- (void) dealloc;

/** 
 Opens the device. This is generally called from @ref DeviceManager , so you
 shouldn't call this yourself (except if you created the MidiOut object
 yourself.

*/
- openDev: (int)sqfd;

/** 
 Closes the device. It basically tells the device (the file descriptor)
 is going to be closed.

*/
- closeDev;

/** 
 Initializes the device sending generic standard midi events and controllers,
 such as changing the patches of each channel to an Acoustic Piano (000),
 setting the volume to a normal value, etc.
   
*/
- initDev;

/** 

 which are defined in midispec.h

*/
- (int) deviceType;

/** 
 Returns the name and type of this MIDI device.

*/
- (NSString *) deviceName;

/** 

   
*/
- (int) rate;

/** 
 See @ref -[DeviceManager noteOn]
   
*/
- noteOn: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[DeviceManager noteOff]
   
*/
- noteOff: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[DeviceManager keyPressure]
   
*/
- keyPressure: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[DeviceManager chnPatchChange]
   
*/
- chnPatchChange: (unsigned char)chn patch: (unsigned char)patch;

/** 
 See @ref -[DeviceManager chnPressure]
   
*/
- chnPressure: (unsigned char)chn vel: (unsigned char)vel;

/** 
 See @ref -[DeviceManager chnPitchBender]
   
*/
- chnPitchBender: (unsigned char)chn lsb: (unsigned char)lsb msb: (unsigned char)msb;

/** 
 See @ref -[DeviceManager chnController]
   
*/
- chnController: (unsigned char)chn ctl: (unsigned char)ctl v: (unsigned char)v;

/** 
 See @ref -[DeviceManager sysex]
   
*/
- sysex: (unsigned char*)data size: (unsigned long)size;

/** 
 Mutes all notes being played on a given channel.
   
*/
- channelSilence: (unsigned char)chn;

/** 
 Mute or "unmute" a given channel .

*/
- channelMute: (unsigned char)chn a: (int)a;

/** 
 Change all channel volume events multiplying it by this percentage correction
 Instead of forcing a channel to a fixed volume, this method allows to
 music to fade out even when it was being played softly.

*/
- setVolumePercentage: (int)volper;

/** 
 Returns true if everything's ok and false if there has been any problem
   
*/
- (int) ok;
- wait: (double)ticks;
- tmrSetTempo: (int)v;
- tmrStart: (int)tpcn;
- tmrStart;
- tmrStop;
- tmrContinue;

/** 

 If i==1 syncronizes by cleaning the buffer instead of sending it (in fact,
 this is what syncronizing really means :-) )
   
*/
- sync: (int)i;
- sync;
- seqbuf_dump;
- seqbuf_clean;
//- eventInit: (int*)ev;
//- eventSend: (int*)ep;
//- timerEventSend: (int)type;
@end

#endif
