/***************************************************************************
                            KDialogBase.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provides basic functionality needed by nearly all dialogs.

 It offers the standard action buttons you'd expect to find in a
 dialog as well as the capability to define at most three configurable
 buttons. You can define a main widget that contains your specific
 dialog layout or you can use a predefined layout. Currently, <code>TreeList</code>/Paged, <code>Tabbed</code>, <code>Plain</code>, <code>Swallow</code> and <code>IconList</code>
 mode layouts (faces) are available.

 The class takes care of the geometry management. You only need to define
 a minimum size for the widget you want to use as the main widget.

 You can set a background tile (pixmap) for parts of the dialog. The
 tile you select is shared by all instances of this class in your
 application so that they all get the same look and feel.

 There is a tutorial available on http://developer.kde.org/ (NOT YET)
 that contains
 copy/paste examples as well a screenshots on how to use this class.

 You select which buttons should be displayed, but you do not choose the
 order in which they are displayed. This ensures a standard interface in
 KDE. The button order can be changed, but this ability is only available
 for a central KDE control tool. The following buttons are available:
 OK, Cancel/Close, Apply/Try, Default, Help and three user definable
 buttons: User1, User1 and User3. You must specify the text of the UserN
 buttons. Each button has a virtual slot so you can overload the method
 when required. The default slots emit a signal as well, so you can choose
 to connect a signal instead of overriding the slot.
 The default implementation of {@link #slotHelp} will automatically enable
 the help system if you have provided a path to the help text.
 {@link #slotCancel} and {@link #slotClose} will run {@link QDialog#reject}
 while {@link #slotOk} will run {@link QDialog#accept}. You define a default
 button in the constructor.

 If you don't want any buttons at all because your dialog is special
 in some way, then set the buttonMask argument in the constructor to zero
 (0). The optional button box separator line should not be enabled
 in this case. Note that the KDialogBase will animate a button press
 when the user press Escape. The button that is enabled is either Cancel,
 Close or the button that is defined by {@link #setEscapeButton} The
 animation will not take place when the buttonMask is zero. Your
 custom dialog code should reimplement the {@link keyPressEvent} and
 animate the cancel button so that the dialog behaves like regular
 dialogs. NOTE: None of the regular slots (like {@link #slotOk} ) or
 signals that are related to the standard action buttons will be used
 when you don't use these buttons.

 You can either use one of the prebuilt, easy to use, faces or
 define your own main widget. The dialog provides ready to use
 TreeList, Tabbed, Plain, Swallow and IconList faces. KDialogBase uses
 the {@link KJanusWidget} class internally to accomplish this. If you
 use TreeList, Tabbed or IconList mode, then add pages with {@link #addPage}.

 Pages that have been added can be removed again by simply deleting
 the page.

 If you want complete control of how the dialog contents should look,
 then you can define a main widget by using {@link #setMainWidget}. You
 only need to set the minimum size of that widget and the dialog will
 resize itself to fit this minimum size.  The dialog is resizeable, but
 cannot be made smaller than its minimum size.

 The dialog consists of a help area on top (becomes visible if you define
 a help path and use {@link #enableLinkedHelp}), the main area which is
 the built-in dialog face or your own widget in the middle and by default
 a button box at the bottom. The button box can also be placed at the
 right edge (to the right of the main widget). Use
 {@link #setButtonBoxOrientation} to control this behavior. A separator
 can be placed above the button box (or to the left when the button box
 is at the right edge). Normally you specify that you want a separator
 in the constructor, but you can use {@link #enableButtonSeparator} as well.

 The class is derived from {@link KDialog}, so you get automatic access to
 the {@link KDialog#marginHint}, {@link KDialog#spacingHint} and the
 extended {@link KDialog#setCaption} method. NOTE: The main widget you
 use will be positioned inside the dialog using a margin (or border)
 equal to {@link KDialog#marginHint}. You shall not add a margin yourself.
 The example below (from kedit) shows how you use the top level widget
 and its layout. The second argument (the border) to {@link QVBoxLayout}
 is 0. This situation is valid for {@link addPage} , {@link addVBoxPage} ,
 {@link addHBoxPage} , {@link addGridPage} , {@link makeMainWidget} ,
 {@link makeVBoxMainWidget} , {@link makeHBoxMainWidget} and
 {@link makeGridMainWidget} as well.

 Example:

 <pre>
 UrlDlg.UrlDlg( QWidget parent, String caption,
                 String urltext)
   : KDialogBase( parent, "urldialog", true, caption,
		    KDialogBase.Ok|KDialogBase.Cancel, KDialogBase.Ok, true )
 {
   QWidget page = new QWidget( this );
   setMainWidget(page);
   QVBoxLayout topLayout = new QVBoxLayout( page, 0, spacingHint() );

   QLabel label = new QLabel( caption, page, "caption" );
   topLayout.addWidget( label );

   lineedit = new QLineEdit( urltext, page, "lineedit" );
   lineedit.setMinimumWidth(fontMetrics().maxWidth()20);
   topLayout.addWidget( lineedit );

   topLayout.addStretch(10);
 }
 </pre>

 If you use {@link #makeVBoxMainWidget}, then the dialog above can be made
 simpler but you lose the ability to add a stretchable area:

 <pre>
 UrlDlg.UrlDlg( QWidget parent, String caption,
		String urltext)
 : KDialogBase( parent, "urldialog", true, caption,
		  KDialogBase.Ok|KDialogBase.Cancel, KDialogBase.Ok, true )
 {
   QVBox page = makeVBoxMainWidget();
   QLabel label = new QLabel( caption, page, "caption" );

   lineedit = new QLineEdit( urltext, page, "lineedit" );
   lineedit.setMinimumWidth(fontMetrics().maxWidth()20);
 }
 </pre>

 This class can be used in many ways. Note that most KDE ui widgets
 and many of KDE core applications use the KDialogBase so for more
 inspiration you should study the code for these.

 See {@link KDialogBaseSignals} for signals emitted by KDialogBase.

 

 @author Mirko Boehm (mirko@kde.org) and Espen Sand (espen@kde.org)
 
 @short A dialog base class with standard buttons and predefined layouts.

*/
public class KDialogBase extends KDialog  {
	protected KDialogBase(Class dummy){super((Class) null);}

	private native void newKDialogBase( QWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3);

/** 
 Constructor for the standard mode where you must specify the main
 widget with {@link #setMainWidget} .

*/
	public KDialogBase( QWidget parent, String name, boolean modal, String caption, int buttonMask, int defaultButton, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3) {
		super((Class) null);
		newKDialogBase( parent, name, modal, caption, buttonMask, defaultButton, separator, user1, user2, user3);
	}
	public KDialogBase( QWidget parent, String name, boolean modal, String caption, int buttonMask) {
		this( parent, name, modal, caption, buttonMask, Ok, false, null, null, null);
	}
	public KDialogBase( QWidget parent, String name, boolean modal, String caption) {
		this( parent, name, modal, caption, Ok|Apply|Cancel, Ok, false, null, null, null);
	}
	public KDialogBase( QWidget parent, String name, boolean modal) {
		this( parent, name, modal, null, Ok|Apply|Cancel, Ok, false, null, null, null);
	}
	private native void newKDialogBase();
	public KDialogBase() {
		super((Class) null);
		newKDialogBase();
	}
	private native void newKDialogBase( int dialogFace, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3);

/** 
 Constructor for the predefined layout mode where you specify the
 kind of layout (face).

*/
	public KDialogBase( int dialogFace, String caption, int buttonMask, int defaultButton, QWidget parent, String name, boolean modal, boolean separator, KGuiItem user1, KGuiItem user2, KGuiItem user3) {
		super((Class) null);
		newKDialogBase( dialogFace, caption, buttonMask, defaultButton, parent, name, modal, separator, user1, user2, user3);
	}
	private native void newKDialogBase( int dialogFace, String caption, int buttonMask, int defaultButton);
	public KDialogBase( int dialogFace, String caption, int buttonMask, int defaultButton) {
		super((Class) null);
		newKDialogBase( dialogFace, caption, buttonMask, defaultButton);
	}
	private native void newKDialogBase( String caption, int buttonMask, int defaultButton, int escapeButton, QWidget parent, String name, boolean modal, boolean separator, KGuiItem yes, KGuiItem no, KGuiItem cancel);

/** 
 Constructor for a message box mode where the <code>buttonMask</code> can only
 contain Yes, No, or Cancel.

 If you need other names you can rename
 the buttons with {@link #setButtonText}. The dialog box is not resizable
 by default but this can be changed by {@link #setInitialSize}. If you
 select 'modal' to be true, the dialog will return Yes, No, or Cancel
 when closed otherwise you can use the signals {@link #yesClicked},
 {@link #noClicked}, or {@link #cancelClicked} to determine the state.

*/
	public KDialogBase( String caption, int buttonMask, int defaultButton, int escapeButton, QWidget parent, String name, boolean modal, boolean separator, KGuiItem yes, KGuiItem no, KGuiItem cancel) {
		super((Class) null);
		newKDialogBase( caption, buttonMask, defaultButton, escapeButton, parent, name, modal, separator, yes, no, cancel);
	}
	private native void newKDialogBase( String caption);
	public KDialogBase( String caption) {
		super((Class) null);
		newKDialogBase( caption);
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the orientation of the button box.

 It can be <code>Vertical</code> or <code>Horizontal.</code> If <code>Horizontal</code>
 (default), the button box is positioned at the bottom of the
 dialog. If <code>Vertical</code> it will be placed at the right edge of the
 dialog.

*/
	public native void setButtonBoxOrientation( int orientation);

/** 
 Sets the button that will be activated when the Escape key
 is pressed.

 Normally you should not use this function. By default,
 the Escape key is mapped to either the Cancel or the Close button
 if one of these buttons are defined. The user expects that Escape will
 cancel an operation so use this function with caution.

*/
	public native void setEscapeButton( int identifier);

/** 
 Adjust the size of the dialog to fit the contents just before
 {@link QDialog#exec} or {@link QDialog#show} is called.

 This method will not be called if the dialog has been explicitly
 resized before showing it.

*/
	public native void adjustSize();
	public native QSize sizeHint();
	public native QSize minimumSizeHint();

/** 
 Retrieve the empty page when the predefined layout is used in <code>Plain</code>
 mode.

 This widget must used as the toplevel widget of your dialog
 code.

*/
	public native QFrame plainPage();

/** 
 Add a page to the dialog when the class is used in <code>TreeList</code> ,
 <code>IconList</code> or <code>Tabbed</code> mode.

 The returned widget must be used as the
 toplevel widget for this particular page.
 Note: The returned frame widget has no
 layout manager associated with it. In order to use it you must
 create a layout yourself as the example below illustrates:

 <pre>
 QFrame page = addPage( i18n("Layout") );
 QVBoxLayout topLayout = new QVBoxLayout( page, 0, 6 );
 QLabel label = new QLabel( i18n("Layout type"), page );
 topLayout.addWidget( label );
 ..
 </pre>

*/
	public native QFrame addPage( String itemName, String header, QPixmap pixmap);
	public native QFrame addPage( String itemName);

/** 
 This is like {@link #addPage} just above, with the difference that the first
 element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the <code>TreeList</code> face. Later this may
 be added for the <code>IconList</code> face too. In other faces than the
 <code>TreeList</code>, all the strings except the last one is ignored.

*/
	public native QFrame addPage( String[] items, String header, QPixmap pixmap);
	public native QFrame addPage( String[] items);

/** 
 Add a page to the dialog when the class is used in <code>TreeList</code>,
 <code>IconList</code> or <code>Tabbed</code> mode.

 The returned widget must be used as the toplevel widget for
 this particular page. The widget contains a {@link QVBoxLayout}
 layout so the widget children are lined up vertically.  You can
 use it as follows:

 <pre>
 QVBox page = addVBoxPage( i18n("Layout") );
 QLabel label = new QLabel( i18n("Layout type"), page );
 ..
 </pre>

*/
	public native QVBox addVBoxPage( String itemName, String header, QPixmap pixmap);
	public native QVBox addVBoxPage( String itemName);

/** 
 This is like {@link #addVBoxPage} just above, with the difference
 that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the <code>TreeList</code> face. Later this may
 be added for the <code>IconList</code> face too. In other faces than the
 <code>TreeList</code>, all the strings except the last one is ignored.

*/
	public native QVBox addVBoxPage( String[] items, String header, QPixmap pixmap);
	public native QVBox addVBoxPage( String[] items);

/** 
 Add a page to the dialog when the class is used in <code>TreeList</code>,
 <code>IconList</code> or <code>Tabbed</code> mode.

 The returned widget must be used as the
 toplevel widget for this particular page. The widget contains a
 {@link QHBoxLayout} layout so the widget children are lined up horizontally.
 You can use it as follows:

*/
	public native QHBox addHBoxPage( String itemName, String header, QPixmap pixmap);
	public native QHBox addHBoxPage( String itemName);

/** 
 This is like {@link #addHBoxPage} just above, with the
 difference that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the <code>TreeList</code> face. Later this may
 be added for the <code>IconList</code> face too. In other faces than the
 <code>TreeList</code>, all the strings except the last one is ignored.

*/
	public native QHBox addHBoxPage( String[] items, String header, QPixmap pixmap);
	public native QHBox addHBoxPage( String[] items);

/** 
 Add a page to the dialog when the class is used in <code>TreeList</code>,
 <code>IconList</code> or <code>Tabbed</code> mode.

 The returned widget must be used as the
 toplevel widget for this particular page. The widget contains a
 {@link QGridLayout} layout so the widget children are  positioned in a grid.

*/
	public native QGrid addGridPage( int n, int dir, String itemName, String header, QPixmap pixmap);
	public native QGrid addGridPage( int n, int dir, String itemName);

/** 
 This is like {@link #addGridPage} just above, with the difference
 that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the <code>TreeList</code> face. Later this may
 be added for the <code>IconList</code> face too. In other faces than the
 <code>TreeList</code>, all the strings except the last one is ignored.

*/
	public native QGrid addGridPage( int n, int dir, String[] items, String header, QPixmap pixmap);
	public native QGrid addGridPage( int n, int dir, String[] items);

/** 
 Sets the icon used in <code>TreeList</code> Mode for the given path.

*/
	public native void setFolderIcon( String[] path, QPixmap pixmap);

/** 
 Make a main widget.

 The function will make a {@link QFrame} widget
 and use {@link #setMainWidget} to register it. You can <em>not</em> use this
 function more than once, <em>not</em> if you have already defined a
 main widget with {@link #setMainWidget} and <em>not</em> if you have used the
 constructor where you define the face (<code>Plain</code>, <code>Swallow</code>, <code>Tabbed</code>,
 <code>TreeList</code>).

*/
	public native QFrame makeMainWidget();

/** 
 Make a main widget.

 The function will make a {@link QVBox} widget
 and use {@link #setMainWidget} to register it. You <em>can</em> use this
 function more than once, <em>not</em> if you have already defined a
 main widget with {@link #setMainWidget} and <em>not</em> if you have used the
 constructor where you define the face (<code>Plain</code>, <code>Swallow</code>, <code>Tabbed</code>,
 <code>TreeList</code>, <code>IconList</code>).

*/
	public native QVBox makeVBoxMainWidget();

/** 
 Make a main widget.

 The function will make a {@link QHBox} widget
 and use {@link #setMainWidget} to register it. You can <em>not</em> use this
 function more than once, <em>not</em> if you have already defined a
 main widget with {@link #setMainWidget} and <code>not</code> if you have used the
 constructor where you define the face (<code>Plain</code>, <code>Swallow</code>, <code>Tabbed</code>,
 <code>TreeList</code>, <code>IconList</code>).

*/
	public native QHBox makeHBoxMainWidget();

/** 
 Make a main widget.

 The function will make a {@link QGrid} widget
 and use {@link #setMainWidget} to register it. You can <em>not</em> use this
 function more than once, <em>not</em> if you have already defined a
 main widget with {@link #setMainWidget} and <em>not</em> if you have used the
 constructor where you define the face (Plain, Swallow, Tabbed,
 TreeList, IconList).

*/
	public native QGrid makeGridMainWidget( int n, int dir);

/** 
 Hide or display the a separator line drawn between the action
 buttons an the main widget.
     
*/
	public native void enableButtonSeparator( boolean state);

/** 
 Hide or display a general action button.

  Only buttons that have
 been created in the constructor can be displayed. This method will
 not create a new button.

*/
	public native void showButton( int identifier, boolean state);

/** 
 Hide or display the OK button.

  The OK button must have
 been created in the constructor to be displayed.

*/
	public native void showButtonOK( boolean state);

/** 
 Hide or display the Apply button.

  The Apply button must have
 been created in the constructor to be displayed.

*/
	public native void showButtonApply( boolean state);

/** 
 Hide or display the Cancel button. The Cancel button must have
 been created in the constructor to be displayed.

*/
	public native void showButtonCancel( boolean state);

/** 
 Sets the page with <code>index</code> to be displayed.

 This method will only
 work when the dialog is using the predefined shape of TreeList,
 IconList or Tabbed.

*/
	public native boolean showPage( int index);

/** 
 Returns the index of the active page.

 This method will only work when the dialog is using the
 predefined shape of Tabbed, TreeList or IconList.

*/
	public native int activePageIndex();

/** 
 Returns the index of a page created with {@link #addPage},
 {@link #addVBoxPage}, {@link #addHBoxPage} or {@link #addGridPage}.
 You can can compare this index with the value returned from
 {@link #activePageIndex} if you need to do some page specific actions
 in your code.

 The returned index will never change so you can safely use this
 function once and save the value.

*/
	public native int pageIndex( QWidget widget);

/** 
 Sets the main user definable widget.

 If the dialog is using the predefined Swallow mode, the widget will
 be reparented to the internal swallow control widget. If the dialog
 is being used in the standard mode then the <code>widget</code> must have the
 dialog as parent.

*/
	public native void setMainWidget( QWidget widget);

/** 
 Returns the main widget if any.

*/
	public native QWidget mainWidget();

/** 
 Convenience method.

  Freezes the dialog size using the minimum size
 of the dialog. This method should only be called right before
 {@link #show} or {@link #exec}.
     
*/
	public native void disableResize();

/** 
 Convenience method. Sets the initial dialog size.

  This method should
 only be called right before {@link #show} or {@link #exec}. The initial
 size will be
 ignored if smaller than the dialog's minimum size.

*/
	public native void setInitialSize( QSize s, boolean noResize);
	public native void setInitialSize( QSize s);

/** 
 Convenience method. Add a size to the default minimum size of a
 dialog.

 This method should only be called right before {@link #show} or
 {@link #exec}.

*/
	public native void incInitialSize( QSize s, boolean noResize);
	public native void incInitialSize( QSize s);

/** 
 read the dialogs size from the configuration according to the screen size.
 If no size is saved for one dimension of the screen, a default size
 is choosed. The default width is 50 percent of the screen width, the
 default height is 40 percent of the screen height.

*/
	public native QSize configDialogSize( String groupName);

/** 
 save the dialogs size dependant on the screen dimension either to the
 global or application config file.

*/
	public native void saveDialogSize( String groupName, boolean global);
	public native void saveDialogSize( String groupName);

/** 
 Sets the text of the OK button.

 If the default parameters are used
 (that is, if no parameters are given) the standard texts are set:
 The button shows "OK", the tooltip contains "Accept settings."
 (internationalized) and the quickhelp text explains the standard
 behavior of the OK button in settings dialogs.

*/
	public native void setButtonOKText( String text, String tooltip, String quickhelp);
	public native void setButtonOKText();

/** 
 Sets the text of the Apply button.

 If the default parameters are
 used (that is, if no parameters are given) the standard texts are set:
 The button shows "Apply", the tooltip contains "Apply settings."
 (internationalized) and the quickhelp text explains the standard
 behavior of the apply button in settings dialogs.

*/
	public native void setButtonApplyText( String text, String tooltip, String quickhelp);
	public native void setButtonApplyText();

/** 
 Sets the text of the Cancel button.

  If the default parameters are
 used (that is, if no parameters are given) the standard texts are set:
 The button shows "Cancel", everything else will not be set.

*/
	public native void setButtonCancelText( String text, String tooltip, String quickhelp);
	public native void setButtonCancelText();

/** 
 Sets the text of any button.

*/
	public native void setButtonText( int identifier, String text);

/** 
 Sets the tooltip text of any button.

*/
	public native void setButtonTip( int identifier, String text);

/** 
 Sets the "What's this?" text of any button.

*/
	public native void setButtonWhatsThis( int identifier, String text);

/** 
 This function has only effect in TreeList mode.

 Defines how the tree list widget is resized when the dialog is
 resized horizontally. By default the tree list keeps its width
 when the dialog becomes wider.

*/
	public native void setTreeListAutoResize( boolean state);

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the icons given in the {@link addPage},
 {@link addVBoxPage}, {@link addHBoxPage}, or {@link addGridPage} methods should
 be shown in the TreeList.

 Note: This method must be called before calling any of the methods
 which add icons to the page.

*/
	public native void setShowIconsInTreeList( boolean state);

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the root should be decorated.
 For details see {@link QListView#setRootIsDecorated}

*/
	public native void setRootIsDecorated( boolean state);

/** 
 This function has only effect in IconList mode.

 Defines how the icon list widget is displayed. By default it is
 the widgets in the dialog pages that decide the minimum height
 of the dialog. A vertical scrollbar can be used in the icon list
 area.

*/
	public native void setIconListAllVisible( boolean state);

/** 
 Enable hiding of the background tile (if any).

*/
	public native void showTile( boolean state);

/** 

 Do not use this method. It is included for compatibility reasons.

 This method returns the border widths in all directions the dialog
 needs for itself. Respect this, or get bad looking results.
 The references are upper left x (<code>ulx</code>), upper left y (<code>uly</code>),
 lower right x (<code>lrx</code>), and lower left y (<code>lly</code>).
 The results are differences in pixels from the
 dialogs corners.
     
*/
	public native void getBorderWidths( int ulx, int uly, int lrx, int lry);

/** 

 Do not use this method. It is included for compatibility reasons.

 This method returns the contents rectangle of the work area. Place
 your widgets inside this rectangle, and use it to set up
 their geometry. Be careful: The rectangle is only valid after
 resizing the dialog, as it is a result of the resizing process.
 If you need the "overhead" the dialog needs for its elements,
 use {@link #getBorderWidths}.
     
*/
	public native QRect getContentsRect();

/** 
 Calculate the size hint for the dialog.

 With this method it is easy to calculate a size hint for a
 dialog derived from KDialogBase if you know the width and height of
 the elements you add to the widget. The rectangle returned is
 calculated so that all elements exactly fit into it. Thus, you may
 set it as a minimum size for the resulting dialog.

 You should not need to use this method and never if you use one of
 the predefined shapes.

*/
	public native QSize calculateSize( int w, int h);

/** 
 Returns the help link text.

  If no text has been defined,
 "Get help..." (internationalized) is returned.

*/
	public native String helpLinkText();

/** 
 Returns the action button that corresponds to the <code>id.</code>

 Normally
 you should not use this function. <em>Never</em> delete the object returned
 by this function. See also {@link #enableButton}, {@link #showButton},
 {@link #setButtonTip}, {@link #setButtonWhatsThis}, and {@link #setButtonText}.

     
*/
	public native QPushButton actionButton( int identifier);

/** 
 Enable or disable (gray out) a general action button.

*/
	public native void enableButton( int identifier, boolean state);

/** 
 Enable or disable (gray out) the OK button.

*/
	public native void enableButtonOK( boolean state);

/** 
 Enable or disable (gray out) the Apply button.

*/
	public native void enableButtonApply( boolean state);

/** 
 Enable or disable (gray out) the Cancel button.

*/
	public native void enableButtonCancel( boolean state);

/** 
 Display or hide the help link area on the top of the dialog.

*/
	public native void enableLinkedHelp( boolean state);

/** 
 Destruct the Dialog delayed.

 You can call this function from
 slots like {@link #closeClicked} and {@link #hidden}.
 You should not use the dialog any more after
 calling this function.

*/
	public native void delayedDestruct();

/** 
 Sets the text that is shown as the linked text.

 If text is empty,
 the text "Get help..." (internationalized) is used instead.

*/
	public native void setHelpLinkText( String text);

/** 
 Sets the help path and topic.

*/
	public native void setHelp( String anchor, String appname);
	public native void setHelp( String anchor);

/** 
 Connected to help link label.
     
*/
	public native void helpClickedSlot( String arg1);

/** 
 Sets the status of the Details button.
     
*/
	public native void setDetails( boolean showDetails);

/** 
 Sets the widget that gets shown when "Details" is enabled.

 The dialog takes over ownership of the widget.
 Any previously set widget gets deleted.
     
*/
	public native void setDetailsWidget( QWidget detailsWidget);

/** 
 This method is called automatically whenever the background has
 changed. You do not need to use this method.
     
*/
	public native void updateBackground();

/** 
 Force closing the dialog, setting its result code to the one Esc would set.
 You shouldn't use this, generally (let the user make his choice!)
 but it can be useful when you need to make a choice after a timeout
 has happened, or when the parent widget has to go somewhere else
 (e.g. html redirections).

*/
	public native void cancel();

/** 
 Check whether the background tile is set or not.

*/
	public static native boolean haveBackgroundTile();

/** 
 Returns a pointer to the background tile if there is one.

*/
	public static native QPixmap backgroundTile();

/** 

 Use {@link #backgroundTile} instead.
     
*/
	public static native QPixmap getBackgroundTile();

/** 
 Sets the background tile.

  If it is Null (0), the background image is deleted.

*/
	public static native void setBackgroundTile( QPixmap pix);

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	protected native void keyPressEvent( QKeyEvent e);

/** 
 Emits the #hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	protected native void hideEvent( QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior
 will take place.
     
*/
	protected native void closeEvent( QCloseEvent e);
	protected native void virtual_hook( int identifier, int data);

/** 
 Activated when the Help button has been clicked. If a help
 text has been defined, the help system will be activated.
     
*/
	protected native void slotHelp();

/** 
 Activated when the Default button has been clicked.
     
*/
	protected native void slotDefault();

/** 
 Activated when the Details button has been clicked.

*/
	protected native void slotDetails();

/** 
 Activated when the User3 button has been clicked.
     
*/
	protected native void slotUser3();

/** 
 Activated when the User2 button has been clicked.
     
*/
	protected native void slotUser2();

/** 
 Activated when the User1 button has been clicked.
     
*/
	protected native void slotUser1();

/** 
 Activated when the Ok button has been clicked. The
 {@link QDialog#accept} is activated.
     
*/
	protected native void slotOk();

/** 
 Activated when the Apply button has been clicked.
     
*/
	protected native void slotApply();

/** 
 Activated when the Try button has been clicked.
     
*/
	protected native void slotTry();

/** 
 Activated when the Yes button has been clicked. The
 {@link QDialog#done} is activated.
     
*/
	protected native void slotYes();

/** 
 Activated when the Yes button has been clicked. The
 {@link QDialog#done} is activated.
     
*/
	protected native void slotNo();

/** 
 Activated when the Cancel button has been clicked. The
 {@link QDialog#reject} is activated in regular mode and
 {@link QDialog#done} when in message box mode.
     
*/
	protected native void slotCancel();

/** 
 Activated when the Close button has been clicked. The
 {@link QDialog#reject} is activated.
     
*/
	protected native void slotClose();

/** 
 Do not use this slot. Is is kept for compatibility reasons.
 Activated when the Apply button has been clicked
     
*/
	protected native void applyPressed();

/** 
 Updates the margins and spacings.
     
*/
	public native void updateGeometry();

/** 
 Deletes the dialog immediately. If you want to delete the dialog
 delayed use delayedDestruct() or QObject.deleteLater().

 Attention: Do no use connect this slot to signals from user
 actions!
     
*/
	protected native void slotDelayedDestruct();
	public static final int Help = 0x00000001;
	public static final int Default = 0x00000002;
	public static final int Ok = 0x00000004;
	public static final int Apply = 0x00000008;
	public static final int Try = 0x00000010;
	public static final int Cancel = 0x00000020;
	public static final int Close = 0x00000040;
	public static final int User1 = 0x00000080;
	public static final int User2 = 0x00000100;
	public static final int User3 = 0x00000200;
	public static final int No = 0x00000080;
	public static final int Yes = 0x00000100;
	public static final int Details = 0x00000400;
	public static final int Filler = 0x40000000;
	public static final int Stretch = 0x80000000;
	public static final int ActionStyle0 = 0;
	public static final int ActionStyle1 = 0;
	public static final int ActionStyle2 = 1;
	public static final int ActionStyle3 = 2;
	public static final int ActionStyle4 = 3;
	public static final int ActionStyleMAX = 4;
	public static final int TreeList = KJanusWidget.TreeList;
	public static final int Tabbed = KJanusWidget.Tabbed;
	public static final int Plain = KJanusWidget.Plain;
	public static final int Swallow = KJanusWidget.Swallow;
	public static final int IconList = KJanusWidget.IconList;
}
