/***************************************************************************
                            KComboBox.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A combined button, line-edit and a popup list widget.

 This widget inherits from {@link QComboBox} and implements the following
 additional functionalities:  a completion object that provides both automatic
 and manual text completion as well as text rotation features, configurable
 key-bindings to activate these features, and a popup-menu item that can be
 used to allow the user to change the text completion mode on the fly.

 To support these new features KComboBox emits a few additional signals 
 such as {@link #completion} and {@link #textRotation}.
 The completion signal can be connected to a slot that will assist the user in 
 filling out the remaining text while the rotation signal can be used to traverse
 through all possible matches whenever text completion results in multiple matches.
 Additionally, a {@link #returnPressed} and a {@link #returnPressed}
 signals are emitted when the user presses the Enter/Return key.

 KCombobox by default creates a completion object when you invoke the 
 {@link #completionObject} member function for the first time or 
 explicitly use {@link #setCompletionObject} to assign your
 own completion object.  Additionally, to make this widget more functional, 
 KComboBox will by default handle text rotation and completion events
 internally whenever a completion object is created through either one of the 
 methods mentioned above.  If you do not need this functionality, simply use
 {@link KCompletionBase#setHandleSignals} or alternatively set the boolean
 parameter in the <code>setCompletionObject</code> call to FALSE.

 The default key-bindings for completion and rotation is determined from the
 global settings in {@link KStdAccel}. These values, however, can be overriden
 locally by invoking {@link KCompletionBase#setKeyBinding}. The values can
 easily be reverted back to the default setting, by simply calling 
 {@link #useGlobalSettings}. An alternate method would be to default individual
 key-bindings by usning {@link #setKeyBinding} with the default second argument.

 In non-editable (select-only) mode only one completion mode, <code>CompletionAuto</code>, 
 is available. All the other modes are simply ignored. Moreover, the CompletionAuto
 mode, unlike in the read-write mode, works by matching any typed key with the
 first letter of entries in the combobox.

 To enable the basic completion feature:

 <pre>
 KComboBox combo = new KComboBox( true, this, "mywidget" );
 KCompletion comp = combo.completionObject();
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");

 // Provide the to be completed strings. Note that those are separate from the combo's
 // contents.
 comp.insertItems( someStringList );
 </pre>

 To use your own completion object:

 <pre>
 KComboBox combo = new KComboBox( this,"mywidget" );
 KURLCompletion comp = new KURLCompletion();
 combo.setCompletionObject( comp );
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");
 </pre>

 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );

 Miscellaneous function calls:

 <pre>
 // Tell the widget not to handle completion and rotation
 combo.setHandleSignals( false );
 // Set your own completion key for manual completions.
 combo.setKeyBinding( KCompletionBase.TextCompletion, Qt.End );
 // Hide the context (popup) menu
 combo.setContextMenuEnabled( false );
 </pre>

 See {@link KComboBoxSignals} for signals emitted by KComboBox.

 

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An enhanced combo box.

*/
public class KComboBox extends QComboBox implements  KCompletionBaseInterface {
	protected KComboBox(Class dummy){super((Class) null);}

	private native void newKComboBox( QWidget parent, String name);

/** 
 Constructs a read-only or rather select-only combo box with a
 parent object and a name.

*/
	public KComboBox( QWidget parent, String name) {
		super((Class) null);
		newKComboBox( parent, name);
	}
	private native void newKComboBox();
	public KComboBox() {
		super((Class) null);
		newKComboBox();
	}
	private native void newKComboBox( boolean rw, QWidget parent, String name);

/** 
 Constructs a "read-write" or "read-only" combo box depending on
 the value of the first argument( <code>rw</code> ) with a parent, a
 name.

*/
	public KComboBox( boolean rw, QWidget parent, String name) {
		super((Class) null);
		newKComboBox( rw, parent, name);
	}
	private native void newKComboBox( boolean rw);
	public KComboBox( boolean rw) {
		super((Class) null);
		newKComboBox( rw);
	}

/** 
 Destructor.
    
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets <code>url</code> into the edit field of the combobox. It uses
 {@link KURL#prettyURL} so that the url is properly decoded for
 displaying.
     
*/
	public native void setEditURL( KURL url);

/** 
 Inserts <code>url</code> at position <code>index</code> into the combobox. The item will
 be appended if <code>index</code> is negative. {@link KURL#prettyURL} is used
 so that the url is properly decoded for displaying.
     
*/
	public native void insertURL( KURL url, int index);
	public native void insertURL( KURL url);

/** 
 Inserts <code>url</code> with the pixmap &p pixmap at position <code>index</code> into
 the combobox. The item will be appended if <code>index</code> is negative.
 {@link KURL#prettyURL} is used so that the url is properly decoded
 for displaying.
     
*/
	public native void insertURL( QPixmap pixmap, KURL url, int index);
	public native void insertURL( QPixmap pixmap, KURL url);

/** 
 Replaces the item at position <code>index</code> with <code>url.</code>
 {@link KURL#prettyURL} is used so that the url is properly decoded
 for displaying.
     
*/
	public native void changeURL( KURL url, int index);

/** 
 Replaces the item at position <code>index</code> with <code>url</code> and pixmap <code>pixmap.</code>
 {@link KURL#prettyURL} is used so that the url is properly decoded
 for displaying.
     
*/
	public native void changeURL( QPixmap pixmap, KURL url, int index);

/** 
 Returns the current cursor position.

 This method always returns a -1 if the combo-box is <em>not</em>
 editable (read-write).

*/
	public native int cursorPosition();

/** 
 Re-implemented from {@link QComboBox}.

 If <code>true</code>, the completion mode will be set to automatic.
 Otherwise, it is defaulted to the global setting.  This
 method has been replaced by the more comprehensive
 {@link #setCompletionMode}.

*/
	public native void setAutoCompletion( boolean autocomplete);

/** 
 Re-implemented from QComboBox.

 Returns <code>true</code> if the current completion mode is set
 to automatic.  See its more comprehensive replacement
 {@link #completionMode}.

*/
	public native boolean autoCompletion();

/** 
 Enables or disable the popup (context) menu.

 This method only works if this widget is editable, i.e.
 read-write and allows you to enable/disable the context
 menu.  It does nothing if invoked for a none-editable
 combo-box.  Note that by default the mode changer item
 is made visiable whenever the context menu is enabled.
 Use {@link #hideModechanger} if you want to hide this
 item.    Also by default, the context menu is created if
 this widget is editable. Call this function with the
 argument set to false to disable the popup menu.

*/
	public native void setContextMenuEnabled( boolean showMenu);

/** 
 Returns <code>true</code> when the context menu is enabled.
    
*/
	public native boolean isContextMenuEnabled();

/** 
 Enables/Disables handling of URL drops. If enabled and the user
 drops an URL, the decoded URL will be inserted. Otherwise the default
 behaviour of QComboBox is used, which inserts the encoded URL.

*/
	public native void setURLDropsEnabled( boolean enable);

/** 
 Returns <code>true</code> when decoded URL drops are enabled
     
*/
	public native boolean isURLDropsEnabled();

/** 
 Convenience method which iterates over all items and checks if
 any of them is equal to <code>text.</code>

 If <code>text</code> is an empty string, <code>false</code>
 is returned.

*/
	public native boolean contains( String text);

/** 
 By default, KComboBox recognizes Key_Return and Key_Enter
 and emits
 the {@link #returnPressed} signals, but it also lets the event pass,
 for example causing a dialog's default-button to be called.

 Call this method with <code>trap</code> equal to true to make KComboBox
 stop these
 events. The signals will still be emitted of course.

 Only affects read-writable comboboxes.

*/
	public native void setTrapReturnKey( boolean trap);

/** 

*/
	public native boolean trapReturnKey();

/** 

*/
	public native KCompletionBox completionBox( boolean create);
	public native KCompletionBox completionBox();
	public native void setLineEdit( QLineEdit arg1);

/** 
 Iterates through all possible matches of the completed text
 or the history list.

 Depending on the value of the argument, this function either
 iterates through the history list of this widget or the all
 possible matches in whenever multiple matches result from a
 text completion request.  Note that the all-possible-match
 iteration will not work if there are no previous matches, i.e.
 no text has been completed and the nix shell history list
 rotation is only available if the insertion policy for this
 widget is set either <code>QComobBox.AtTop</code> or <code>QComboBox.AtBottom.</code>
 For other insertion modes whatever has been typed by the user
 when the rotation event was initiated will be lost.

*/
//	public native void rotateText( KCompletionBase_KeyBindingType arg1);

/** 
 Sets the completed text in the line-edit appropriately.

 This function is an implementation for
 {@link KCompletionBase#setCompletedText}.
     
*/
	public native void setCompletedText( String arg1);

/** 
 Sets <code>items</code> into the completion-box if {@link #completionMode} is
 CompletionPopup. The popup will be shown immediately.
     
*/
	public native void setCompletedItems( String[] items);

/** 
 Selects the first item that matches <code>item.</code> If there is no such item,
 it is inserted at position <code>index</code> if <code>insert</code> is true. Otherwise,
 no item is selected.
     
*/
	public native void setCurrentItem( String item, boolean insert, int index);
	public native void setCurrentItem( String item);
	public native void setCurrentItem( int index);
	protected native void setCompletedText( String arg1, boolean arg2);

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
	protected native void create( int arg1, boolean initializeWindow, boolean destroyOldWindow);
	protected native void create();
	protected native void wheelEvent( QWheelEvent ev);
	protected native void virtual_hook( int identifier, int data);

/** 

    
*/
	protected native void itemSelected( QListBoxItem arg1);

/** 
 Completes text according to the completion mode.

 Note: this method is <code>not</code> invoked if the completion mode is
 set to CompletionNone.  Also if the mode is set to <code>CompletionShell</code>
 and multiple matches are found, this method will complete the
 text to the first match with a beep to inidicate that there are
 more matches.  Then any successive completion key event iterates
 through the remaining matches.  This way the rotation functionality
 is left to iterate through the list as usual.
    
*/
	protected native void makeCompletion( String arg1);
	
	// From KCompletionBaseInterface
	
/**
 Returns a pointer to the current completion object.

 If the object does not exist, it is automatically
 created.  Note that the completion object created
 here is used by default to handle the signals
 internally.  It is also deleted when this object's
 destructor is invoked.  If you do not want these
 default settings, use {@link setAutoDeleteCompletionObject}
 and {@link setHandleSignals} to change the behavior.
 Alternatively, you can set the boolean parameter to
 false to disable the automatic handling of the signals
 by this object.  Note that the boolean argument will be
 ignored if there already exists a completion object since
 no new object needs to be created. You need to use either
 {@link setHandleSignals} or {@link setCompletionObject} for
 such cases depending on your requirement.

*/
	public native KCompletion completionObject( boolean hsig);
	public native KCompletion completionObject();

/**
 Sets up the completion object to be used.

 This method assigns the completion object and sets it
 up to automatically handle the completion and rotation
 signals internally.  You should use this function if
 you want to share one completion object among you widgets
 or need to use a customized completion object.

 The object assigned through this method is not deleted
 when this object's destructor is invoked unless you
 explicitly call {@link setAutoDeleteCompletionObject} after
 calling this method.  Also if you do not want the signals
 to be handled by an internal implementation, be sure to
 set the boolean argument to false.

 This method is also called when a completion-object is created
 automatically, when completionObject() is called the first time.

*/
	public native void setCompletionObject( KCompletion arg1, boolean hsig);
	public native void setCompletionObject( KCompletion arg1);

/**
 Enables this object to handle completion and rotation
 events internally.

 This function simply assigns a boolean value that
 indicates whether it should handle rotation and
 completion events or not.  Note that this does not
 stop the object from emitting signals when these
 events occur.

*/
	public native void setHandleSignals( boolean arg1);

/**
 Returns true if the completion object is deleted
 upon this widget's destruction.

 See {@link #setCompletionObject} and {@link #enableCompletion}
 for details.

*/
	public native boolean isCompletionObjectAutoDeleted();

/**
 Sets the completion object when this widget's destructor
 is called.

 If the argument is set to true, the completion object
 is deleted when this widget's destructor is called.

*/
	public native void setAutoDeleteCompletionObject( boolean autoDelete);

/**
 Sets the widget's ability to emit text completion and
 rotation signals.

 Invoking this function with <code>enable</code> set to <code>false</code> will
 cause the completion & rotation signals not to be emitted.
 However, unlike setting the completion object to <code>NULL</code>
 using {@link setCompletionObject}, disabling the emition of
 the signals through this method does not affect the current
 completion object.

 There is no need to invoke this function by default.  When a
 completion object is created through {@link completionObject} or
 {@link setCompletionObject}, these signals are set to emit
 automatically.  Also note that disabling this signals will not
 necessarily interfere with the objects ability to handle these
 events internally.  See {@link setHandleSignals}.

*/
	public native void setEnableSignals( boolean enable);

/**
 Returns true if the object handles the signals

*/
	public native boolean handleSignals();

/**
 Returns true if the object emits the signals

*/
	public native boolean emitSignals();

/**
 Sets the type of completion to be used.

 The completion modes supported are those defined in
 {@link #KGlobalSettings}.  See below.

*/
	public native void setCompletionMode( int mode);

/**
 Returns the current completion mode.

 The return values are of type {@link KGlobalSettings#Completion}.
 See {@link #setCompletionMode} for details.

*/
	public native int completionMode();

/**
 Sets the key-binding to be used for manual text
 completion, text rotation in a history list as
 well as a completion list.

 When the keys set by this function are pressed, a
 signal defined by the inheriting widget will be activated.
 If the default value or 0 is specified by the second
 parameter, then the key-binding as defined in the global
 setting should be used.  This method returns false value
 for <code>key</code> is negative or the supplied key-binding conflicts
 with the ones set for one of the other features.

 NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
 the key-binding simply simply <code>sum</code> up the values of the
 modifier and the actual key.  For example, to use CTRL+E as
 a key binding for one of the items, you would simply supply
 <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
 function.

*/
	public native boolean setKeyBinding( int arg1, KShortcut cut);

/**
 Returns the key-binding used for the specified item.

 This methods returns the key-binding used to activate
 the feature feature given by <code>item.</code>  If the binding
 contains modifier key(s), the SUM of the modifier key
 and the actual key code are returned.

*/
	public native KShortcut getKeyBinding( int item);

/**
 Sets this object to use global values for key-bindings.

 This method changes the values of the key bindings for
 rotation and completion features to the default values
 provided in KGlobalSettings.

 NOTE: By default inheriting widgets should uses the
 global key-bindings so that there will be no need to
 call this method.

*/
	public native void useGlobalKeyBindings();


/**
 Returns a pointer to the completion object.

 This method is only different from {@link #completionObject}
 in that it does not create a new KCompletion object even if
 the internal pointer is <code>NULL.</code> Use this method to get the
 pointer to a completion object when inheriting so that you
 won't inadvertently create it!!

*/
	public native KCompletion compObj();
	
}
