/*
	Various utilities
	
	Copyright
		(C) 1992 Joseph H. Allen
		(C) 2001 Marek 'Marx' Grac

	This file is part of JOE (Joe's Own Editor)
*/

#ifndef _JOEutils
#define _JOEutils 1

#include "config.h"

/* 
 * Characters which are considered as word characters 
 * 	_ is considered as word character because is often used 
 *	in the names of C/C++ functions
 */
unsigned int isalnum_ PARAMS((unsigned int c));

/* 
 * Whitespace characters are characters like tab, space, ...
 *	Every config line in *rc must be end by whitespace but
 *	EOF is not considered as whitespace by isspace()
 *	This is because I don't want to be forced to end 
 *	*rc file with \n
 */
int isspace_eof PARAMS((int c));

/*
 * Define function isblank(c)
 *	isblank() is GNU extension;
 *	even #including <ctype.h> without additional hackery doesn't import
 *	the prototype, so we define it here unconditionaly
 */
int isblank PARAMS((int c));

/*
 * Functions which return minimum/maximum of two numbers  
 */
unsigned int uns_min PARAMS((unsigned int a, unsigned int b));
signed int int_min PARAMS((signed int a, int signed b));
signed long long_max PARAMS((signed long a, signed long b));
signed long long_min PARAMS((signed long a, signed long b));

#endif
