/*****************************************************************************/

/*
 *      stp.h  --  STP router.
 *
 *      Copyright (C) 2000
 *        Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*****************************************************************************/

#ifndef _STP_H
#define _STP_H

/* ---------------------------------------------------------------------- */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <stdarg.h>
#include <stdio.h>

#include "list.h"

/* ---------------------------------------------------------------------- */

/*
 * Bittypes
 */

#ifndef HAVE_SIGNED_BITTYPES

#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)
typedef int int8_t __attribute__((__mode__(__QI__)));
typedef int int16_t __attribute__((__mode__(__HI__)));
typedef int int32_t __attribute__((__mode__(__SI__)));
typedef int int64_t __attribute__((__mode__(__DI__)));
#else
typedef char /* deduced */ int8_t __attribute__((__mode__(__QI__)));
typedef short /* deduced */ int16_t __attribute__((__mode__(__HI__)));
typedef long /* deduced */ int32_t __attribute__((__mode__(__SI__)));
typedef long long /* deduced */ int64_t __attribute__((__mode__(__DI__)));
#endif

#endif /* !HAVE_SIGNED_BITTYPES */

#ifndef HAVE_UNSIGNED_BITTYPES

#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)
typedef unsigned int u_int8_t __attribute__((__mode__(__QI__)));
typedef unsigned int u_int16_t __attribute__((__mode__(__HI__)));
typedef unsigned int u_int32_t __attribute__((__mode__(__SI__)));
typedef unsigned int u_int64_t __attribute__((__mode__(__DI__)));
#else
typedef unsigned char /* deduced */ u_int8_t __attribute__((__mode__(__QI__)));
typedef unsigned short /* deduced */ u_int16_t __attribute__((__mode__(__HI__)));
typedef unsigned long /* deduced */ u_int32_t __attribute__((__mode__(__SI__)));
typedef unsigned long long /* deduced */ u_int64_t __attribute__((__mode__(__DI__)));
#endif

#endif /* !HAVE_UNSIGNED_BITTYPES */

/* ---------------------------------------------------------------------- */

#ifndef HAVE_VSNPRINTF
extern int vsnprintf(char *str, size_t n, char const *fmt, va_list args);
#endif

#ifndef HAVE_SNPRINTF
extern int snprintf(char *str, size_t n, char const *fmt, ...) __attribute__ ((format (printf, 3, 4)));
#endif

/* ---------------------------------------------------------------------- */

extern FILE *yyin;

extern int yywrap(void);
extern int yylex(void);
extern void yyerror(const char *msg);
extern int yyparse(void);

extern int yyleng;
extern char *yytext;

//#define YYDEBUG 1

extern unsigned int stpconf_lineno;

/* ---------------------------------------------------------------------- */

extern inline unsigned int hweight32(unsigned int w) 
{
        unsigned int res = (w & 0x55555555) + ((w >> 1) & 0x55555555);
        res = (res & 0x33333333) + ((res >> 2) & 0x33333333);
        res = (res & 0x0F0F0F0F) + ((res >> 4) & 0x0F0F0F0F);
        res = (res & 0x00FF00FF) + ((res >> 8) & 0x00FF00FF);
        return (res & 0x0000FFFF) + ((res >> 16) & 0x0000FFFF);
}

extern inline unsigned int hweight16(unsigned short w)
{
        unsigned short res = (w & 0x5555) + ((w >> 1) & 0x5555);
        res = (res & 0x3333) + ((res >> 2) & 0x3333);
        res = (res & 0x0F0F) + ((res >> 4) & 0x0F0F);
        return (res & 0x00FF) + ((res >> 8) & 0x00FF);
}

extern inline unsigned int hweight8(unsigned char w)
{
        unsigned short res = (w & 0x55) + ((w >> 1) & 0x55);
        res = (res & 0x33) + ((res >> 2) & 0x33);
        return (res & 0x0F) + ((res >> 4) & 0x0F);
}

/* ---------------------------------------------------------------------- */

#define MAXPACKETSIZE  16384
#define MAXHEADERSIZE   1024
#define OUTQUEUESIZE      16

struct packet {
	unsigned int refcnt;
       	/* fields extracted from header */
	unsigned char satname[64];
	unsigned int hopcnt;
	/* data */
	unsigned int len;
	unsigned char buf[0];
};

struct confudpinput {
	struct list_head list;
	struct list_head uifdlist;
	u_int16_t port;
	u_int32_t addr;
	u_int32_t mask;
	u_int8_t maskbits;
	unsigned int maxhops;
};

struct conftcpinput {
	struct list_head list;
	struct list_head tifdlist;
	u_int16_t port;
	u_int32_t addr;
	u_int32_t mask;
	u_int8_t maskbits;
	unsigned int maxconn;
	unsigned int cntconn;
	unsigned int maxhops;
};

struct confudpoutput {
	struct list_head list;
	u_int32_t addr;
	u_int16_t port;
};

struct conftcpoutput {
	struct list_head list;
	struct list_head tofdlist;
	int port;
	u_int32_t addr;
	u_int32_t mask;
	u_int8_t maskbits;
	unsigned int passive;
	unsigned int maxconn;
	unsigned int cntconn;
	unsigned int interval;
	time_t nextconntime;
};

struct udpinput {
	struct list_head list;
	struct list_head conflist;
	u_int16_t port;
	int fd;
};

struct tcpinput {
	struct list_head list;
	struct list_head conflist;
	u_int16_t port;
	int fd;
};

/* this is actually bidirectional */
struct tcpoutput {
	struct list_head list;
	unsigned int inprogress;
	int fd;
	u_int32_t peeraddr;
	u_int16_t peerport;
	struct conftcpinput *confin;
	struct conftcpoutput *confout;

	unsigned int oqwr, oqrd, optr;
	struct packet *oqueue[OUTQUEUESIZE];

	unsigned int inlen;
	unsigned char inbuf[MAXPACKETSIZE];
};

extern struct list_head confudpinputlist;
extern struct list_head conftcpinputlist;
extern struct list_head confudpoutputlist;
extern struct list_head conftcpoutputlist;
extern struct list_head udpinputlist;
extern struct list_head tcpinputlist;
extern struct list_head tcpoutputlist;

/* ---------------------------------------------------------------------- */
#endif /* _STP_H */
