/*
** THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
** PURSUANT TO THE 3DFX GLIDE GENERAL PUBLIC LICENSE. THERE IS NO RIGHT
** TO USE THE GLIDE TRADEMARK WITHOUT PRIOR WRITTEN PERMISSION OF 3DFX
** INTERACTIVE, INC. A COPY OF THIS LICENSE MAY BE OBTAINED FROM THE 
** DISTRIBUTOR OR BY CONTACTING 3DFX INTERACTIVE INC(info@3dfx.com). 
** THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
** EXPRESSED OR IMPLIED. SEE THE 3DFX GLIDE GENERAL PUBLIC LICENSE FOR A
** FULL TEXT OF THE NON-WARRANTY PROVISIONS.  
** 
** USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
** RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
** TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
** AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
** SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
** THE UNITED STATES.  
** 
** COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS RESERVED
**
** File name:   memtable.h
**
** Description: Table to initialize dramInit0 and sgramMode.
**
** $Revision: 1.1.1.1 $
** $Date: 1999/11/24 21:44:53 $
**
** $History: memtable.h $
** 
** *****************  Version 1  *****************
** User: Sapphire     Date: 3/16/99    Time: 7:28p
** Created in $/Releases/Voodoo3/V3_OEM_100/3dfx/devel/H3/cinit
** 
** *****************  Version 6  *****************
** User: Michael      Date: 1/11/99    Time: 3:53p
** Updated in $/devel/h3/Win95/dx/minivdd
** Implement the 3Dfx/STB unified header.
** 
** *****************  Version 5  *****************
** User: Psmith       Date: 8/09/98    Time: 7:53a
** Updated in $/devel/h3/cinit
** added Generic SGRAM/SDRAM memory timings that have lower performance
** but will work for all currently-supported chips.
** default memory vendor type changed to Generic from Samsung.
** 
** *****************  Version 4  *****************
** User: Psmith       Date: 7/31/98    Time: 1:35a
** Updated in $/devel/h3/cinit
** changed block write to 2 cycles for Etron 16Mbit partsd
** 
** *****************  Version 3  *****************
** User: Psmith       Date: 7/22/98    Time: 9:11a
** Updated in $/devel/h3/cinit
** added sdram support
** 
** *****************  Version 2  *****************
** User: Ken          Date: 4/15/98    Time: 6:41p
** Updated in $/devel/h3/win95/dx/minivdd
** added unified header to all files, with revision, etc. info in it
**
*/

//
// generated by gen_memtable.pl at Sun Aug  9 07:21:36 1998
//

#define MEM_TYPE_SGRAM  0
#define MEM_TYPE_SDRAM  1


struct memTable_st {
    char vendor[8];
    FxU32 type;
    FxU32 size;
    FxU32 dramInit0;
    FxU32 sgramMode;
} memTable[] = {

//      vendor   	type 		size 	dramInit0 	sgramMode
//    ---------- 	---- 		---- 	--------- 	---------
    {    "ETRON", 	MEM_TYPE_SGRAM, 16, 	0x001698e9, 	0x00000037} , 
    {    "ETRON", 	MEM_TYPE_SGRAM,  8, 	0x0016a169, 	0x00000037} , 
    {  "GENERIC", 	MEM_TYPE_SDRAM, 16, 	0x00169d25, 	0x00000037} , 
    {  "GENERIC", 	MEM_TYPE_SGRAM, 16, 	0x00179d29, 	0x00000037} , 
    {  "GENERIC", 	MEM_TYPE_SGRAM,  8, 	0x001fa569, 	0x00000037} , 
    {    "GLINK", 	MEM_TYPE_SGRAM,  8, 	0x001ea169, 	0x00000037} , 
    {    "MOSYS", 	MEM_TYPE_SGRAM, 16, 	0x00015495, 	0x00000027} , 
    {    "MOSYS", 	MEM_TYPE_SGRAM,  8, 	0x00155495, 	0x00000027} , 
    {  "SAMSUNG", 	MEM_TYPE_SDRAM, 16, 	0x00169d25, 	0x00000037} , 
    {  "SAMSUNG", 	MEM_TYPE_SGRAM, 16, 	0x00169d25, 	0x00000037} , 
    {  "SAMSUNG", 	MEM_TYPE_SGRAM,  8, 	0x00169d25, 	0x00000037} , 
    {  "SIEMENS", 	MEM_TYPE_SGRAM,  8, 	0x0016a169, 	0x00000037} , 
    {  "TOSHIBA", 	MEM_TYPE_SGRAM,  8, 	0x0016a565, 	0x00000037} , 
};
#define MEM_TABLE_SIZE (sizeof(memTable)/sizeof(struct memTable_st))

#define MEM_ETRON_SGRAM_16	0
#define MEM_ETRON_SGRAM_8	1
#define MEM_GENERIC_SDRAM_16	2
#define MEM_GENERIC_SGRAM_16	3
#define MEM_GENERIC_SGRAM_8	4
#define MEM_GLINK_SGRAM_8	5
#define MEM_MOSYS_SGRAM_16	6
#define MEM_MOSYS_SGRAM_8	7
#define MEM_SAMSUNG_SDRAM_16	8
#define MEM_SAMSUNG_SGRAM_16	9
#define MEM_SAMSUNG_SGRAM_8	10
#define MEM_SIEMENS_SGRAM_8	11
#define MEM_TOSHIBA_SGRAM_8	12

#define MEM_DEFAULT_SGRAM_8  MEM_GENERIC_SGRAM_8
#define MEM_DEFAULT_SGRAM_16 MEM_GENERIC_SGRAM_16
#define MEM_DEFAULT_SDRAM_16 MEM_GENERIC_SDRAM_16

