/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.util.Debug;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.CertificatePolicyMap;
import sun.security.x509.InhibitAnyPolicyExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyConstraintsExtension;
import sun.security.x509.PolicyInformation;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.X509CertImpl;

class PolicyChecker
extends PKIXCertPathChecker {
    private final Set initPolicies;
    private final int certPathLen;
    private final boolean expPolicyRequired;
    private final boolean polMappingInhibited;
    private final boolean anyPolicyInhibited;
    private final boolean rejectPolicyQualifiers;
    private PolicyNodeImpl rootNode;
    private int explicitPolicy;
    private int policyMapping;
    private int inhibitAnyPolicy;
    private int certIndex;
    private Set supportedExts;
    private static final Debug debug = Debug.getInstance("certpath");
    static final String ANY_POLICY = "2.5.29.32.0";

    PolicyChecker(Set set, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, PolicyNodeImpl policyNodeImpl) throws CertPathValidatorException {
        if (set.isEmpty()) {
            this.initPolicies = new HashSet(1);
            this.initPolicies.add(ANY_POLICY);
        } else {
            this.initPolicies = new HashSet(set);
        }
        this.certPathLen = n2;
        this.expPolicyRequired = bl2;
        this.polMappingInhibited = bl3;
        this.anyPolicyInhibited = bl4;
        this.rejectPolicyQualifiers = bl5;
        this.rootNode = policyNodeImpl;
        this.init(false);
    }

    public void init(boolean bl2) throws CertPathValidatorException {
        if (bl2) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.certIndex = 1;
        this.explicitPolicy = this.expPolicyRequired ? 0 : this.certPathLen + 1;
        this.policyMapping = this.polMappingInhibited ? 0 : this.certPathLen + 1;
        this.inhibitAnyPolicy = this.anyPolicyInhibited ? 0 : this.certPathLen + 1;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        if (this.supportedExts == null) {
            this.supportedExts = new HashSet();
            this.supportedExts.add(PKIXExtensions.CertificatePolicies_Id.toString());
            this.supportedExts.add(PKIXExtensions.PolicyMappings_Id.toString());
            this.supportedExts.add(PKIXExtensions.PolicyConstraints_Id.toString());
            this.supportedExts.add(PKIXExtensions.InhibitAnyPolicy_Id.toString());
            this.supportedExts = Collections.unmodifiableSet(this.supportedExts);
        }
        return this.supportedExts;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        this.checkPolicy((X509Certificate)certificate);
        if (collection != null && !collection.isEmpty()) {
            collection.remove(PKIXExtensions.CertificatePolicies_Id.toString());
            collection.remove(PKIXExtensions.PolicyMappings_Id.toString());
            collection.remove(PKIXExtensions.PolicyConstraints_Id.toString());
            collection.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
        }
    }

    private void checkPolicy(X509Certificate x509Certificate) throws CertPathValidatorException {
        String string = "certificate policies";
        if (debug != null) {
            debug.println("PolicyChecker.checkPolicy() ---checking " + string + "...");
            debug.println("PolicyChecker.checkPolicy() certIndex = " + this.certIndex);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: explicitPolicy = " + this.explicitPolicy);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: policyMapping = " + this.policyMapping);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: inhibitAnyPolicy = " + this.inhibitAnyPolicy);
            debug.println("PolicyChecker.checkPolicy() BEFORE PROCESSING: policyTree = " + this.rootNode);
        }
        X509CertImpl x509CertImpl = null;
        try {
            x509CertImpl = new X509CertImpl(x509Certificate.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        boolean bl2 = false;
        if (this.certIndex == this.certPathLen) {
            bl2 = true;
        }
        this.rootNode = PolicyChecker.processPolicies(this.certIndex, this.initPolicies, this.explicitPolicy, this.policyMapping, this.inhibitAnyPolicy, this.rejectPolicyQualifiers, this.rootNode, x509CertImpl, bl2);
        if (!bl2) {
            this.explicitPolicy = PolicyChecker.mergeExplicitPolicy(this.explicitPolicy, x509CertImpl, bl2);
            this.policyMapping = PolicyChecker.mergePolicyMapping(this.policyMapping, x509CertImpl);
            this.inhibitAnyPolicy = PolicyChecker.mergeInhibitAnyPolicy(this.inhibitAnyPolicy, x509CertImpl);
        }
        ++this.certIndex;
        if (debug != null) {
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: explicitPolicy = " + this.explicitPolicy);
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: policyMapping = " + this.policyMapping);
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: inhibitAnyPolicy = " + this.inhibitAnyPolicy);
            debug.println("PolicyChecker.checkPolicy() AFTER PROCESSING: policyTree = " + this.rootNode);
            debug.println("PolicyChecker.checkPolicy() " + string + " verified");
        }
    }

    static int mergeExplicitPolicy(int n2, X509CertImpl x509CertImpl, boolean bl2) throws CertPathValidatorException {
        if (!x509CertImpl.getIssuerDN().equals(x509CertImpl.getSubjectDN()) && n2 > 0) {
            --n2;
        }
        try {
            PolicyConstraintsExtension policyConstraintsExtension = x509CertImpl.getPolicyConstraintsExtension();
            if (policyConstraintsExtension == null) {
                return n2;
            }
            int n3 = (Integer)policyConstraintsExtension.get("require");
            if (debug != null) {
                debug.println("PolicyChecker.mergeExplicitPolicy() require Index from cert = " + n3);
            }
            if (!bl2) {
                if (n3 != -1 && (n2 == -1 || n3 < n2)) {
                    n2 = n3;
                }
            } else if (n3 == 0) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("PolicyChecker.mergeExplicitPolicy unexpected exception");
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        return n2;
    }

    static int mergePolicyMapping(int n2, X509CertImpl x509CertImpl) throws CertPathValidatorException {
        if (!x509CertImpl.getIssuerDN().equals(x509CertImpl.getSubjectDN()) && n2 > 0) {
            --n2;
        }
        try {
            PolicyConstraintsExtension policyConstraintsExtension = x509CertImpl.getPolicyConstraintsExtension();
            if (policyConstraintsExtension == null) {
                return n2;
            }
            int n3 = (Integer)policyConstraintsExtension.get("inhibit");
            if (debug != null) {
                debug.println("PolicyChecker.mergePolicyMapping() inhibit Index from cert = " + n3);
            }
            if (n3 != -1 && (n2 == -1 || n3 < n2)) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("PolicyChecker.mergePolicyMapping unexpected exception");
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        return n2;
    }

    static int mergeInhibitAnyPolicy(int n2, X509CertImpl x509CertImpl) throws CertPathValidatorException {
        if (!x509CertImpl.getIssuerDN().equals(x509CertImpl.getSubjectDN()) && n2 > 0) {
            --n2;
        }
        try {
            InhibitAnyPolicyExtension inhibitAnyPolicyExtension = (InhibitAnyPolicyExtension)x509CertImpl.getExtension(PKIXExtensions.InhibitAnyPolicy_Id);
            if (inhibitAnyPolicyExtension == null) {
                return n2;
            }
            int n3 = (Integer)inhibitAnyPolicyExtension.get("skip_certs");
            if (debug != null) {
                debug.println("PolicyChecker.mergeInhibitAnyPolicy() skipCerts Index from cert = " + n3);
            }
            if (n3 != -1 && (n2 == -1 || n3 < n2)) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("PolicyChecker.mergeInhibitAnyPolicy unexpected exception");
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        return n2;
    }

    static PolicyNodeImpl processPolicies(int n2, Set set, int n3, int n4, int n5, boolean bl2, PolicyNodeImpl policyNodeImpl, X509CertImpl x509CertImpl, boolean bl3) throws CertPathValidatorException {
        boolean bl4 = false;
        PolicyNodeImpl policyNodeImpl2 = null;
        Set set2 = new HashSet();
        policyNodeImpl2 = policyNodeImpl == null ? null : policyNodeImpl.copyTree();
        CertificatePoliciesExtension certificatePoliciesExtension = x509CertImpl.getCertificatePoliciesExtension();
        if (certificatePoliciesExtension != null && policyNodeImpl2 != null) {
            Object object;
            Vector vector;
            bl4 = certificatePoliciesExtension.isCritical();
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() policiesCritical = " + bl4);
            }
            try {
                vector = (Vector)certificatePoliciesExtension.get("policies");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("Exception while retrieving policyOIDs", iOException);
            }
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() rejectPolicyQualifiers = " + bl2);
            }
            boolean bl5 = false;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Set set3;
                object = (PolicyInformation)iterator.next();
                String string = ((PolicyInformation)object).getPolicyIdentifier().getIdentifier().toString();
                if (string.equals(ANY_POLICY)) {
                    bl5 = true;
                    set2 = ((PolicyInformation)object).getPolicyQualifiers();
                    continue;
                }
                if (debug != null) {
                    debug.println("PolicyChecker.processPolicies() processing policy: " + string);
                }
                if (!(set3 = ((PolicyInformation)object).getPolicyQualifiers()).isEmpty() && bl2 && bl4) {
                    throw new CertPathValidatorException("critical policy qualifiers present in certificate");
                }
                boolean bl6 = PolicyChecker.processParents(n2, bl4, bl2, policyNodeImpl2, string, set3, false);
                if (bl6) continue;
                PolicyChecker.processParents(n2, bl4, bl2, policyNodeImpl2, string, set3, true);
            }
            if (bl5 && (n5 > 0 || n5 == -1)) {
                if (debug != null) {
                    debug.println("PolicyChecker.processPolicies() processing policy: 2.5.29.32.0");
                }
                PolicyChecker.processParents(n2, bl4, bl2, policyNodeImpl2, ANY_POLICY, set2, true);
            }
            policyNodeImpl2.prune(n2);
            object = policyNodeImpl2.getChildren();
            if (!object.hasNext()) {
                policyNodeImpl2 = null;
            }
        } else if (certificatePoliciesExtension == null) {
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() no policies present in cert");
            }
            policyNodeImpl2 = null;
        }
        if (policyNodeImpl2 != null && !bl3) {
            policyNodeImpl2 = PolicyChecker.processPolicyMappings(x509CertImpl, n2, n4, policyNodeImpl2, bl4, set2);
        }
        if (policyNodeImpl2 != null && !set.contains(ANY_POLICY) && certificatePoliciesExtension != null) {
            policyNodeImpl2 = PolicyChecker.removeInvalidNodes(policyNodeImpl2, n2, set, certificatePoliciesExtension);
        }
        if (bl3) {
            n3 = PolicyChecker.mergeExplicitPolicy(n3, x509CertImpl, bl3);
        }
        if (n3 == 0 && policyNodeImpl2 == null) {
            throw new CertPathValidatorException("non-null policy tree required and policy tree is null");
        }
        return policyNodeImpl2;
    }

    private static boolean processParents(int n2, boolean bl2, boolean bl3, PolicyNodeImpl policyNodeImpl, String string, Set set, boolean bl4) throws CertPathValidatorException {
        boolean bl5 = false;
        if (debug != null) {
            debug.println("PolicyChecker.processParents(): matchAny = " + bl4);
        }
        Set set2 = policyNodeImpl.getPolicyNodesExpected(n2 - 1, string, bl4);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl2 = (PolicyNodeImpl)iterator.next();
            if (debug != null) {
                debug.println("PolicyChecker.processParents() found parent:\n" + policyNodeImpl2.asString());
            }
            bl5 = true;
            String string2 = policyNodeImpl2.getValidPolicy();
            PolicyNodeImpl policyNodeImpl3 = null;
            HashSet hashSet = null;
            if (string.equals(ANY_POLICY)) {
                Set set3 = policyNodeImpl2.getExpectedPolicies();
                Iterator iterator2 = set3.iterator();
                block1: while (iterator2.hasNext()) {
                    Object object;
                    String string3 = (String)iterator2.next();
                    Iterator iterator3 = policyNodeImpl2.getChildren();
                    while (iterator3.hasNext()) {
                        object = (PolicyNodeImpl)iterator3.next();
                        String string4 = ((PolicyNodeImpl)object).getValidPolicy();
                        if (!string3.equals(string4)) continue;
                        if (debug == null) continue block1;
                        debug.println(string4 + " in parent's " + "expected policy set already appears in " + "child node");
                        continue block1;
                    }
                    object = new HashSet();
                    object.add(string3);
                    policyNodeImpl3 = new PolicyNodeImpl(policyNodeImpl2, string3, set, bl2, (Set)object, false);
                }
                continue;
            }
            hashSet = new HashSet();
            hashSet.add(string);
            policyNodeImpl3 = new PolicyNodeImpl(policyNodeImpl2, string, set, bl2, hashSet, false);
        }
        return bl5;
    }

    private static PolicyNodeImpl processPolicyMappings(X509CertImpl x509CertImpl, int n2, int n3, PolicyNodeImpl policyNodeImpl, boolean bl2, Set set) throws CertPathValidatorException {
        Object object;
        PolicyMappingsExtension policyMappingsExtension = x509CertImpl.getPolicyMappingsExtension();
        if (policyMappingsExtension == null) {
            return policyNodeImpl;
        }
        if (debug != null) {
            debug.println("PolicyChecker.processPolicyMappings() inside policyMapping check");
        }
        Vector vector = null;
        try {
            vector = (Vector)policyMappingsExtension.get("map");
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("PolicyChecker.processPolicyMappings() mapping exception");
                iOException.printStackTrace();
            }
            throw new CertPathValidatorException("Exception while checking mapping", iOException);
        }
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < vector.size()) {
            PolicyNodeImpl policyNodeImpl2;
            Object object2;
            Object object3;
            object = (CertificatePolicyMap)vector.get(n4);
            String string = ((CertificatePolicyMap)object).getIssuerIdentifier().getIdentifier().toString();
            String string2 = ((CertificatePolicyMap)object).getSubjectIdentifier().getIdentifier().toString();
            if (debug != null) {
                debug.println("PolicyChecker.processPolicyMappings() issuerDomain = " + string);
                debug.println("PolicyChecker.processPolicyMappings() subjectDomain = " + string2);
            }
            if (string.equals(ANY_POLICY)) {
                throw new CertPathValidatorException("encountered an issuerDomainPolicy of ANY_POLICY");
            }
            if (string2.equals(ANY_POLICY)) {
                throw new CertPathValidatorException("encountered a subjectDomainPolicy of ANY_POLICY");
            }
            Set set2 = policyNodeImpl.getPolicyNodesValid(n2, string);
            if (!set2.isEmpty()) {
                object3 = set2.iterator();
                while (object3.hasNext()) {
                    object2 = (PolicyNodeImpl)object3.next();
                    if (n3 > 0 || n3 == -1) {
                        ((PolicyNodeImpl)object2).addExpectedPolicy(string2);
                        continue;
                    }
                    if (n3 != 0) continue;
                    policyNodeImpl2 = (PolicyNodeImpl)((PolicyNodeImpl)object2).getParent();
                    if (debug != null) {
                        debug.println("PolicyChecker.processPolicyMappings() before deleting: policy tree = " + policyNodeImpl);
                    }
                    policyNodeImpl2.deleteChild((PolicyNode)object2);
                    bl3 = true;
                    if (debug == null) continue;
                    debug.println("PolicyChecker.processPolicyMappings() after deleting: policy tree = " + policyNodeImpl);
                }
            } else if (n3 > 0 || n3 == -1) {
                object3 = policyNodeImpl.getPolicyNodesValid(n2, ANY_POLICY);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    policyNodeImpl2 = (PolicyNodeImpl)object2.next();
                    PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)policyNodeImpl2.getParent();
                    HashSet hashSet = new HashSet();
                    hashSet.add(string2);
                    PolicyNodeImpl policyNodeImpl4 = new PolicyNodeImpl(policyNodeImpl3, string, set, bl2, hashSet, true);
                }
            }
            ++n4;
        }
        if (bl3) {
            policyNodeImpl.prune(n2);
            object = policyNodeImpl.getChildren();
            if (!object.hasNext()) {
                if (debug != null) {
                    debug.println("setting rootNode to null");
                }
                policyNodeImpl = null;
            }
        }
        return policyNodeImpl;
    }

    private static PolicyNodeImpl removeInvalidNodes(PolicyNodeImpl policyNodeImpl, int n2, Set set, CertificatePoliciesExtension certificatePoliciesExtension) throws CertPathValidatorException {
        Object object;
        Vector vector = null;
        try {
            vector = (Vector)certificatePoliciesExtension.get("policies");
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Exception while retrieving policyOIDs", iOException);
        }
        boolean bl2 = false;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (PolicyInformation)iterator.next();
            String string = ((PolicyInformation)object).getPolicyIdentifier().getIdentifier().toString();
            if (debug != null) {
                debug.println("PolicyChecker.processPolicies() processing policy second time: " + string);
            }
            Set set2 = policyNodeImpl.getPolicyNodesValid(n2, string);
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                PolicyNodeImpl policyNodeImpl2 = (PolicyNodeImpl)iterator2.next();
                PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)policyNodeImpl2.getParent();
                if (!policyNodeImpl3.getValidPolicy().equals(ANY_POLICY) || set.contains(string) || string.equals(ANY_POLICY)) continue;
                if (debug != null) {
                    debug.println("PolicyChecker.processPolicies() before deleting: policy tree = " + policyNodeImpl);
                }
                policyNodeImpl3.deleteChild(policyNodeImpl2);
                bl2 = true;
                if (debug == null) continue;
                debug.println("PolicyChecker.processPolicies() after deleting: policy tree = " + policyNodeImpl);
            }
        }
        if (bl2) {
            policyNodeImpl.prune(n2);
            object = policyNodeImpl.getChildren();
            if (!object.hasNext()) {
                policyNodeImpl = null;
            }
        }
        return policyNodeImpl;
    }

    PolicyNode getPolicyTree() {
        if (this.rootNode == null) {
            return null;
        }
        PolicyNodeImpl policyNodeImpl = this.rootNode.copyTree();
        policyNodeImpl.setImmutable();
        return policyNodeImpl;
    }
}

