/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.HashSet;
import sun.awt.X11GraphicsConfig;

public class X11GraphicsDevice
extends GraphicsDevice {
    int screen;
    private static DisplayMode displayMode;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    HashSet doubleBufferVisuals;

    public X11GraphicsDevice(int n2) {
        this.screen = n2;
    }

    private static native void initIDs();

    public int getScreen() {
        return this.screen;
    }

    public native long getDisplay();

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        return ":0." + this.screen;
    }

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            int n2 = 0;
            int n3 = this.getNumConfigs(this.screen);
            graphicsConfigurationArray = new GraphicsConfiguration[n3];
            if (this.defaultConfig != null) {
                graphicsConfigurationArray[0] = this.defaultConfig;
                ++n2;
            }
            if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
            }
            while (n2 < n3) {
                int n4 = this.getConfigVisualId(n2, this.screen);
                boolean bl2 = X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals.contains(new Integer(n4));
                graphicsConfigurationArray[n2] = X11GraphicsConfig.getConfig(this, n4, bl2);
                ++n2;
            }
            this.configs = graphicsConfigurationArray;
        }
        return graphicsConfigurationArray;
    }

    public native int getNumConfigs(int var1);

    public native int getConfigVisualId(int var1, int var2);

    public static native boolean isDBESupported();

    private void addDoubleBufferVisual(int n2) {
        this.doubleBufferVisuals.add(new Integer(n2));
    }

    private native void getDoubleBufferVisuals(int var1);

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            int n2 = this.getConfigVisualId(0, this.screen);
            boolean bl2 = false;
            if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
                bl2 = this.doubleBufferVisuals.contains(new Integer(n2));
            }
            this.defaultConfig = X11GraphicsConfig.getConfig(this, n2, bl2);
        }
        return this.defaultConfig;
    }

    public DisplayMode getDisplayMode() {
        if (displayMode == null) {
            GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            displayMode = new DisplayMode(rectangle.width, rectangle.height, -1, 0);
        }
        return displayMode;
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            X11GraphicsDevice.initIDs();
        }
    }
}

