/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Enumeration;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

class HRuleView
extends View {
    private float topMargin;
    private float bottomMargin;
    private float leftMargin;
    private float rightMargin;
    private int alignment = 0;
    private String noshade = null;
    private int size = 0;
    private CSS.LengthValue widthValue;
    private static final int SPACE_ABOVE = 3;
    private static final int SPACE_BELOW = 3;
    private AttributeSet attr;

    public HRuleView(Element element) {
        super(element);
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        Object object;
        StyleSheet styleSheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        AttributeSet attributeSet = this.getElement().getAttributes();
        this.attr = styleSheet.getViewAttributes(this);
        this.alignment = 0;
        this.size = 0;
        this.noshade = null;
        this.widthValue = null;
        Enumeration enumeration = this.attr.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
        }
        if (this.attr != null) {
            this.alignment = StyleConstants.getAlignment(this.attr);
            this.noshade = (String)attributeSet.getAttribute(HTML.Attribute.NOSHADE);
            object = attributeSet.getAttribute(HTML.Attribute.SIZE);
            if (object != null && object instanceof String) {
                this.size = Integer.parseInt((String)object);
            }
            if ((object = this.attr.getAttribute(CSS.Attribute.WIDTH)) != null && object instanceof CSS.LengthValue) {
                this.widthValue = (CSS.LengthValue)object;
            }
            this.topMargin = this.getLength(CSS.Attribute.MARGIN_TOP, this.attr);
            this.bottomMargin = this.getLength(CSS.Attribute.MARGIN_BOTTOM, this.attr);
            this.leftMargin = this.getLength(CSS.Attribute.MARGIN_LEFT, this.attr);
            this.rightMargin = this.getLength(CSS.Attribute.MARGIN_RIGHT, this.attr);
        } else {
            this.rightMargin = 0.0f;
            this.leftMargin = 0.0f;
            this.bottomMargin = 0.0f;
            this.topMargin = 0.0f;
        }
        this.size = Math.max(2, this.size);
    }

    private float getLength(CSS.Attribute attribute, AttributeSet attributeSet) {
        CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(attribute);
        float f2 = lengthValue != null ? lengthValue.getValue() : 0.0f;
        return f2;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n2 = 0;
        int n3 = rectangle.y + 3 + (int)this.topMargin;
        int n4 = rectangle.width - (int)(this.leftMargin + this.rightMargin);
        if (this.widthValue != null) {
            n4 = (int)this.widthValue.getValue(n4);
        }
        int n5 = rectangle.height - (6 + (int)this.topMargin + (int)this.bottomMargin);
        if (this.size > 0) {
            n5 = this.size;
        }
        switch (this.alignment) {
            case 1: {
                n2 = rectangle.x + rectangle.width / 2 - n4 / 2;
                break;
            }
            case 2: {
                n2 = rectangle.x + rectangle.width - n4 - (int)this.rightMargin;
                break;
            }
            default: {
                n2 = rectangle.x + (int)this.leftMargin;
            }
        }
        if (this.noshade != null) {
            graphics.setColor(Color.black);
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            Color color;
            Color color2;
            Color color3 = this.getContainer().getBackground();
            if (color3 == null || color3.equals(Color.white)) {
                color2 = Color.darkGray;
                color = Color.lightGray;
            } else {
                color2 = Color.darkGray;
                color = Color.white;
            }
            graphics.setColor(color);
            graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 1);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
            graphics.setColor(color2);
            graphics.drawLine(n2, n3, n2 + n4 - 1, n3);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 1);
        }
    }

    public float getPreferredSpan(int n2) {
        switch (n2) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                if (this.size > 0) {
                    return (float)(this.size + 3 + 3) + this.topMargin + this.bottomMargin;
                }
                if (this.noshade != null) {
                    return 8.0f + this.topMargin + this.bottomMargin;
                }
                return 6.0f + this.topMargin + this.bottomMargin;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    public int getResizeWeight(int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return 0;
        }
        return 0;
    }

    public int getBreakWeight(int n2, float f2, float f3) {
        if (n2 == 0) {
            return 3000;
        }
        return 0;
    }

    public View breakView(int n2, int n3, float f2, float f3) {
        return null;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        int n3 = this.getStartOffset();
        int n4 = this.getEndOffset();
        if (n2 >= n3 && n2 <= n4) {
            Rectangle rectangle = shape.getBounds();
            if (n2 == n4) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f2 < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n2 = documentEvent.getOffset();
        if (n2 <= this.getStartOffset() && n2 + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }
}

