/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class MetalToggleButtonUI
extends BasicToggleButtonUI {
    private static final MetalToggleButtonUI metalToggleButtonUI = new MetalToggleButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalToggleButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
            this.defaults_initialized = true;
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            if (buttonModel.isSelected()) {
                graphics.setColor(jComponent.getBackground());
            } else {
                graphics.setColor(this.getDisabledTextColor());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        boolean bl2;
        Rectangle rectangle4 = new Rectangle();
        String string = abstractButton.getText();
        boolean bl3 = bl2 = abstractButton.getIcon() != null;
        if (string != null && !string.equals("")) {
            if (!bl2) {
                rectangle4.setBounds(rectangle2);
            } else {
                rectangle4.setBounds(rectangle3.union(rectangle2));
            }
        } else if (bl2) {
            rectangle4.setBounds(rectangle3);
        }
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
    }
}

