/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicInternalFrameTitlePane
extends JComponent {
    protected JMenuBar menuBar;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected JMenu windowMenu;
    protected JInternalFrame frame;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected Icon maxIcon;
    protected Icon minIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    protected static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    protected static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    protected static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    protected static final String MOVE_CMD = UIManager.getString("InternalFrameTitlePane.moveButtonText");
    protected static final String SIZE_CMD = UIManager.getString("InternalFrameTitlePane.sizeButtonText");
    private String closeButtonToolTip;
    private String iconButtonToolTip;
    private String restoreButtonToolTip;
    private String maxButtonToolTip;
    static /* synthetic */ Class class$javax$swing$JInternalFrame;

    public BasicInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.createActionMap();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
        this.moveAction = new MoveAction();
        this.sizeAction = new SizeAction();
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("showSystemMenu", new ShowSystemMenuAction(true));
        actionMapUIResource.put("hideSystemMenu", new ShowSystemMenuAction(false));
        return actionMapUIResource;
    }

    protected void installListeners() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installDefaults() {
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.closeButtonToolTip = UIManager.getString("InternalFrame.closeButtonToolTip");
        this.iconButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        this.restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        this.maxButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
    }

    protected void uninstallDefaults() {
    }

    protected void createButtons() {
        this.iconButton = new NoFocusButton();
        this.iconButton.addActionListener(this.iconifyAction);
        if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
            this.iconButton.setToolTipText(this.iconButtonToolTip);
        }
        this.maxButton = new NoFocusButton();
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new NoFocusButton();
        this.closeButton.addActionListener(this.closeAction);
        if (this.closeButtonToolTip != null && this.closeButtonToolTip.length() != 0) {
            this.closeButton.setToolTipText(this.closeButtonToolTip);
        }
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(this.minIcon);
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.restoreButtonToolTip);
            }
            this.maxButton.setIcon(this.maxIcon);
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        } else if (this.frame.isMaximum()) {
            this.iconButton.setIcon(this.iconIcon);
            this.maxButton.setIcon(this.minIcon);
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.restoreButtonToolTip);
            }
        } else {
            this.iconButton.setIcon(this.iconIcon);
            if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.iconButtonToolTip);
            }
            this.maxButton.setIcon(this.maxIcon);
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        }
        this.closeButton.setIcon(this.closeIcon);
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
    }

    protected void addSystemMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    protected JMenu createSystemMenu() {
        return new JMenu("    ");
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void showSystemMenu() {
        this.windowMenu.doClick();
    }

    public void paintComponent(Graphics graphics) {
        this.paintTitleBackground(graphics);
        if (this.frame.getTitle() != null) {
            int n2;
            boolean bl2 = this.frame.isSelected();
            Font font = graphics.getFont();
            graphics.setFont(this.getFont());
            if (bl2) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            String string = this.frame.getTitle();
            if (BasicGraphicsUtils.isLeftToRight(this.frame)) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                n2 = this.menuBar.getX() + this.menuBar.getWidth() + 2;
                int n4 = rectangle.x - n2 - 3;
                string = this.getTitle(this.frame.getTitle(), fontMetrics, n4);
            } else {
                n2 = this.menuBar.getX() - 2 - SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            graphics.drawString(string, n2, n3);
            graphics.setFont(font);
        }
    }

    protected void paintTitleBackground(Graphics graphics) {
        boolean bl2 = this.frame.isSelected();
        if (bl2) {
            graphics.setColor(this.selectedTitleColor);
        } else {
            graphics.setColor(this.notSelectedTitleColor);
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n2) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n3 > n2) {
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            int n5 = 0;
            while (n5 < string.length()) {
                if ((n4 += fontMetrics.charWidth(string.charAt(n5))) > n2) break;
                ++n5;
            }
            string = string.substring(0, n5) + string2;
        }
        return string;
    }

    protected void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if ((class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = BasicInternalFrameTitlePane.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        jInternalFrame.dispatchEvent(internalFrameEvent);
    }

    protected void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void paint(Graphics graphics) {
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            if (icon == null) {
                icon = UIManager.getIcon("InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image image = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(image.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, graphics, 0, 0);
            }
        }

        public boolean isOpaque() {
            return true;
        }
    }

    public class SizeAction
    extends AbstractAction {
        public SizeAction() {
            super(SIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private boolean show;

        public ShowSystemMenuAction(boolean bl2) {
            this.show = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.show) {
                BasicInternalFrameTitlePane.this.windowMenu.doClick();
            } else {
                BasicInternalFrameTitlePane.this.windowMenu.setVisible(false);
            }
        }
    }

    public class MoveAction
    extends AbstractAction {
        public MoveAction() {
            super(MOVE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(RESTORE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                block4: {
                    if (!BasicInternalFrameTitlePane.this.frame.isMaximizable() || !BasicInternalFrameTitlePane.this.frame.isMaximum()) break block4;
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break block5;
                }
                if (!BasicInternalFrameTitlePane.this.frame.isIconifiable() || !BasicInternalFrameTitlePane.this.frame.isIcon()) break block5;
                try {
                    BasicInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(ICONIFY_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                if (!BasicInternalFrameTitlePane.this.frame.isIconifiable()) break block6;
                if (!BasicInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(MAXIMIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                if (!BasicInternalFrameTitlePane.this.frame.isMaximizable()) break block6;
                if (!BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(CLOSE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.frame.doDefaultCloseAction();
            }
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            int n3;
            int n4 = 22;
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                n4 += 19;
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                n4 += 19;
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                n4 += 19;
            }
            FontMetrics fontMetrics = BasicInternalFrameTitlePane.this.getFontMetrics(BasicInternalFrameTitlePane.this.getFont());
            String string = BasicInternalFrameTitlePane.this.frame.getTitle();
            int n5 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n6 = n3 = string != null ? string.length() : 0;
            n4 = n3 > 3 ? (n4 += n5 < (n2 = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n5 : n2) : (n4 += n5);
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            int n7 = fontMetrics.getHeight();
            n7 += 2;
            int n8 = 0;
            if (icon != null) {
                n8 = Math.min(icon.getIconHeight(), 16);
            }
            int n9 = Math.max(n7, n8 += 2);
            Dimension dimension = new Dimension(n4, n9);
            if (BasicInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = BasicInternalFrameTitlePane.this.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }

        public void layoutContainer(Container container) {
            boolean bl2 = BasicGraphicsUtils.isLeftToRight(BasicInternalFrameTitlePane.this.frame);
            int n2 = BasicInternalFrameTitlePane.this.getWidth();
            int n3 = BasicInternalFrameTitlePane.this.getHeight();
            int n4 = BasicInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            int n5 = 0;
            if (icon != null) {
                n5 = icon.getIconHeight();
            }
            int n6 = bl2 ? 2 : n2 - 16 - 2;
            BasicInternalFrameTitlePane.this.menuBar.setBounds(n6, (n3 - n5) / 2, 16, 16);
            int n7 = n6 = bl2 ? n2 - 16 - 2 : 2;
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.closeButton.setBounds(n6, (n3 - n4) / 2, 16, 14);
                n6 += bl2 ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                BasicInternalFrameTitlePane.this.maxButton.setBounds(n6, (n3 - n4) / 2, 16, 14);
                n6 += bl2 ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                BasicInternalFrameTitlePane.this.iconButton.setBounds(n6, (n3 - n4) / 2, 16, 14);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selected".equals(string)) {
                BasicInternalFrameTitlePane.this.repaint();
                return;
            }
            if ("icon".equals(string) || "maximum".equals(string)) {
                BasicInternalFrameTitlePane.this.setButtonIcons();
                BasicInternalFrameTitlePane.this.enableActions();
                return;
            }
            if (string.equals("closable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.closeButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.closeButton);
                }
            } else if (string.equals("maximizable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.maxButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.maxButton);
                }
            } else if (string.equals("iconable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.iconButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.iconButton);
                }
            }
            BasicInternalFrameTitlePane.this.enableActions();
            BasicInternalFrameTitlePane.this.revalidate();
            BasicInternalFrameTitlePane.this.repaint();
        }
    }
}

