/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.util.EventObject;
import javax.swing.tree.TreePath;

public class TreeModelEvent
extends EventObject {
    protected TreePath path;
    protected int[] childIndices;
    protected Object[] children;

    public TreeModelEvent(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        this(object, new TreePath(objectArray), nArray, objectArray2);
    }

    public TreeModelEvent(Object object, TreePath treePath, int[] nArray, Object[] objectArray) {
        super(object);
        this.path = treePath;
        this.childIndices = nArray;
        this.children = objectArray;
    }

    public TreeModelEvent(Object object, Object[] objectArray) {
        this(object, new TreePath(objectArray));
    }

    public TreeModelEvent(Object object, TreePath treePath) {
        super(object);
        this.path = treePath;
        this.childIndices = new int[0];
    }

    public TreePath getTreePath() {
        return this.path;
    }

    public Object[] getPath() {
        if (this.path != null) {
            return this.path.getPath();
        }
        return null;
    }

    public Object[] getChildren() {
        if (this.children != null) {
            int n2 = this.children.length;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.children, 0, objectArray, 0, n2);
            return objectArray;
        }
        return null;
    }

    public int[] getChildIndices() {
        if (this.childIndices != null) {
            int n2 = this.childIndices.length;
            int[] nArray = new int[n2];
            System.arraycopy(this.childIndices, 0, nArray, 0, n2);
            return nArray;
        }
        return null;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + " " + Integer.toString(this.hashCode()));
        if (this.path != null) {
            stringBuffer.append(" path " + this.path);
        }
        if (this.childIndices != null) {
            stringBuffer.append(" indices [ ");
            n2 = 0;
            while (n2 < this.childIndices.length) {
                stringBuffer.append(Integer.toString(this.childIndices[n2]) + " ");
                ++n2;
            }
            stringBuffer.append("]");
        }
        if (this.children != null) {
            stringBuffer.append(" children [ ");
            n2 = 0;
            while (n2 < this.children.length) {
                stringBuffer.append(this.children[n2] + " ");
                ++n2;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

