/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private static final int BUFFER_LENGTH = 1024;
    private byte[] buf = new byte[1024];
    private long length = 0L;
    private boolean foundEOF = false;

    public FileCacheImageInputStream(InputStream inputStream, File file) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        this.stream = inputStream;
        this.cacheFile = File.createTempFile("imageio", ".tmp", file);
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    private long readUntil(long l2) throws IOException {
        if (l2 < this.length) {
            return l2;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l3 = l2 - this.length;
        this.cache.seek(this.length);
        while (l3 > 0L) {
            int n2 = this.stream.read(this.buf, 0, (int)Math.min(l3, 1024L));
            if (n2 == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n2);
            this.cache.write(this.buf, 0, n2);
            l3 -= (long)n2;
            this.length += (long)n2;
        }
        return l2;
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        long l2 = this.streamPos + 1L;
        long l3 = this.readUntil(l2);
        if (l3 >= l2) {
            this.cache.seek(this.streamPos++);
            return this.cache.read();
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        long l2 = this.readUntil(this.streamPos + (long)n3);
        n3 = (int)Math.min((long)n3, l2 - this.streamPos);
        if (n3 > 0) {
            this.cache.seek(this.streamPos);
            this.cache.readFully(byArray, n2, n3);
            this.streamPos += (long)n3;
            return n3;
        }
        return -1;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.stream = null;
    }
}

