/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final Class TYPE = Class.getPrimitiveClass("double");
    private double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static String toString(double d2) {
        return new FloatingDecimal(d2).toJavaFormatString();
    }

    public static Double valueOf(String string) throws NumberFormatException {
        return new Double(FloatingDecimal.readJavaFormatString(string).doubleValue());
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).doubleValue();
    }

    public static boolean isNaN(double d2) {
        return d2 != d2;
    }

    public static boolean isInfinite(double d2) {
        return d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY;
    }

    public Double(double d2) {
        this.value = d2;
    }

    public Double(String string) throws NumberFormatException {
        this(Double.valueOf(string));
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.value);
        return (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(((Double)object).value) == Double.doubleToLongBits(this.value);
    }

    public static native long doubleToLongBits(double var0);

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    public int compareTo(Double d2) {
        return Double.compare(this.value, d2.value);
    }

    public int compareTo(Object object) {
        return this.compareTo((Double)object);
    }

    public static int compare(double d2, double d3) {
        long l2;
        if (d2 < d3) {
            return -1;
        }
        if (d2 > d3) {
            return 1;
        }
        long l3 = Double.doubleToLongBits(d2);
        return l3 == (l2 = Double.doubleToLongBits(d3)) ? 0 : (l3 < l2 ? -1 : 1);
    }
}

