/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

abstract class SunFileReader
extends AudioFileReader {
    private static SunFileReader[] fileReaders;
    protected static final int bisBufferSize = 4096;
    private static final String[] fileReaderClassNames;

    public abstract AudioFileFormat getAudioFileFormat(InputStream var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioFileFormat getAudioFileFormat(URL var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioFileFormat getAudioFileFormat(File var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioInputStream getAudioInputStream(InputStream var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioInputStream getAudioInputStream(URL var1) throws UnsupportedAudioFileException, IOException;

    public abstract AudioInputStream getAudioInputStream(File var1) throws UnsupportedAudioFileException, IOException;

    static int getNumFileReaders() {
        return fileReaders.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SunFileReader getFileReader(int n2) {
        SunFileReader[] sunFileReaderArray = fileReaders;
        synchronized (fileReaders) {
            try {
                if (fileReaders[n2] == null) {
                    Class clazz = Class.forName(fileReaderClassNames[n2]);
                    SunFileReader.fileReaders[n2] = (SunFileReader)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return fileReaders[n2];
        }
    }

    protected int rllong(DataInputStream dataInputStream) throws IOException {
        int n2 = 0;
        n2 = dataInputStream.readInt();
        int n3 = (n2 & 0xFF) << 24;
        int n4 = (n2 & 0xFF00) << 8;
        int n5 = (n2 & 0xFF0000) >> 8;
        int n6 = (n2 & 0xFF000000) >>> 24;
        n2 = n3 | n4 | n5 | n6;
        return n2;
    }

    protected int big2little(int n2) {
        int n3 = (n2 & 0xFF) << 24;
        int n4 = (n2 & 0xFF00) << 8;
        int n5 = (n2 & 0xFF0000) >> 8;
        int n6 = (n2 & 0xFF000000) >>> 24;
        n2 = n3 | n4 | n5 | n6;
        return n2;
    }

    protected short rlshort(DataInputStream dataInputStream) throws IOException {
        short s2 = 0;
        s2 = dataInputStream.readShort();
        short s3 = (short)((s2 & 0xFF) << 8);
        short s4 = (short)((s2 & 0xFF00) >>> 8);
        s2 = (short)(s3 | s4);
        return s2;
    }

    protected short big2littleShort(short s2) {
        short s3 = (short)((s2 & 0xFF) << 8);
        short s4 = (short)((s2 & 0xFF00) >>> 8);
        s2 = (short)(s3 | s4);
        return s2;
    }

    static {
        fileReaderClassNames = new String[]{"com.sun.media.sound.AuFileReader", "com.sun.media.sound.WaveFileReader", "com.sun.media.sound.AiffFileReader"};
        fileReaders = new SunFileReader[fileReaderClassNames.length];
    }
}

