/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.io.ByteToCharCp1257;
import sun.io.CharToByteCp1257;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByteDecoder;
import sun.nio.cs.SingleByteEncoder;
import sun.nio.cs.StandardCharsets;

public class MS1257
extends Charset
implements HistoricallyNamedCharset {
    public String historicalName() {
        return "Cp1257";
    }

    public MS1257() {
        super("windows-1257", StandardCharsets.aliasesFor((String)"windows-1257"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS1257;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends SingleByteEncoder {
        private static CharToByteCp1257 c2b = new CharToByteCp1257();

        public Encoder(Charset charset) {
            super(charset, c2b.getIndex1(), c2b.getIndex2(), 65280, 255, 8);
        }
    }

    private static class Decoder
    extends SingleByteDecoder {
        private static ByteToCharCp1257 b2c = new ByteToCharCp1257();

        public Decoder(Charset charset) {
            super(charset, b2c.getByteToCharTable());
        }
    }
}

