/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.AppInputStream;
import com.sun.net.ssl.internal.ssl.AppOutputStream;
import com.sun.net.ssl.internal.ssl.BaseSSLSocketImpl;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.OutputRecord;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLProtocolAlertException;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_a1;
import com.sun.net.ssl.internal.ssl.SunJSSE_aw;
import com.sun.net.ssl.internal.ssl.SunJSSE_ax;
import com.sun.net.ssl.internal.ssl.SunJSSE_az;
import com.sun.net.ssl.internal.ssl.SunJSSE_h;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;

final class SSLSocketImpl
extends BaseSSLSocketImpl {
    private static final int a = 0;
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 3;
    private static final int e = 4;
    private static final int f = 5;
    private static final int g = 6;
    private static final int h = 7;
    static final byte i = 0;
    static final byte j = 1;
    static final byte k = 2;
    private int l;
    private boolean m;
    private SSLException n;
    private byte o;
    private boolean p;
    private CipherSuiteList q;
    private boolean r = true;
    private String s;
    private boolean t = true;
    private Object u;
    Object v;
    private Object w;
    private Object x;
    private SunJSSE_a1 y;
    private SunJSSE_a1 z;
    private SunJSSE_h aa;
    private SunJSSE_h ab;
    private SSLContextImpl ac;
    private SSLSessionImpl ad;
    private SunJSSE_ax ae;
    private HashMap af;
    private InputStream ag;
    private OutputStream ah;
    private AppInputStream ai;
    private AppOutputStream aj;
    private ProtocolList ak;
    private ProtocolVersion al = ProtocolVersion.g;
    private static final Debug am = Debug.getInstance("ssl");

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n) throws IOException, UnknownHostException {
        this.a(sSLContextImpl, false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n) throws IOException, UnknownHostException {
        this.a(sSLContextImpl, false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        this.a(sSLContextImpl, false);
        this.bind(new InetSocketAddress(inetAddress, n2));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException, UnknownHostException {
        this.a(sSLContextImpl, false);
        this.bind(new InetSocketAddress(inetAddress2, n2));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, boolean bl, CipherSuiteList cipherSuiteList, byte by, boolean bl2, ProtocolList protocolList) throws IOException {
        this.o = by;
        this.r = bl2;
        this.a(sSLContextImpl, bl);
        this.q = cipherSuiteList;
        this.ak = protocolList;
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl) {
        this.a(sSLContextImpl, false);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, String string, int n, boolean bl) throws IOException {
        super(socket);
        if (!socket.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.s = string;
        this.a(sSLContextImpl, false);
        this.t = bl;
        this.a();
    }

    private void a(SSLContextImpl sSLContextImpl, boolean bl) {
        this.ac = sSLContextImpl;
        this.ad = SSLSessionImpl.a;
        this.p = bl;
        this.l = 0;
        this.aa = SunJSSE_h.a;
        this.y = SunJSSE_a1.a;
        this.ab = SunJSSE_h.a;
        this.z = SunJSSE_a1.a;
        this.q = CipherSuiteList.f();
        this.ak = ProtocolList.b();
        this.u = new Object();
        this.v = new Object();
        this.w = new Object();
        this.x = new Object();
        this.ai = new AppInputStream(this.al, this);
        this.aj = new AppOutputStream(this.al, this);
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (((BaseSSLSocketImpl)this).a != this) {
            throw new SocketException("Already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new SocketException("Cannot handle non-Inet socket addresses.");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        super.connect(socketAddress, n);
        this.s = inetSocketAddress.getHostName();
        this.a();
    }

    void a() throws IOException {
        if (((BaseSSLSocketImpl)this).a == this) {
            this.ag = super.getInputStream();
            this.ah = super.getOutputStream();
        } else {
            this.ag = ((BaseSSLSocketImpl)this).a.getInputStream();
            this.ah = ((BaseSSLSocketImpl)this).a.getOutputStream();
        }
        this.i();
    }

    private synchronized int h() {
        return this.l;
    }

    private synchronized void a(int n) {
        this.l = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(OutputRecord outputRecord) throws IOException {
        block9: while (outputRecord.d() == 23) {
            switch (this.h()) {
                case 1: {
                    this.j();
                    break;
                }
                case 2: 
                case 3: {
                    break block9;
                }
                case 4: {
                    this.a((byte)0, "error while writing to socket");
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.n != null) {
                        throw this.n;
                    }
                    throw new SocketException("Socket closed");
                }
                default: {
                    throw new SSLProtocolException("State error, send app data");
                }
            }
        }
        Object object = this.v;
        synchronized (object) {
            if (!outputRecord.b()) {
                outputRecord.a(this.z);
                outputRecord.a(this.ab);
                outputRecord.a(this.ah);
            }
        }
    }

    void a(InputRecord inputRecord) throws IOException {
        if (this.h() == 1) {
            this.j();
        }
        this.a(inputRecord, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(InputRecord inputRecord, boolean bl) throws IOException {
        Object object = this.w;
        synchronized (object) {
            int n;
            while ((n = this.h()) != 6 && n != 4 && n != 7) {
                try {
                    inputRecord.a(false);
                    inputRecord.read(this.ag, this.ah);
                }
                catch (SSLProtocolAlertException sSLProtocolAlertException) {
                    int n2 = sSLProtocolAlertException.getAlertCause();
                    this.a((byte)(n2 == 0 ? 10 : (byte)n2), sSLProtocolAlertException);
                }
                catch (SSLProtocolException sSLProtocolException) {
                    try {
                        this.a((byte)10, sSLProtocolException);
                        throw sSLProtocolException;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw sSLProtocolException;
                }
                catch (EOFException eOFException) {
                    boolean bl2;
                    boolean bl3 = this.h() <= 1;
                    boolean bl4 = bl2 = BaseSSLSocketImpl.c || bl3;
                    if (am != null && Debug.isOn("ssl")) {
                        System.out.println(SSLSocketImpl.n() + ", received EOFException: " + (bl2 ? "error" : "ignored"));
                    }
                    if (bl2) {
                        SSLException sSLException = bl3 ? new SSLHandshakeException("Remote host closed connection during handshake") : new SSLProtocolException("Remote host closed connection incorrectly");
                        sSLException.initCause(eOFException);
                        throw sSLException;
                    }
                    this.b(false);
                    continue;
                }
                try {
                    inputRecord.a(this.aa);
                }
                catch (BadPaddingException badPaddingException) {
                    this.a((byte)20, "Invalid padding", badPaddingException);
                }
                if (!inputRecord.a(this.y)) {
                    if (inputRecord.c() == 22) {
                        this.a((byte)40, "bad handshake record MAC");
                    } else {
                        this.a((byte)20, "bad record MAC");
                    }
                }
                SSLSocketImpl sSLSocketImpl = this;
                synchronized (sSLSocketImpl) {
                    switch (inputRecord.c()) {
                        case 22: {
                            this.i();
                            this.m = false;
                            this.ae.a(inputRecord);
                            if (this.ae.f()) {
                                this.ad = this.ae.g();
                                this.ae = null;
                                this.l = 2;
                                if (this.af != null) {
                                    final HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.ad);
                                    Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                                        public Object run() {
                                            return new NotifyHandshakeThread(SSLSocketImpl.this.af.entrySet(), handshakeCompletedEvent);
                                        }
                                    });
                                    thread.start();
                                }
                            }
                            if (!bl) {
                                if (this.l == 2) return;
                            }
                            break;
                        }
                        case 23: {
                            if (this.l != 2 && this.l != 3 && this.l != 5) {
                                throw new SSLProtocolException("Data received in non-data state: " + this.l);
                            }
                            if (this.m) {
                                throw new SSLProtocolException("Expecting finished message, received data");
                            }
                            if (!bl) {
                                throw new SSLException("Discarding app data");
                            }
                            inputRecord.a(true);
                            return;
                        }
                        case 21: {
                            this.b(inputRecord);
                            break;
                        }
                        case 20: {
                            if (this.l != 1 && this.l != 3 || inputRecord.available() != 1 || inputRecord.read() != 1) {
                                this.a((byte)10, "illegal change cipher spec msg, state = " + this.l);
                            }
                            this.m();
                            this.m = true;
                            break;
                        }
                        default: {
                            if (am != null && Debug.isOn("ssl")) {
                                System.out.println("Received record type: " + inputRecord.c());
                            }
                            break;
                        }
                    }
                }
            }
            inputRecord.close();
            return;
        }
    }

    AppInputStream b() {
        return this.ai;
    }

    SunJSSE_aw c() throws SSLException {
        this.i();
        return (SunJSSE_aw)this.ae;
    }

    private void i() {
        switch (this.l) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.l = this.l == 0 ? 1 : 3;
        this.ae = this.p ? new SunJSSE_aw(this, this.ac, this.ak, this.o) : new SunJSSE_az(this, this.ac, this.ak);
        this.ae.o = this.q;
        this.ae.a(this.r);
        if (this.l == 3) {
            this.ae.g.b.b(this.al);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void j() throws IOException {
        Object object = this.u;
        synchronized (object) {
            if (this.h() == 1) {
                this.k();
                this.a(this.ai.c, false);
            }
        }
    }

    public void startHandshake() throws IOException {
        block3: {
            this.e();
            try {
                if (this.h() == 1) {
                    this.j();
                    break block3;
                }
                this.k();
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private synchronized void k() throws IOException {
        switch (this.l) {
            case 1: {
                break;
            }
            case 2: {
                this.i();
                break;
            }
            case 3: {
                return;
            }
            case 0: {
                throw new SocketException("handshaking attempted on unconnected socket");
            }
            default: {
                throw new SocketException("connection is closed");
            }
        }
        if (!this.ae.h()) {
            if (this.ae instanceof SunJSSE_az) {
                this.ae.i();
            } else if (this.l != 1) {
                this.ae.i();
                this.ae.e.a();
            }
        }
    }

    public boolean isClosed() {
        return this.h() == 7;
    }

    boolean d() throws IOException {
        switch (this.h()) {
            case 0: {
                throw new SocketException("Socket is not connected");
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 7: {
                throw new SocketException("Socket is closed");
            }
        }
        if (this.n == null) {
            return true;
        }
        SSLException sSLException = new SSLException("Connection has been shutdown: " + this.n);
        sSLException.initCause(this.n);
        throw sSLException;
    }

    void e() throws IOException {
        if (this.d() || this.h() == 5) {
            throw new SocketException("Connection closed by remote host");
        }
    }

    private void l() throws IOException {
        if (am != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.n() + ", called closeSocket()");
        }
        if (((BaseSSLSocketImpl)this).a == this) {
            super.close();
        } else {
            ((BaseSSLSocketImpl)this).a.close();
        }
    }

    public void close() throws IOException {
        if (am != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.n() + ", called close()");
        }
        this.b(true);
        this.a(7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void b(boolean bl) throws IOException {
        if (am != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.n() + ", called closeInternal(" + bl + ")");
        }
        if (this.ai != null && this.ai.c != null) {
            this.ai.c.close();
        }
        int n = this.h();
        try {
            switch (n) {
                case 0: {
                    break;
                }
                case 4: {
                    this.l();
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    if (am != null && Debug.isOn("ssl")) {
                        System.out.println("close invoked again; state = " + this.h());
                    }
                    if (!bl) break;
                    Object object = this.x;
                    // MONITORENTER : object
                    if (am != null && Debug.isOn("ssl")) {
                        System.out.println("after primary close; state = " + this.h());
                    }
                    // MONITOREXIT : object
                    break;
                }
                default: {
                    Object object = this.x;
                    // MONITORENTER : object
                    n = this.h();
                    if (n == 6 || n == 4 || n == 7) {
                        // MONITOREXIT : object
                        Object var8_5 = null;
                        int n2 = n == 7 ? 7 : 6;
                        this.a(n2);
                        return;
                    }
                    SSLSocketImpl sSLSocketImpl = this;
                    // MONITORENTER : sSLSocketImpl
                    this.a((byte)0);
                    this.l = 5;
                    // MONITOREXIT : sSLSocketImpl
                    if (((BaseSSLSocketImpl)this).a == this) {
                        super.close();
                    } else if (this.t) {
                        ((BaseSSLSocketImpl)this).a.close();
                    } else if (bl) {
                        this.a(false);
                    }
                    this.a(6);
                    // MONITOREXIT : object
                    break;
                }
            }
            Object var8_6 = null;
            int n3 = n == 7 ? 7 : 6;
            this.a(n3);
            return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            int n4 = n == 7 ? 7 : 6;
            this.a(n4);
            throw throwable;
        }
    }

    void a(boolean bl) throws IOException {
        block5: {
            if (am != null && Debug.isOn("ssl")) {
                System.out.println("waiting for close_notify or alert: state " + this.h());
            }
            try {
                int n;
                InputRecord inputRecord = new InputRecord(this.al);
                inputRecord.a();
                while ((n = this.h()) != 6 && n != 4 && n != 7) {
                    this.a(inputRecord, true);
                }
            }
            catch (IOException iOException) {
                if (am != null && Debug.isOn("ssl")) {
                    System.out.println("Exception while waiting for close " + iOException);
                }
                if (!bl) break block5;
                throw iOException;
            }
        }
    }

    synchronized void a(Exception exception) throws IOException {
        if (am != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.n() + ", handling exception: " + exception.toString());
        }
        if (exception instanceof InterruptedIOException) {
            throw (IOException)exception;
        }
        if (this.n != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw BaseSSLSocketImpl.a((byte)80, exception, "Unexpected exception");
        }
        boolean bl = exception instanceof SSLException;
        if (!bl && exception instanceof IOException) {
            try {
                this.a((byte)10, exception);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw (IOException)exception;
        }
        byte by = bl ? (byte)10 : 80;
        this.a(by, exception);
    }

    void a(byte by) {
        this.a((byte)1, by);
    }

    synchronized void a(byte by, String string) throws IOException {
        this.a(by, string, null);
    }

    synchronized void a(byte by, Throwable throwable) throws IOException {
        this.a(by, null, throwable);
    }

    synchronized void a(byte by, String string, Throwable throwable) throws IOException {
        if (this.ai != null && this.ai.c != null) {
            this.ai.c.close();
        }
        this.ad.invalidate();
        int n = this.l;
        this.l = 4;
        if (this.n == null) {
            this.a((byte)2, by);
            this.n = throwable instanceof SSLException ? (SSLException)throwable : BaseSSLSocketImpl.a(by, throwable, string);
        }
        this.l();
        this.l = n == 7 ? 7 : 6;
        throw this.n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(InputRecord inputRecord) throws IOException {
        Object object;
        byte by = (byte)inputRecord.read();
        byte by2 = (byte)inputRecord.read();
        if (by2 == -1) {
            this.a((byte)47, "Short alert message");
        }
        if (am != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            object = System.out;
            synchronized (object) {
                System.out.print(SSLSocketImpl.n());
                System.out.print(", RECV " + this.al + " ALERT:  ");
                if (by == 2) {
                    System.out.print("fatal, ");
                } else if (by == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & by) + ">, ");
                }
                System.out.println(BaseSSLSocketImpl.b(by2));
            }
        }
        if (by == 1) {
            if (by2 == 0) {
                if (this.l == 1) {
                    this.a((byte)10, "Received close_notify during handshake");
                } else {
                    this.b(false);
                }
            } else if (this.ae != null) {
                this.ae.b(by2);
            }
        } else {
            object = "Received fatal alert: " + BaseSSLSocketImpl.b(by2);
            if (this.n == null) {
                this.n = BaseSSLSocketImpl.b(by2, (String)object);
            }
            this.a((byte)10, (String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(byte by, byte by2) {
        block11: {
            boolean bl;
            if (this.l >= 6) {
                return;
            }
            OutputRecord outputRecord = new OutputRecord(this.al, 21);
            boolean bl2 = bl = am != null && Debug.isOn("ssl");
            if (bl) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(SSLSocketImpl.n());
                    System.out.print(", SEND " + this.al + " ALERT:  ");
                    if (by == 2) {
                        System.out.print("fatal, ");
                    } else if (by == 1) {
                        System.out.print("warning, ");
                    } else {
                        System.out.print("<level = " + (0xFF & by) + ">, ");
                    }
                    System.out.println("description = " + BaseSSLSocketImpl.b(by2));
                }
            }
            outputRecord.write(by);
            outputRecord.write(by2);
            try {
                this.a(outputRecord);
            }
            catch (IOException iOException) {
                if (!bl) break block11;
                System.out.println("Exception sending alert: " + iOException);
            }
        }
    }

    private void m() throws SSLException {
        if (this.l != 1 && this.l != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            this.aa = this.ae.b();
            this.y = this.ae.d();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(noSuchAlgorithmException);
        }
    }

    void f() throws SSLException {
        if (this.l != 1 && this.l != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            this.ab = this.ae.c();
            this.z = this.ae.e();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(noSuchAlgorithmException);
        }
    }

    synchronized void a(ProtocolVersion protocolVersion) {
        this.al = protocolVersion;
        this.ai.c.a(protocolVersion);
        this.aj.b.a(protocolVersion);
    }

    synchronized String g() {
        if (this.s == null) {
            this.s = this.getInetAddress().getHostName();
        }
        return this.s;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.l == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.ai;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.l == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.aj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSession getSession() {
        block6: {
            if (this.h() == 1) {
                try {
                    this.startHandshake();
                }
                catch (IOException iOException) {
                    if (am == null || !Debug.isOn("handshake")) break block6;
                    System.out.println("IOException in getSession():  " + iOException);
                }
            }
        }
        SSLSocketImpl sSLSocketImpl = this;
        synchronized (sSLSocketImpl) {
            return this.ad;
        }
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.r = bl;
        if (this.ae != null && !this.ae.h()) {
            this.ae.a(this.r);
        }
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.r;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.o = (byte)(bl ? 2 : 0);
        if (this.ae != null && this.ae instanceof SunJSSE_aw && !this.ae.h()) {
            ((SunJSSE_aw)this.ae).a(this.o);
        }
    }

    public synchronized boolean getNeedClientAuth() {
        return this.o == 2;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        byte by = this.o = bl ? (byte)1 : 0;
        if (this.ae != null && this.ae instanceof SunJSSE_aw && !this.ae.h()) {
            ((SunJSSE_aw)this.ae).a(this.o);
        }
    }

    public synchronized boolean getWantClientAuth() {
        return this.o == 1;
    }

    public synchronized void setUseClientMode(boolean bl) {
        switch (this.l) {
            case 0: {
                this.p = !bl;
                break;
            }
            case 1: {
                if (this.ae == null || this.ae.h()) break;
                this.p = !bl;
                this.l = 0;
                this.i();
                break;
            }
            default: {
                if (am != null && Debug.isOn("ssl")) {
                    System.out.println("setUseClientMode() invoked in state = " + this.l);
                }
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    public synchronized boolean getUseClientMode() {
        return !this.p;
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList.d();
        return CipherSuiteList.e().c();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.q = new CipherSuiteList(stringArray);
        if (this.ae != null && !this.ae.h()) {
            this.ae.o = this.q;
        }
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.q.c();
    }

    public String[] getSupportedProtocols() {
        return ProtocolList.c().a();
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.ak = new ProtocolList(stringArray);
        if (this.ae != null && !this.ae.h()) {
            this.ae.a(this.ak);
        }
    }

    public synchronized String[] getEnabledProtocols() {
        return this.ak.a();
    }

    public void setSoTimeout(int n) throws SocketException {
        if (am != null && Debug.isOn("ssl")) {
            System.out.println("setSoTimeout(" + n + ") called");
        }
        if (((BaseSSLSocketImpl)this).a == this) {
            super.setSoTimeout(n);
        } else {
            ((BaseSSLSocketImpl)this).a.setSoTimeout(n);
        }
    }

    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.af == null) {
            this.af = new HashMap(4);
        }
        this.af.put(handshakeCompletedListener, AccessController.getContext());
    }

    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.af == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (this.af.remove(handshakeCompletedListener) == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.af.isEmpty()) {
            this.af = null;
        }
    }

    private static String n() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        stringBuffer.append(this.ad.getCipherSuite());
        stringBuffer.append(": ");
        if (((BaseSSLSocketImpl)this).a == this) {
            stringBuffer.append(super.toString());
        } else {
            stringBuffer.append(((BaseSSLSocketImpl)this).a.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static class NotifyHandshakeThread
    extends Thread {
        private Set a;
        private HandshakeCompletedEvent b;

        NotifyHandshakeThread(Set set, HandshakeCompletedEvent handshakeCompletedEvent) {
            this.a = set;
            this.b = handshakeCompletedEvent;
        }

        public void run() {
            Iterator iterator = this.a.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)entry.getKey();
                AccessControlContext accessControlContext = (AccessControlContext)entry.getValue();
                AccessController.doPrivileged(new PrivilegedAction(this, handshakeCompletedListener){
                    private final /* synthetic */ HandshakeCompletedListener a;
                    private final /* synthetic */ NotifyHandshakeThread b;
                    {
                        this.b = notifyHandshakeThread;
                        this.a = handshakeCompletedListener;
                    }

                    public Object run() {
                        this.a.handshakeCompleted(NotifyHandshakeThread.a(this.b));
                        return null;
                    }
                }, accessControlContext);
            }
        }

        static /* synthetic */ HandshakeCompletedEvent a(NotifyHandshakeThread notifyHandshakeThread) {
            return notifyHandshakeThread.b;
        }
    }
}

