/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.proxy;

import java.net.URL;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import sun.plugin.net.protocol.rmi.RMIPluginSocketFactory;
import sun.plugin.net.proxy.AutoProxyHandler;
import sun.plugin.net.proxy.BrowserProxyConfig;
import sun.plugin.net.proxy.BrowserProxyHandler;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.DirectProxyHandler;
import sun.plugin.net.proxy.ManualProxyHandler;
import sun.plugin.net.proxy.ProxyConfigException;
import sun.plugin.net.proxy.ProxyHandler;
import sun.plugin.net.proxy.ProxyInfo;
import sun.plugin.net.proxy.SmartProxyHandler;
import sun.plugin.net.proxy.UserDefinedProxyConfig;
import sun.plugin.services.ServiceProvider;
import sun.plugin.services.ServiceUnavailableException;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;

public class PluginProxyManager {
    private static HashMap proxyCache;
    private static ProxyHandler handler;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$plugin$net$proxy$PluginProxyManager;

    public static synchronized ProxyInfo getProxyInfo(URL uRL) {
        ProxyInfo proxyInfo;
        block4: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(uRL.getProtocol());
            stringBuffer.append(uRL.getHost());
            stringBuffer.append(uRL.getPort());
            String string = stringBuffer.toString();
            proxyInfo = null;
            if (handler.isProxyCacheSupported()) {
                proxyInfo = (ProxyInfo)proxyCache.get(string);
            }
            if (proxyInfo != null) break block4;
            try {
                ProxyInfo[] proxyInfoArray = handler.getProxyInfo(uRL);
                proxyInfo = proxyInfoArray[0];
                if (proxyInfo == null) {
                    proxyInfo = new ProxyInfo(null);
                }
                proxyCache.put(string.toString(), proxyInfo);
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                Trace.msgNetPrintln("net.proxy.service.not_available", new Object[]{uRL});
                proxyInfo = new ProxyInfo(null);
            }
        }
        return proxyInfo;
    }

    public static synchronized void reset() {
        try {
            Object object;
            proxyCache.clear();
            UserDefinedProxyConfig userDefinedProxyConfig = new UserDefinedProxyConfig();
            BrowserProxyInfo browserProxyInfo = userDefinedProxyConfig.getBrowserProxyInfo();
            if (browserProxyInfo.getType() == 3) {
                object = ServiceProvider.getService();
                BrowserProxyConfig browserProxyConfig = object.getProxyConfig();
                browserProxyInfo = browserProxyConfig.getBrowserProxyInfo();
            }
            switch (browserProxyInfo.getType()) {
                case 3: {
                    try {
                        handler = new SmartProxyHandler(new BrowserProxyHandler());
                        handler.init(browserProxyInfo);
                        break;
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                case 0: {
                    try {
                        handler = new DirectProxyHandler();
                        handler.init(browserProxyInfo);
                        break;
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                case 1: {
                    try {
                        handler = new ManualProxyHandler();
                        handler.init(browserProxyInfo);
                        break;
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.msgNetPrintln("net.proxy.loading.manual.error");
                        try {
                            browserProxyInfo.setType(0);
                            handler = new DirectProxyHandler();
                            handler.init(browserProxyInfo);
                            break;
                        }
                        catch (ProxyConfigException proxyConfigException2) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                }
                case 2: {
                    try {
                        handler = new SmartProxyHandler(new AutoProxyHandler());
                        handler.init(browserProxyInfo);
                        break;
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.msgNetPrintln("net.proxy.loading.auto.error");
                        try {
                            browserProxyInfo.setType(1);
                            handler = new ManualProxyHandler();
                            handler.init(browserProxyInfo);
                            break;
                        }
                        catch (ProxyConfigException proxyConfigException3) {
                            Trace.msgNetPrintln("net.proxy.loading.manual.error");
                            try {
                                browserProxyInfo.setType(0);
                                handler = new DirectProxyHandler();
                                handler.init(browserProxyInfo);
                                break;
                            }
                            catch (ProxyConfigException proxyConfigException4) {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                break;
                            }
                        }
                    }
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            try {
                if (browserProxyInfo.getType() != 0) {
                    RMISocketFactory.setSocketFactory((RMISocketFactory)((Object)new RMIPluginSocketFactory()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = browserProxyInfo;
            AccessController.doPrivileged(new PrivilegedAction((BrowserProxyInfo)object){
                private final /* synthetic */ BrowserProxyInfo val$info;
                {
                    this.val$info = browserProxyInfo;
                }

                public Object run() {
                    try {
                        PluginProxyManager.setProperties(this.val$info);
                    }
                    catch (SecurityException securityException) {}
                    return null;
                }
            });
            System.err.println(browserProxyInfo.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            DialogFactory.showExceptionDialog(throwable);
        }
    }

    public static void setProperties(BrowserProxyInfo browserProxyInfo) {
        int n;
        Properties properties = System.getProperties();
        int n2 = browserProxyInfo.getType();
        StringBuffer stringBuffer = new StringBuffer();
        if (browserProxyInfo.getHttpHost() != null) {
            stringBuffer.append("http=" + browserProxyInfo.getHttpHost());
            if (browserProxyInfo.getHttpPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getHttpPort());
            }
        }
        if (browserProxyInfo.getHttpsHost() != null) {
            stringBuffer.append(",https=" + browserProxyInfo.getHttpsHost());
            if (browserProxyInfo.getHttpsPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getHttpsPort());
            }
        }
        if (browserProxyInfo.getFtpHost() != null) {
            stringBuffer.append(",ftp=" + browserProxyInfo.getFtpHost());
            if (browserProxyInfo.getFtpPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getFtpPort());
            }
        }
        if (browserProxyInfo.getGopherHost() != null) {
            stringBuffer.append(",gopher=" + browserProxyInfo.getGopherHost());
            if (browserProxyInfo.getGopherPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getGopherPort());
            }
        }
        if (browserProxyInfo.getSocksHost() != null) {
            stringBuffer.append(",socks=" + browserProxyInfo.getSocksHost());
            if (browserProxyInfo.getSocksPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getSocksPort());
            }
        }
        String string = stringBuffer.toString();
        String[] stringArray = browserProxyInfo.getOverrides();
        String string2 = null;
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            boolean bl = true;
            n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        properties.remove("javaplugin.proxy.config.type");
        properties.remove("javaplugin.proxy.config.list");
        properties.remove("javaplugin.proxy.config.bypass");
        if (n2 == 0) {
            properties.put("javaplugin.proxy.config.type", "direct");
        } else if (n2 == 1) {
            properties.put("javaplugin.proxy.config.type", "manual");
            if (string != null) {
                properties.put("javaplugin.proxy.config.list", string);
            }
            if (string2 != null) {
                properties.put("javaplugin.proxy.config.bypass", string2);
            }
        } else if (n2 == 2) {
            properties.put("javaplugin.proxy.config.type", "auto");
        } else if (n2 == 3) {
            properties.put("javaplugin.proxy.config.type", "browser");
        } else {
            properties.put("javaplugin.proxy.config.type", "unknown");
        }
        if (n2 == 1) {
            String string3 = browserProxyInfo.getSocksHost();
            n = browserProxyInfo.getSocksPort();
            if (string3 != null) {
                properties.put("socksProxyHost", string3);
            }
            if (n != -1) {
                properties.put("socksProxyPort", new Integer(n));
            }
        }
        System.setProperties(properties);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$plugin$net$proxy$PluginProxyManager == null ? (class$sun$plugin$net$proxy$PluginProxyManager = PluginProxyManager.class$("sun.plugin.net.proxy.PluginProxyManager")) : class$sun$plugin$net$proxy$PluginProxyManager).desiredAssertionStatus();
        proxyCache = new HashMap();
        handler = null;
    }
}

